/* The Thing class for something that occupies an arena tile and has a graphic.
 *
 * Copyright (c) 2003 Ole Laursen.
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA.
 */

#ifndef THING_HPP
#define THING_HPP

#include <memory>

#include "vector.hpp"
#include "helpers.hpp"

class Graphic;

class Thing: noncopyable
{
public:
  // take over ownership of graphic
  Thing(Graphic *graphic);
  virtual ~Thing();

  // moves graphic to tile and registers with arena
  void occupy_tile(Vector<int> pos);

  Graphic &get_graphic();
  Vector<int> tile_pos;
  
private:
  std::auto_ptr<Graphic> graphic;
};

#endif
