/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dionua@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "javalistviewitem.h"

#include <string.h>

#include "midlet.h"



int JavaListViewItem::compare(QListViewItem * i, int col, bool ascending) const
{
/*
Columns:
0 N = idx
1 Name = midletName
2 Vendor = midletVendor
3 Version = b2.b4.b6
4 Size = size[3]
5 Icon = ico1
6 Caption = menuName
7 startup = StarupClass
*/
	if ((col > 0 && col < 4) || col > 4 )
		return QListViewItem::compare(i, col, ascending);
	
	return text(col).toULong(0) - i->text(col).toULong(0);
}

void JavaListViewItem::getMidlet(Midlet *m)
{
	union
	{
		char ch[4];
		int size;
	} un4;
	
	QString s;
	memset(m, 0x00, sizeof(Midlet));
	m->showInMenu=1;
	m->idx=text(0).toInt();
	strcpy(m->name, text(1).latin1());
	strcpy(m->vendor, text(2).latin1());
	s=text(3);
	m->b2=s.section('.',0,0).toInt();
	m->b4=s.section('.',1,1).toInt();
	m->b6=s.section('.',2,2).toInt();
	m->b8=1;
	
	un4.size=text(4).toInt();
	m->size[0]=un4.ch[2];
	m->size[1]=un4.ch[1];
	m->size[2]=un4.ch[0];
	
	m->ico1=(text(5)[0]=='Y') ? 1:0;
	strcpy(m->menuName, text(6).latin1());
	strcpy(m->startupClass, text(7).latin1());
	
}
