var sbDoc, sbBody, counts, sortOrder, isSideBar;
var activeElt = null;
var toolTipEnabled = false;
var scrollPos = 0;

var sbFrame = document.getElementById("theFrame");
document.getElementById(mgPrefs.prefs.getCharPref("sideBarSort")).setAttribute('checked', true);
isSideBar = parent.mgWindowType ? true : false;

if (window.arguments && window.arguments[0] == "standalone") {
  isSideBar = true;
}

if (isSideBar) {
  try {
    scrollPos = mgPrefs.prefs.getIntPref("sideBarPos");
  }
  catch (e) {}
  addEventListener("scroll", getScrollPos, true);
  toolTipEnabled = mgPrefs.prefs.getBoolPref("sideBarToolTip");
}

if (!isSideBar) {
  sbFrame.removeAttribute("context");
  sbFrame.removeAttribute("oncontextmenu");
  document.getElementById("printToolbox").removeAttribute("hidden");
}

function addObserver() {
  Components.classes["@mozilla.org/observer-service;1"]
            .getService(Components.interfaces.nsIObserverService)
            .addObserver(mgSidebarObserver, "mozgestControl", false);

  mgPrefs.prefs.QueryInterface(Components.interfaces.nsIPrefBranchInternal)
         .addObserver("", mgSidebarObserver, false);

  if (!isSideBar)
    document.title = document.documentElement.getAttribute("mgPrint");
}

function removeObserver() {
  Components.classes["@mozilla.org/observer-service;1"]
            .getService(Components.interfaces.nsIObserverService)
            .removeObserver(mgSidebarObserver, "mozgestControl");

  mgPrefs.prefs.QueryInterface(Components.interfaces.nsIPrefBranchInternal)
         .removeObserver("", mgSidebarObserver);
}

var mgSidebarObserver = {
  observe: function(subject, topic, data) {
    if (topic == "mozgestControl") {
      if (data == "mappingsUpdated")
        setTimeout("sbFrame.webNavigation.reload(0)", 0);
    }

    if (topic.indexOf("nsPref") == 0) {
      if (data == "enableStrokes" ||
          data == "enableRockers" ||
          data == "enableWheelRockers")
        setTimeout("sbFrame.webNavigation.reload(0)", 0);

      if (data == "sideBarToolTip") {
        if (isSidebar)
          toolTipEnabled = mgPrefs.prefs.getBoolPref("sideBarToolTip");
      }
    }
  }
}

function reloadFrame(aID) {
  mgPrefs.prefs.setCharPref("sideBarSort", aID)
  sbFrame.webNavigation.reload(0)
}

function updateGestureHistory(target) {
  while (target.childNodes.length > 1)
    target.removeChild(target.firstChild);

  var h = parent.mgState.history;

  for (var x = 0; x < h.length; x++) {
    var item = document.createElement("menuitem");
    item.setAttribute("label", h[x][0] + "  ");
    item.setAttribute("acceltext", h[x][1]);
    item.setAttribute("disabled", true);
    item.setAttribute("mgMenuItem", true);
    target.insertBefore(item, target.lastChild);
  }
}

function fillIn() {
  sbDoc = sbFrame.contentDocument;
  sbBody = sbDoc.body;
  sbBody.setAttribute("isSideBar", isSideBar);

  // Allow localizers to define font size
  var fontSize;
  try {
    fontSize = mgGetString("fontSize." + (isSideBar ? "sidebar" : "print"));
  }
  catch (e) {
    fontSize = null;
  }
  if (fontSize)
    sbBody.setAttribute("style", "font-size: " + fontSize);

  prepareInject("window", false);
  for (component in _mgMS.supportedWindows)
    prepareInject(component, false);

  //print default mappings
  if (!isSideBar) {
    sbBody.appendChild(sbDoc.createElement("hr"));
    prepareInject("window", true);
    for (component in _mgMS.supportedWindows)
      prepareInject(component, true);
  }
}

function prepareInject(component, readDef) {
  var mappingsSet;

  if (!readDef)
    mappingsSet = _mgMS.activeMappings[component];
  else
    mappingsSet = _mgMS.defaultMappings[component];

  counts = new Array();

  for (mapping in mappingsSet) {
    var mName       = null;
    var mCount      = null;

    if (mappingsSet[mapping].name)
      mName = decodeURIComponent(mappingsSet[mapping].name);
    else
      mName = mgGetString(mappingsSet[mapping].func);

    if (mappingsSet[mapping].count)
      mCount = mappingsSet[mapping].count;

    counts[counts.length] = { component : component,
                              code : mapping,
                              name : mName,
                              count : mCount };
  }

  if (counts.length == 0)
    return;

  if (mgPrefs.prefs.getCharPref("sideBarSort") == "sortByName") {
    counts.sort(function(a, b) {return ((a.name.toLowerCase())>(b.name.toLowerCase()) ? 1 : -1)} );
    sortOrder = "sortByName";
  }
  else {
    counts.sort(function(a, b) {return ((a.count)>(b.count) ? 1 : -1)} );
    sortOrder = "sortByUsage";
  }

  inject(document.documentElement.getAttribute(component), readDef);
}

function inject(wType, readDef) {
  // calculate length
  if (!readDef) {
    var gLength = 0;
    for (var xx=0; xx < counts.length; xx++) {
      if (counts[xx].code.indexOf(":") == 0) {
        var isWheel = isNaN(counts[xx].code.substring(1));

        if ((isWheel && !mgPrefs.prefs.getBoolPref("enableWheelRockers")) ||
            (!isWheel && !mgPrefs.prefs.getBoolPref("enableRockers")))
          continue;
      }

      else if (!mgPrefs.prefs.getBoolPref("enableStrokes"))
        continue

      gLength++;
    }

    if (gLength < 1)
      return;
  }

  var head = sbDoc.createElement("span");
  head.className = "component";

  if (!isSideBar) {
    if (!readDef)
      head.appendChild(sbDoc.createTextNode(document
                       .documentElement.getAttribute("mgActive") + wType));
    else
      head.appendChild(sbDoc.createTextNode(document
                       .documentElement.getAttribute("mgDefault") + wType));
  }
  else
    head.appendChild(sbDoc.createTextNode(wType));

  sbBody.appendChild(head);

  var rowEven = false;
  var table = sbDoc.createElement("table");
  table.className = "mTable";
  table.setAttribute("width", "100%");
  table.setAttribute("cellspacing", 0);
  sbBody.appendChild(table);

  for (var x=0; x < counts.length; x++) {
    if (counts[x].code.indexOf(":") == 0 && !readDef) {
      var isWheel = isNaN(counts[x].code.substring(1));

      if ((isWheel && !mgPrefs.prefs.getBoolPref("enableWheelRockers")) ||
          (!isWheel && !mgPrefs.prefs.getBoolPref("enableRockers")))
        continue;
    }

    if (counts[x].code.indexOf(":") != 0 && !readDef) {
      if (!mgPrefs.prefs.getBoolPref("enableStrokes"))
        continue;
    }

    rowEven = !rowEven;
    var tRow = sbDoc.createElement("tr");
    tRow.setAttribute("class", (rowEven ? 'even' : 'odd'));
    tRow.mgWindowType = counts[x].component;
    tRow.mgCode = counts[x].code;

    var left = sbDoc.createElement("td");
    left.appendChild(sbDoc.createTextNode(counts[x].name));
    var right = sbDoc.createElement("td");
    right.setAttribute("align", "right");
    right.className = "gesture";
    right.mgTooltip = true;
    right.mgTCode = counts[x].code;
    right.mgTWindowType = counts[x].component;
    tRow.appendChild(left);
    tRow.appendChild(right);
    table.appendChild(tRow);

    var aGest = counts[x].code;

    if (!isSideBar && parseInt(mgAppInfo.version) < 3)
      right.appendChild(sbDoc.createTextNode(mgMappingLocalizer.localize(aGest)));
    else
      sbDoc.defaultView.createGestureBox(aGest, right);
  }
}

function setScrollPos() {
  if (isSideBar)
    sbDoc.defaultView.scrollTo(0, scrollPos);
}

function getScrollPos() {
  scrollPos = sbBody.scrollTop;
  mgPrefs.prefs.setIntPref("sideBarPos", scrollPos);
}

function handleContextMenu(elt) {
  document.getElementById("editThis").setAttribute("hidden", true);

  if (activeElt)
    activeElt.removeAttribute("contextVisible");

  while (elt && elt.nodeName.toLowerCase() != "html") {
    if (elt.mgWindowType) {
      document.getElementById("editThis").setAttribute("hidden", false);
      elt.setAttribute("contextVisible", true);
      activeElt = elt;
      break;
    }
    elt = elt.parentNode;
  }
  sbBody.setAttribute("contextVisible", true);
}

function mgFillToolTip() {
  if (!toolTipEnabled ||
      sbBody.hasAttribute("contextVisible") ||
      !isSideBar)
    return false;

  var mgTNode = document.tooltipNode;
  var mgT2 = document.getElementById("mgToolTipLabel_2");
  var mgT4 = document.getElementById("mgToolTipLabel_4");

  var showToolTip = false;

  try {
    for (mgTNode; mgTNode; mgTNode = mgTNode.parentNode) {
      if (mgTNode.mgTooltip) {
        mgT2.value = mgMappingLocalizer.localize(mgTNode.mgTCode);
        mgT4.value = _mgMS.activeMappings[mgTNode.mgTWindowType][mgTNode.mgTCode].count;
        showToolTip = true;
        break;
      }
      if (mgTNode == sbBody)
        break;
    }
    return showToolTip;
  }
  catch (e) {return false}
}