//=============================================================================
//  MuseScore
//  Linux Music Score Editor
//  $Id:$
//
//  Copyright (C) 2002-2007 Werner Schweer and others
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License version 2.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//=============================================================================

#include "editstaff.h"
#include "staff.h"
#include "part.h"
#include "editdrumset.h"
#include "score.h"
#include "layout.h"

//---------------------------------------------------------
//   EditStaff
//---------------------------------------------------------

EditStaff::EditStaff(Staff* s, QWidget* parent)
   : QDialog(parent)
      {
      staff = s;
      setupUi(this);

      showStaff->setChecked(staff->part()->show());
      useDrumset->setChecked(staff->part()->useDrumset());
      editDrumset->setEnabled(staff->part()->useDrumset());
      lines->setValue(staff->lines());
      small->setChecked(staff->small());
      transposition->setValue(staff->part()->pitchOffset());
      shortName->setHtml(staff->part()->shortName().toHtml("UTF-8"));
      longName->setHtml(staff->part()->longName().toHtml("UTF-8"));

      connect(buttonBox, SIGNAL(clicked(QAbstractButton*)), this, SLOT(bboxClicked(QAbstractButton*)));
      connect(editDrumset, SIGNAL(clicked()), SLOT(editDrumsetClicked()));
      }

//---------------------------------------------------------
//   bboxClicked
//---------------------------------------------------------

void EditStaff::bboxClicked(QAbstractButton* button)
      {
      QDialogButtonBox::ButtonRole br = buttonBox->buttonRole(button);
      switch(br) {
            case QDialogButtonBox::ApplyRole:
                  apply();
                  break;

            case QDialogButtonBox::AcceptRole:
                  apply();
                  // fall through

            case QDialogButtonBox::RejectRole:
                  close();
                  break;

            default:
                  printf("EditStaff: unknown button %d\n", int(br));
                  break;
            }
      }


//---------------------------------------------------------
//   apply
//---------------------------------------------------------

void EditStaff::apply()
      {
      staff->part()->setShow(showStaff->isChecked());
      staff->part()->setUseDrumset(useDrumset->isChecked());
      staff->part()->setPitchOffset(transposition->value());
      editDrumset->setEnabled(staff->part()->useDrumset());
      staff->setLines(lines->value());
      staff->setSmall(small->isChecked());
      staff->part()->setShortName(*shortName->document());
      staff->part()->setLongName(*longName->document());
      staff->score()->mainLayout()->setInstrumentNames();
      }

//---------------------------------------------------------
//   editDrumsetClicked
//---------------------------------------------------------

void EditStaff::editDrumsetClicked()
      {
      EditDrumset dse(staff->part()->drumset(), this);
      dse.exec();
      }

