/*
 * Decompiled with CFR 0.152.
 */
package org.cdavies.itunes.hash;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.cdavies.itunes.hash.ItunesHash;
import org.cdavies.itunes.utils.HexString;

public class Itunes4Hash
implements ItunesHash {
    public static int HASH_SIZE = 32;
    private String _staticHash = null;
    private static String _appleCopyright = "Copyright 2003 Apple Computer, Inc.";

    public Itunes4Hash() throws NoSuchAlgorithmException {
        this.calculateStaticHash();
    }

    private void calculateStaticHash() throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("md5");
        StringBuffer stringBuffer = new StringBuffer(8192);
        for (int i = 0; i < 256; ++i) {
            if ((i & 0x80) != 0) {
                messageDigest.update("Accept-Language".getBytes());
            } else {
                messageDigest.update("user-agent".getBytes());
            }
            if ((i & 0x40) != 0) {
                messageDigest.update("max-age".getBytes());
            } else {
                messageDigest.update("Authorization".getBytes());
            }
            if ((i & 0x20) != 0) {
                messageDigest.update("Client-DAAP-Version".getBytes());
            } else {
                messageDigest.update("Accept-Encoding".getBytes());
            }
            if ((i & 0x10) != 0) {
                messageDigest.update("daap.protocolversion".getBytes());
            } else {
                messageDigest.update("daap.songartist".getBytes());
            }
            if ((i & 8) != 0) {
                messageDigest.update("daap.songcomposer".getBytes());
            } else {
                messageDigest.update("daap.songdatemodified".getBytes());
            }
            if ((i & 4) != 0) {
                messageDigest.update("daap.songdiscnumber".getBytes());
            } else {
                messageDigest.update("daap.songdisabled".getBytes());
            }
            if ((i & 2) != 0) {
                messageDigest.update("playlist-item-spec".getBytes());
            } else {
                messageDigest.update("revision-number".getBytes());
            }
            if ((i & 1) != 0) {
                messageDigest.update("session-id".getBytes());
            } else {
                messageDigest.update("content-codes".getBytes());
            }
            stringBuffer.append(HexString.bytesToHexString(messageDigest.digest()));
        }
        this._staticHash = stringBuffer.toString();
    }

    public String generateHash(String string, int n, int n2) {
        MessageDigest messageDigest;
        if (this._staticHash == null) {
            return null;
        }
        int n3 = HASH_SIZE * n;
        int n4 = n3 + HASH_SIZE;
        try {
            messageDigest = MessageDigest.getInstance("md5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        messageDigest.update(string.getBytes());
        messageDigest.update(_appleCopyright.getBytes());
        messageDigest.update(this._staticHash.substring(n3, n4).getBytes());
        return HexString.bytesToHexString(messageDigest.digest());
    }
}

