/* MToolsFM - A graphical Frontend to mtools                                     */
/* earlier versions under the name mfm                                           */
/* Copyright (c) 1999-2001 Christian Ospelkaus <christian@core-coutainville.org> */

/* This program is free software; you can redistribute it and/or                 */
/* modify it under the terms of the GNU General Public License                   */
/* as published by the Free Software Foundation; either version 2                */
/* of the License, or (at your option) any later version.                        */

/* This program is distributed in the hope that it will be useful,               */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 */
/* GNU General Public License for more details.                                  */

/* You should have received a copy of the GNU General Public License             */
/* along with this program; if not, write to the Free Software                   */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.   */

/* Uncomment the following line if you use GTK+ 1.1 */
/* #define OLDGTK */

#define MAX_FILE_LENGTH 256

#define MAX_BUTTON 7
#define BUTTON_OK 1
#define BUTTON_RETRY 2
#define BUTTON_YES 4
#define BUTTON_NO 8
#define BUTTON_SKIP 16
#define BUTTON_ALL 32
#define BUTTON_CANCEL 64

#define OK _("OK")
#define RETRY _("Retry")
#define YES _("Yes")
#define NO _("No")
#define SKIP _("Skip")
#define ALL _("All")
#define CANCEL _("Cancel")

#define FILENAME _("Filename")
#define SIZE _("Size")
#define DATE _("Date")
#define TIME _("Time")

#define COPY_L2R_CONTEXT _("Copy >>>")
#define COPY_L2R_BUTTON _("->\nCopy")
#define COPY_L2R_TOOLTIP _("Copy file(s) from left to right window")

#define COPY_R2L_CONTEXT _("<<< Copy")
#define COPY_R2L_BUTTON _("Copy\n<-")
#define COPY_R2L_TOOLTIP _("Copy file(s) from right to left window")

#define DELETE _("Delete")
#define RENAME _("Rename")
#define PRINT _("Print")
#define MKDIR _("Make directory")

#define UNKNOWN_OPTION _("Unknown option")
#define ERRORWINDOW_INTRO _("This will display any errors or diagnostics from subprocesses.\n")

#define COPYING_FILES _("Copying files. Please wait.")
#define COPY_PROGRESS_LABEL _("Copying files...\n\nThis progressbar will be updated\nafter each copied file.")
#define FILE_EXISTS_TITLE _("File exists")
#define CONFIGURE_TITLE _("Configure MToolsFM")
#define DELETE_TITLE _("Delete files?")
#define RENAME_TITLE _("Rename file / directory")
#define PRINT_TITLE _("Print files")
#define PRINT_QUESTION  _("Enter printer command")
#define SMALL_FLOPPY_DESC _("3.5\" 1.44M floppy")
#define BIG_FLOPPY_DESC _("5.25\" 1.2M floppy")
#define ONLY_ON_UNIX_MSG _("This operation can only be performed\non a mounted UNIX filesystem.")
#define ONLY_ON_UNIX_TITLE _("Operation illegal")
#define NULL_FILESIZE_TITLE _("Illegal file size")
#define NULL_FILESIZE_MSG _("The filesize must be given in bytes\nand must be greater than zero.")
#define NOT_EN_MEM_TIT _("Insufficient disk space")
#define NOT_EN_MEM_MSG _("There is not enough disk space for this operation\nor the directory is write-protected.")
#define TAR_TITLE _("Enter filename for tar file")
#define TAR_QUESTION  _("Please enter the filename for the tar file:")
#define ZIP_TITLE _("Enter filename for zip file")
#define ZIP_QUESTION  _("Please enter the filename for the zip file:")
#define NEW_DIRECTORY_NAME _("New directory")
#define MKDIR_TITLE _("Make directory")
#define MKDIR_QUESTION _("Enter new name for new directory:")
#define ABOUT_TITLE _("About MToolsFM")
#define USE_TITLE _("How to use MToolsFM")
#define COMMAND_TITLE _("Command line options")
#define SELECTED_IN _("bytes selected in")

#define RENAME_1 _("Enter new name for \"")
#define RENAME_2 "\" :"

#define ABOUTMTOOLSFM_1 "MToolsFM V " VERSION 
#define ABOUTMTOOLSFM_2 _("\n\n\
MToolsFM is a graphical frontend for mtools\n\n\
Copyright (c) 1999-2000 Christian Ospelkaus\n\
<christian@core-coutainville.org>\n\n\
For the newest version, see the MToolsFM-homepage at\n\n\
http://www.core-coutainville.org/MToolsFM/\n\n\
MToolsFM comes with ABSOLUTELY NO WARRANTY;\n\
for details see file COPYING. This is free software,\n\
and you are welcome to redistribute it under certain\n\
conditions; again, see file COPYING for details.\n")

#define OLD_COPY_1 _("The file\n\n")
#define OLD_COPY_2 _("\n\nseems to exist in the target directory. If you want to overwrite it,\n\
delete it in the target directory first and copy it again.\n\
NOTE: I cannot overwrite the file because your version of \n\
mtools seems to be too old. Overwriting existing files works\n\
with mtools 3.9.7 or more. You might consider upgrading to the\n\
most recent version of mtools. Information is avilable at \n\n\
http://www.core-coutainville.org/MToolsFM/ and\
http://mtools.linux.lu/\n\n\
Please click \"Yes\" if you would like to try copying the other\n\
files you selected and \"Cancel\" if you would like to cancel this\n\
operation.\n")

#define NEW_F_COPY_1 _("A file with the name\n\n")
#define NEW_F_COPY_2 _("\n\nseems to exist in the target directory. You can either cancel the\n\
operation, skip this particular file, overwrite it (by pressing\n\
the \"yes\" button) or choose to overwrite all files (by pressing\n\
the \"all\" button). Do you want to overwrite this file?\n")

#define NEW_D_COPY_1 _("A file or directory with the name\n\n")
#define NEW_D_COPY_2 _("\n\nseems to exist in the target directory. You can either cancel the\n\
operation, skip this particular directory, overwrite the existing\n\
directory structure (by pressing the \"Yes\" button) or do this with\n\
all other directories which might be in the way (by pressing the \"All\"\n\
button). Do you want to overwrite the existing directory structure?\n")

#define D_DELETE _("\n\nis a directory. Do you want to remove this directory\n\
recursively with all its subdirectories?\n")
#define F_DELETE_1 _("Deleting file\n\n")
#define F_DELETE_2 _("\n\nDo you really want to do this?\n")

#define MTOOLSFMOPTIONS_1 _("Options:\n\n\
--nosysconf\n\
      Dont attempt to read system-wide\n\
      configuration in ")

#ifdef DEFAULT_NOSAVE
#define MTOOLSFMOPTIONS_2 _("\n\
--nouserconf\n\
      Dont read user config file in ~/.mtoolsfm\n\
--save\n\
      Save configuration in ~/.mtoolsfm when\n\
      terminating\n\
--nosave\n\
      Dont save configuration in ~/.mtoolsfm when\n\
      terminating (default)\n\
--debug or -v\n\
      Output debugging messages to stdout\n\
--help\n\
      Display help\n")
#else
#define MTOOLSFMOPTIONS_2 _("\n\
--nouserconf\n\
      Dont read user config file in ~/.mtoolsfm\n\
--save\n\
      Save configuration in ~/.mtoolsfm when\n\
      terminating (default)\n\
--nosave\n\
      Dont save configuration in ~/.mtoolsfm when\n\
      terminating\n\
--debug or -v\n\
      Output debugging messages to stdout\n\
--help\n\
      Display help\n")
#endif

#define CONFIGURE_DRIVES_1 _("This sets allowed driveletters for MToolsFM. Setting this helps you\n\
not to select non-existing drives. If your sysadmin has set\n\
up a system-wide configuration in \n")
#define CONFIGURE_DRIVES_2 _("\n\
you do not need to set this. The configuration is saved in \n\n\
~/.mtoolsfm \n\n\
Give all drives available on your system. If you have drives\n\
a: and b: available, you should enter ab, for example.\n")

/* XXX Renove this later */
#define CONFIGURE_PATH_1 _("\nThis sets the path for mtools-commands. If you do not fill this out, \n") 
#define CONFIGURE_PATH_2 _("\nwill be assumed for default. \n")

#define HELP_USE _("MToolsFM allows you to easily access dos-floppies using mtools.\n\
The main window is split into two parts, each showing the contents of the\n\
drive selected in the combobox. \"Harddisk\" means your UNIX filesystem.\n\
You can select files with the mouse and copy them to the directory listed\n\
in the other part of the window by right-clicking on the list and selecting\n\
the copy command from the context-menu. You can also print files, make new\n\
directories and delete files or directories. If you choose \"Text mode for copying\"\n\
from the \"Options\" menu, files will be copied to / from floppy using appropriate\n\
CR-LF translation for DOS text files. This is achieved using mcopys -t flag.\n\n\
Each of the two window halfs has got its own menu. If you have changed the\n\
floppy in the drive, you can choose \"View -> Refresh\" to refresh the directory\n\
listing. By clicking onto the column titles in the directory listing, you can\n\
set the order in which MToolsFM displays files.\n")

#define LARGEFILE_HELP _("People often experience problems when they want to transport big amounts\n\
of data which do not fit onto a single medium. MToolsFM tries to make this \n\
relatively easy for most people now. If you have one big file which you would\n\
like to transport somewhere on a floppy, for example, you can select that file\n\
in the \"Harddisk\"-view and choose the \"Split\"-menuitem from the \"Utility\"-menu.\n\
This will allow you to split the file into serveral small files which will each fit\n\
onto a single medium. The files will be called\n\n\
split-<num>.aa, split-<num>.ab, split-<num>.ac,...,\n\n\
wherer <num> is some number. Internally, MToolsFM makes use of the \"split\"-command to\n\
generate these files. You have the choice between two default file sizes suited for \n\
floppy disks, but you can also enter a custom file size in bytes.\n\
When you reassemble all these files in a single directory at your destination, you\n\
may use the UNIX cat command to put the pieces together in the following way:\n\n\
cat split-<num>.aa split-<num>.ab split-<num>.ac >your-file\n\n\
where \"your-file\" should be the original filename.\n\
If the destination system is DOS- or Windows-based, life is really easy - MToolsFM\n\
will generate a file with the name split-<num>.bat for you. If you run this file under\n\
DOS / Windows in the directory where you have copied all the small files, it will \n\
automatically put the pieces together again (The batch file makes use of the \"copy\"-\n\
command). So all you would have to do is doubleclick on that batch file in the\n\
explorer...\n\n\
And what if you want to copy several files? Well, MToolsFM offers you a lot of \n\
possibilities to put several files and even directories into one single big file -\n\
even with compression, if you want to. Just have a look at the \"Utility\"-menu.\n\
zip is probably good for most DOS / windows systems - the other options are more \n\
common on UNIX. If you do not know what tar, gzip, gunzip, bzip2, bunzip2 are\n\
all about, ask your local guru.") 
#define LARGEFILE_TITLE _("Copying large files")


#define DIR_DEPTH 20

struct _side {
  GtkWidget *list;
  GtkWidget *box;
  GtkWidget *status;
  char drive;
  char *path[DIR_DEPTH];
  int length;
  guint context;
  struct _side *other;
  GdkColor *dircolor;
  GdkColor *linkcolor;
  GtkWidget *combo;
  GList *comboglist;
  long totsize;
  GtkWidget *contextmenu;
};

typedef struct _dentry {
  char name[256];
  int dir;
  long size;
} dentry;

typedef struct _side side;

typedef struct _msgenv {
  int *mvar;
  int msg;
} msgenv;

typedef struct _callbackopt {
  int message;
  side *whichside;
} callbackopt;
