import zope.interface
import interfaces

class Hook(object):
    @staticmethod
    def _output_log(f, log):
        while True:
            i = f.readline()
            if not i:
                break
            log.write(i)
            log.flush()

    def installed(self):
        ret = set()
        f = self.run(["/usr/bin/dpkg", "--get-selections"])
        try:
            for i in f:
                package, status = i.strip().split()
                if status == "install":
                    ret.add(package)
        finally:
            if f.close():
                raise RuntimeError, "dpkg failed"
        return ret

    def install_apt(self, build, packages):
        installed_before = self.installed()
        args = ["/usr/bin/apt-get", "install", "-o", "DPkg::Options::=--force-confold", "--purge", "-q", "-y"]
        args.extend(packages)
        f = self.suexec(args)
        try:
            self._output_log(f, build.log)
        finally:
            if f.close():
                raise RuntimeError, "apt-get install failed"
        installed_after = self.installed()
        self._apt_installed = installed_after - installed_before

    def prepare_apt(self):
        f = self.suexec(["/usr/bin/apt-get", "update", "-qq"])
        try:
            self._output_log(f, self.log)
        finally:
            if f.close():
                self.log.write("apt-get update failed")
        self.log.flush()

        f = self.suexec(["/usr/bin/apt-get", "autoclean", "-qq"])
        try:
            self._output_log(f, self.log)
        finally:
            if f.close():
                self.log.write("apt-get autoclean failed")
        self.log.flush()

    def uninstall_apt(self, build):
        args = ["/usr/bin/apt-get", "remove", "--purge", "-q", "-y"]
        args.extend([i for i in self._apt_installed])
        f = self.suexec(args)
        try:
            self._output_log(f, build.log)
        finally:
            if f.close():
                raise RuntimeError, "apt-get remove failed"

