import os.path
import textwrap
import zope.interface

from multibuild.builder.hooks import interfaces, register, support

class Hook(support.Hook):
    zope.interface.implements(interfaces.IHookBuildResult)

    name = "print-changes"
    default_priority = 40

    def result(self, build):
        changes = self.filename_changes(build)
        path = os.path.join(build.environment.build_path, changes)
        build.log.write("%s:\n" % changes)
        f = file(path)
        for i in f:
            if i.startswith("Distribution:"):
                build.log.write("Distribution: %s\n" % build.environment.dist)
            else:
                w = textwrap.wrap(i, 990)
                build.log.write("%s\n" % w[0])
                for w1 in w[1:]:
                    build.log.write(" %s\n" % w1)
        build.log.write("\n")

register(Hook)
