import imp, os, sys

def load(prefix, path):
    ret = []
    if not prefix in sys.modules:
        imp.load_module(prefix, None, '', ('', '', imp.PKG_DIRECTORY))
    for root, dirs, files in os.walk(path):
        for file in files:
            if not file.endswith('.py'):
                continue
            module = file[:-3]
            module_complete = prefix + '.' + module
            if module_complete in sys.modules:
                continue
            info = imp.find_module(module, [root])
            ret.append(imp.load_module(module_complete, *info))
    return ret

if __name__ == '__main__':
    print load('multibuild.hooks.test', sys.argv[1])
