//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: masteredit.h,v 1.3.2.1 2005/12/11 21:29:23 spamatica Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __MASTER_EDIT_H__
#define __MASTER_EDIT_H__

#include <qwidget.h>
#include "midieditor.h"
#include "noteinfo.h"
#include "cobject.h"
#include <qmainwindow.h>

class QToolButton;
class Master;
class ScrollScale;
class MTScale;
class SigScale;
class HitScale;
class TScale;
class TempoEdit;
class SigEdit;
class LabelCombo;
class PosLabel;
class TempoLabel;

//---------------------------------------------------------
//   MasterEdit
//---------------------------------------------------------

class MasterEdit : public MidiEditor {
      Master* canvas;
      ScrollScale* hscroll;
      ScrollScale* vscroll;
      MTScale* time1;
      MTScale* time2;
      SigScale* sign;
      HitScale* thits;
      HitScale* zhits;
      TScale* tscale;

      TempoEdit* curTempo;
      SigEdit* curSig;
      LabelCombo* rasterLabel;
      QToolBar* tools;
      PosLabel* cursorPos;
      TempoLabel* tempo;

      static int _rasterInit;

      Q_OBJECT
      virtual void closeEvent(QCloseEvent*);

   private slots:
      void _setRaster(int);
      void posChanged(int,unsigned,bool);
      void setTime(unsigned);
      void setTempo(int);

   public slots:
      void songChanged(int);
//      void tempoChanged(double);

   signals:
      void deleted(unsigned long);

   public:
      MasterEdit();
      ~MasterEdit();
      virtual void readStatus(Xml&);
      virtual void writeStatus(int, Xml&) const;
      static void readConfiguration(Xml&);
      static void writeConfiguration(int, Xml&);
      };

#endif

