/* This is a small program, which redirects it's standard I/O */
/* streams to the unix socket.                                */

/* author: Max Zaitsev                                        */

/* compile:                                                   */
/* gcc sockio.c -o sockio                                     */
/* on Solaris you might need to add -lsocket                  */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>
#include <signal.h>

#define BUFF_SIZE 1024
int main(int argc, char *argv[])
{
	int nFD, nVal, nOldStdIn, nOldStdOut;
	int nBuff;
	char pBuff[BUFF_SIZE];
	int nReadFD, nWriteFD;
	struct sockaddr_un sa;

	if (argc != 2 || 0==strcmp(argv[1],"-h") || 0==strcmp(argv[1],"--help") )
	{
		printf("usage: mutella_sio <socket_path>\n\n");
		return 1;
	}
	nFD = socket(PF_UNIX, SOCK_STREAM, 0);
	if (nFD < 0)
	{
		printf("mutella_sio: failed to create a socket\n\n");
		return 1;
	}
	sa.sun_family = AF_UNIX;
	strncpy(sa.sun_path, argv[1], 107);
	if (connect(nFD, (struct sockaddr*) &sa, sizeof(struct sockaddr_un)) < 0)
	{
		printf("mutella_sio: failed to connect to the socket '%s'\n\n", argv[1]);
		return 1;
	}

	nVal = fork();
	if (nVal < 0)
	{
		printf("mutella_sio: fork() has failed\n\n");
		return 1;
	}
	if (nVal)
	{
		nReadFD = STDIN_FILENO;
		nWriteFD = nFD;
	}
	else
	{
		nReadFD = nFD;
		nWriteFD = STDOUT_FILENO;
	}
	
	while( (nBuff = read(nReadFD, pBuff, BUFF_SIZE)) > 0 )
		if ( write(nWriteFD, pBuff, nBuff) != nBuff)
			break;

	close(nFD);
	
	sleep(1);
	if (nVal)
		kill(nVal, SIGPIPE);

	return 0;
}
