# -*- coding: utf-8 -*-
#
# «ElisaHandler» - Elisa Application lirc creator
#
# Copyright (C) 2007, Florian Boucault
#
#
# Mythbuntu is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 3 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##################################################################################

from MythbuntuLircGenerator.core import ProgramHandler

class ElisaHandler(ProgramHandler):
    def __init__(self,lircd, lircrc,repeat,delay):
        application_name="elisa"
        application_dictionary={ \
        "power":"close_key", \
        "up":"move_up_key", \
        "down":"move_down_key", \
        "left":"move_left_key", \
        "right":"move_right_key", \
        "enter":"activate_key", \
        "rewind":"seek_backward_key", \
        "forward":"seek_forward_key", \
        "vol-":"decrement_volume_key", \
        "vol+":"increment_volume_key", \
        "mute":"toggle_mute_key", \
        "ok":"activate_key", \
        "home":"toggle_menu_key", \
        "menu":"toggle_menu_key", \
        "pause":"pause_key", \
        "play":"toggle_play_pause_key", \
        "stop":"stop_key", \
        "exit":"close_key", \
        "red":"toggle_fullscreen_key", \
        "power":"close_key" \

        }
        ProgramHandler.__init__(self,application_name,application_dictionary,lircd,lircrc,repeat,delay)
