=begin

This plugin is test version.

=end

require 'open-uri'
class WeatherBot < Nadoka::NDK_Bot
  PageMap =
  {"yokohama"=>"/forecast/JAXX0099.html",
    "tokyo"=>"/forecast/JAXX0085.html",
    "ebetsu"=>"/forecast/JAXX0008.html",
    "kurashiki"=>"/forecast/JAXX0044.html",
    "morioka"=>"/forecast/JAXX0103.html",
    "uji"=>"/forecast/JAXX0093.html",
    "ube"=>"/forecast/JAXX0091.html",
    "takatsuki"=>"/forecast/JAXX0083.html",
    "motegi"=>"/forecast/JAXX0113.html",
    "kishiwada"=>"/forecast/JAXX0038.html",
    "nagasaki"=>"/forecast/JAXX0055.html",
    "kurume"=>"/forecast/JAXX0046.html",
    "kisakata"=>"/forecast/JAXX0037.html",
    "chiba"=>"/forecast/JAXX0006.html",
    "akita"=>"/forecast/JAXX0001.html",
    "hiroshima"=>"/forecast/JAXX0018.html",
    "akune"=>"/forecast/JAXX0002.html",
    "kashiwazaki"=>"/forecast/JAXX0033.html",
    "matsuyama"=>"/forecast/JAXX0052.html",
    "aomori"=>"/forecast/JAXX0004.html",
    "ichinomiya"=>"/forecast/JAXX0022.html",
    "ueda"=>"/forecast/JAXX0092.html",
    "kitakyushu"=>"/forecast/JAXX0039.html",
    "nago"=>"/forecast/JAXX0056.html",
    "nagoya"=>"/forecast/JAXX0057.html",
    "kofu"=>"/forecast/JAXX0041.html",
    "toyonaka"=>"/forecast/JAXX0087.html",
    "toyama"=>"/forecast/JAXX0086.html",
    "nanao"=>"/forecast/JAXX0059.html",
    "matsumoto/nagano"=>"/forecast/JAXX0050.html",
    "ichikawa"=>"/forecast/JAXX0021.html",
    "kumamoto"=>"/forecast/JAXX0043.html",
    "kariya"=>"/forecast/JAXX0032.html",
    "utsunomiya"=>"/forecast/JAXX0094.html",
    "toyota"=>"/forecast/JAXX0088.html",
    "takaoka"=>"/forecast/JAXX0082.html",
    "sanjo"=>"/forecast/JAXX0077.html",
    "otaru"=>"/forecast/JAXX0072.html",
    "omuta"=>"/forecast/JAXX0070.html",
    "machida"=>"/forecast/JAXX0048.html",
    "kasugai"=>"/forecast/JAXX0034.html",
    "kadena air base"=>"/forecast/JAXX0027.html",
    "kure"=>"/forecast/JAXX0045.html",
    "omura"=>"/forecast/JAXX0069.html",
    "asahikawa"=>"/forecast/JAXX0005.html",
    "kawaguchi"=>"/forecast/JAXX0035.html",
    "miyazaki"=>"/forecast/JAXX0110.html",
    "yao"=>"/forecast/JAXX0097.html",
    "kyoto"=>"/forecast/JAXX0047.html",
    "matsuto"=>"/forecast/JAXX0051.html",
    "himeji"=>"/forecast/JAXX0017.html",
    "karatsu"=>"/forecast/JAXX0031.html",
    "funabashi"=>"/forecast/JAXX0011.html",
    "suzuka"=>"/forecast/JAXX0112.html",
    "hakui"=>"/forecast/JAXX0015.html",
    "mito"=>"/forecast/JAXX0053.html",
    "joetsu"=>"/forecast/JAXX0026.html",
    "kobe"=>"/forecast/JAXX0040.html",
    "yukuhashi"=>"/forecast/JAXX0100.html",
    "yokkaichi"=>"/forecast/JAXX0098.html",
    "iizuka"=>"/forecast/JAXX0023.html",
    "sasebo"=>"/forecast/JAXX0079.html",
    "sakai"=>"/forecast/JAXX0075.html",
    "otsu"=>"/forecast/JAXX0073.html",
    "higashi-osaka"=>"/forecast/JAXX0016.html",
    "iwakuni"=>"/forecast/JAXX0024.html",
    "takamatsu"=>"/forecast/JAXX0081.html",
    "shizuoka"=>"/forecast/JAXX0107.html",
    "osaka"=>"/forecast/JAXX0071.html",
    "fukushima"=>"/forecast/JAXX0010.html",
    "kanazawa"=>"/forecast/JAXX0030.html",
    "hitachi"=>"/forecast/JAXX0019.html",
    "fukuoka"=>"/forecast/JAXX0009.html",
    "hakodate"=>"/forecast/JAXX0014.html",
    "wakayama"=>"/forecast/JAXX0095.html",
    "shimonoseki"=>"/forecast/JAXX0080.html",
    "honjo"=>"/forecast/JAXX0020.html",
    "niigata"=>"/forecast/JAXX0061.html",
    "nara"=>"/forecast/JAXX0060.html",
    "kawasaki"=>"/forecast/JAXX0036.html",
    "yamaguchi"=>"/forecast/JAXX0096.html",
    "okazaki"=>"/forecast/JAXX0066.html",
    "kagoshima"=>"/forecast/JAXX0028.html",
    "sapporo"=>"/forecast/JAXX0078.html",
    "sakata"=>"/forecast/JAXX0076.html",
    "ogaki"=>"/forecast/JAXX0063.html",
    "minamitorishima"=>"/forecast/JAXX0111.html",
    "nagaoka"=>"/forecast/JAXX0054.html",
    "tsuruoka"=>"/forecast/JAXX0090.html",
    "tokuyama"=>"/forecast/JAXX0084.html",
    "okinawa"=>"/forecast/JAXX0067.html",
    "gifu"=>"/forecast/JAXX0012.html",
    "matsudo"=>"/forecast/JAXX0049.html",
    "komatsu"=>"/forecast/JAXX0042.html",
    "tsu"=>"/forecast/JAXX0089.html",
    "sagamihara"=>"/forecast/JAXX0074.html",
    "okayama"=>"/forecast/JAXX0065.html",
    "okaya"=>"/forecast/JAXX0064.html",
    "noshiro"=>"/forecast/JAXX0062.html",
    "kamiiso"=>"/forecast/JAXX0029.html",
    "amagasaki"=>"/forecast/JAXX0003.html",
    "choshi"=>"/forecast/JAXX0007.html",
    "naha"=>"/forecast/JAXX0058.html",
    "sendai"=>"/forecast/JAXX0104.html",
    "omiya"=>"/forecast/JAXX0068.html",
    "hachioji"=>"/forecast/JAXX0013.html",
    "nagano"=>"/forecast/JAXX0105.html",
    "izumi"=>"/forecast/JAXX0025.html"}

  def read_text_forecast f
    res = []
    f.each{|line|
      if /\A<!--ENDTEXT FORECAST-->$/ =~ line
        break
      else
        if /<b>(.+)<\/b> (.+)<p>/ =~ line
          t    = $1
          info = $2
          info.gsub!(/(\d+)F/){
            i = $1.to_i
            "#{'%.1f' % ((i - 32)/1.8)}C"
          }
          res << "#{t} #{info}"
        end
      end
    }
    res
  end
  
  def get_forecast region
    page = PageMap[region.downcase]
    return "Unknown region. You can check regions at http://weather.yahoo.com/regional/JAXX.html" unless page
    res = nil
    open('http://weather.yahoo.com' + page){|f|
      res = f.each{|line|
        if /\A<!--TEXT FORECAST-->$/ =~ line
          break read_text_forecast f
        end
      }
    }
    res[0..2].join(', ')
  end

  def bot_initialize
    @available_channel = @bot_config[:ch] || /.*/
  end

  def on_privmsg prefix, ch, msg
    if @available_channel === ch
      if /\A(tenki|weather)>(.+)/ =~ msg
        region = $2.strip
        res = "#{$1} (#{region}): #{get_forecast(region)}"
        send_notice(ch, res)
      end
    end
  end
end

