#! /usr/bin/perl

# fifo_write.pl
# Copyright (C) 2004, NETWAYS GmbH, Gerd Mueller
#
# $Id: fifo_write.pl 1265 2006-06-12 08:09:39Z mhein $
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

use strict;
use Fcntl;

my $open_fifo = 0;
my $fpath     = $ARGV[0];

my $output = $ARGV[1];

$output =~ s/\\t/\t/g;
$output =~ s/\\n/\n/g;

unless ( -p $fpath ) {    # not a pipe
    if ( -e _ ) {         # but a something else
        die "$0: won't overwrite existing file.\n";
    }
    else {
        die "$fpath doesn't exist.\n";
    }
}

local $SIG{ALRM} = sub {
    close FIFO if ($open_fifo);
    die "unable to write to fifo\n";
};

# default values
my $timeout = 3;    # 3 seconds timeout

$timeout = $ARGV[2] if ( $ARGV[2] ne "" );
alarm $timeout;

sysopen( FIFO, $fpath, O_WRONLY )
  or die "cannot open fifo \"" . $fpath . "\"!\n";
$open_fifo = 1;
print FIFO $output;
close FIFO;

alarm 0;
