#! /usr/bin/perl

# fifo_write.pl
# Copyright (C) 2004, NETWAYS GmbH, Gerd Mueller
#
# $Id: fifo_write_from_tcp.pl 998 2005-11-23 11:12:24Z mhein $
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

use strict;
use Fcntl;
use IO::Socket;

my $output;
my $PORT = 5667;
my $client;
my $server;



my $open_fifo = 0;
my $fpath     = $ARGV[0];


unless ( -p $fpath ) {    # not a pipe
    if ( -e _ ) {         # but a something else
        die "$0: won't overwrite existing file.\n";
    }
    else {
        die "$fpath doesn't exist.\n";
    }
}

local $SIG{ALRM} = sub {
    close FIFO if ($open_fifo);
    die "unable to write to fifo\n";
};

# default values
my $timeout = 3;    # 3 seconds timeout

$timeout = $ARGV[1] if ( $ARGV[2] ne "" );

$server = IO::Socket::INET->new( Proto=> 'tcp', LocalPort => $PORT, Listen=> SOMAXCONN, Reuse=> 1);
while ($client = $server->accept()) {
   $client->autoflush(1);
   while ( <$client>) {
    sysopen( FIFO, $fpath, O_WRONLY ) or die "cannot open fifo \"" . $fpath . "\"!\n";
    $open_fifo = 1;
    chomp();
    $output = $_;
    $output =~ s/\\t/\t/g;
    $output =~ s/\\n/\n/g;
    print FIFO $output;
    close FIFO;
    alarm 0;
   }
   close $client;
 }
alarm $timeout;
