#!/bin/bash
rm log.log 2> /dev/null

# ig_land_max:			landscape IG eported from 3dsmax not elevated by the heightmap
# ig_land_max_elev:		landscape IG eported from 3dsmax elevated by the heightmap
# ig_land_ligo:			landscape IG found in ligo bricks not elevated by the heightmap
# ig_land_ligo_elev:	landscape IG found in ligo bricks from 3dsmax elevated by the heightmap
# ig_land_ld:			landscape IG generated by the land exporter (already elevated by the land exporter)

# ig_land:				final IG directory for landscape IGs
# ig_land_compare:		Tmp final IG directory for landscape IGs before comparison
# ig_other:				final IG directory for village or construction IGs

# Log error
echo ------- >> log.log
echo --- Build ig >> log.log
echo ------- >> log.log
echo ------- 
echo --- Build ig
echo ------- 
date >> log.log
date

# ************************************************
# Build the IG_LAND made with the LevelDesign Tool
# ************************************************

# Get the primitive directory
continentdir=`cat ../../cfg/config.cfg | grep "leveldesign_igexport_continent_dir" | sed -e 's/leveldesign_igexport_continent_dir//' | sed -e 's/ //g' | sed -e 's/=//g' | sed -e 's/;//g'`

# Get the database directory
database_directory=`cat ../../cfg/site.cfg | grep "database_directory" | sed -e 's/database_directory//g' | sed -e 's/ //g' | sed -e 's/=//g'`

# Get the primitive directories
ligo_ig_primitive_directory=`cat ../../cfg/directories.cfg | grep "ligo_ig_primitive_directory" | sed -e 's/ligo_ig_primitive_directory//' | sed -e 's/ //g' | sed -e 's/=//g'`

# Get the form directory
form_dir=`cat ../../cfg/site.cfg | grep "level_design_directory" | sed -e 's/level_design_directory//' | sed -e 's/ //g' | sed -e 's/=//g'`

if ( test "$continentdir" || test "$ligo_ig_primitive_directory" )
then
	land_name=`cat ../../cfg/config.cfg | grep "ligo_export_land" | sed -e 's/ligo_export_land//' | sed -e 's/ //g' | sed -e 's/=//g'`

	if ( test "$land_name" )
	then
		echo [Prim IG] ON
		echo [Prim IG] ON >> log.log
		# create cfg file
		# +++++++++++++++

		rm prim_export.cfg
		echo "// prim_export.cfg" > prim_export.cfg

		echo "OutIGDir = \"ig_land_ld\";" >> prim_export.cfg
		echo "ZoneWDir = \"..\\zone\\zone_welded\";" >> prim_export.cfg

		name_bank=`cat ../../cfg/properties.cfg | grep "bank_name" | sed -e 's/bank_name//' | sed -e 's/ //g' | sed -e 's/=//g'`
		echo "SmallBank = $name_bank" >> prim_export.cfg
		name_farbank=`cat ../../cfg/properties.cfg | grep "bankfar_name" | sed -e 's/bankfar_name//' | sed -e 's/ //g' | sed -e 's/=//g'`
		echo "FarBank = $name_farbank" >> prim_export.cfg

		displacedir=`cat ../../cfg/directories.cfg | grep "displace_source_directory" | sed -e 's/displace_source_directory//' | sed -e 's/ //g' | sed -e 's/=//g'`
		dir_database=`cat ../../cfg/site.cfg | grep "database_directory" | sed -e 's/database_directory//' | sed -e 's/ //g' | sed -e 's/=//g'`
		echo "DisplaceDir = \"$dir_database/$displacedir\";" >> prim_export.cfg

		echo "CellSize = 160.0;" >> prim_export.cfg

		# Set the continent directory to export
		echo "PrimDirs = {" >> prim_export.cfg
		echo " $continentdir," >> prim_export.cfg
		for dir in $ligo_ig_primitive_directory ; do
			echo " \"$database_directory/$dir\"," >> prim_export.cfg
		done
		echo "};" >> prim_export.cfg

		# Set the dfn directory to export
		echo "FormDir = \"$form_dir\";" >> prim_export.cfg

		# *******************
		# Launch the exporter
		# *******************

		prim_export.exe prim_export.cfg

		# *******************
		# Merge it with the IG_LAND exported from Max + elvated with heightmap
		# *******************

		# elevation of the heightmap for land_max
		# ++++++++++++++++++++++++++++++++++++++++++++

		rm ig_elevation.cfg
		echo "// ig_elevation.cfg" > ig_elevation.cfg
		echo "OutputIGDir = \"ig_land_max_elev\";" >> ig_elevation.cfg
		echo "InputIGDir = \"ig_land_max\";" >> ig_elevation.cfg
		echo "CellSize = 160.0;" >> ig_elevation.cfg

		# HeightMapFile1 is the grayscale .tga file (127 is 0, 0 is -127*ZFactor and 255 is +128*ZFactor)
		dir_database=`cat ../../cfg/site.cfg | grep "database_directory" | sed -e 's/database_directory//' | sed -e 's/ //g' | sed -e 's/=//g'`
		dir_ligosrc=`cat ../../cfg/directories.cfg | grep "ligo_source_directory" | sed -e 's/ligo_source_directory//' | sed -e 's/ //g' | sed -e 's/=//g'`
		hmf1=`cat ../../cfg/config.cfg | grep "ligo_export_heightmap1" | sed -e 's/ligo_export_heightmap1//' | sed -e 's/ //g' | sed -e 's/=//g'`
		echo "HeightMapFile1 = \"$dir_database/$dir_ligosrc/$hmf1\";" >> ig_elevation.cfg

		# ZFactor1 is the heightmap factor
		zf1=`cat ../../cfg/config.cfg | grep "ligo_export_zfactor1" | sed -e 's/ligo_export_zfactor1//' | sed -e 's/ //g' | sed -e 's/=//g'`
		echo "ZFactor1 = $zf1;" >> ig_elevation.cfg

		# HeightMapFile2 is the grayscale .tga file (127 is 0, 0 is -127*ZFactor and 255 is +128*ZFactor)
		hmf2=`cat ../../cfg/config.cfg | grep "ligo_export_heightmap2" | sed -e 's/ligo_export_heightmap2//' | sed -e 's/ //g' | sed -e 's/=//g'`
		echo "HeightMapFile2 = \"$dir_database/$dir_ligosrc/$hmf2\";" >> ig_elevation.cfg

		# ZFactor2 is the heightmap factor
		zf2=`cat ../../cfg/config.cfg | grep "ligo_export_zfactor2" | sed -e 's/ligo_export_zfactor2//' | sed -e 's/ //g' | sed -e 's/=//g'`
		echo "ZFactor2 = $zf2;" >> ig_elevation.cfg

		echo "LandFile = \"$dir_database/$dir_ligosrc/$land_name\";" >> ig_elevation.cfg


		ig_elevation ig_elevation.cfg

		# elevation of the heightmap for land_ligo
		# ++++++++++++++++++++++++++++++++++++++++++++

		rm ig_elevation.cfg
		echo "// ig_elevation.cfg" > ig_elevation.cfg
		echo "OutputIGDir = \"ig_land_ligo_elev\";" >> ig_elevation.cfg
		echo "InputIGDir = \"ig_land_ligo\";" >> ig_elevation.cfg
		echo "CellSize = 160.0;" >> ig_elevation.cfg

		# HeightMapFile1 is the grayscale .tga file (127 is 0, 0 is -127*ZFactor and 255 is +128*ZFactor)
		dir_database=`cat ../../cfg/site.cfg | grep "database_directory" | sed -e 's/database_directory//' | sed -e 's/ //g' | sed -e 's/=//g'`
		dir_ligosrc=`cat ../../cfg/directories.cfg | grep "ligo_source_directory" | sed -e 's/ligo_source_directory//' | sed -e 's/ //g' | sed -e 's/=//g'`
		hmf1=`cat ../../cfg/config.cfg | grep "ligo_export_heightmap1" | sed -e 's/ligo_export_heightmap1//' | sed -e 's/ //g' | sed -e 's/=//g'`
		echo "HeightMapFile1 = \"$dir_database/$dir_ligosrc/$hmf1\";" >> ig_elevation.cfg

		# ZFactor1 is the heightmap factor
		zf1=`cat ../../cfg/config.cfg | grep "ligo_export_zfactor1" | sed -e 's/ligo_export_zfactor1//' | sed -e 's/ //g' | sed -e 's/=//g'`
		echo "ZFactor1 = $zf1;" >> ig_elevation.cfg

		# HeightMapFile2 is the grayscale .tga file (127 is 0, 0 is -127*ZFactor and 255 is +128*ZFactor)
		hmf2=`cat ../../cfg/config.cfg | grep "ligo_export_heightmap2" | sed -e 's/ligo_export_heightmap2//' | sed -e 's/ //g' | sed -e 's/=//g'`
		echo "HeightMapFile2 = \"$dir_database/$dir_ligosrc/$hmf2\";" >> ig_elevation.cfg

		# ZFactor2 is the heightmap factor
		zf2=`cat ../../cfg/config.cfg | grep "ligo_export_zfactor2" | sed -e 's/ligo_export_zfactor2//' | sed -e 's/ //g' | sed -e 's/=//g'`
		echo "ZFactor2 = $zf2;" >> ig_elevation.cfg

		land_name=`cat ../../cfg/config.cfg | grep "ligo_export_land" | sed -e 's/ligo_export_land//' | sed -e 's/ //g' | sed -e 's/=//g'`
		echo "LandFile = \"$dir_database/$dir_ligosrc/$land_name\";" >> ig_elevation.cfg

		ig_elevation ig_elevation.cfg

	else
		echo [Prim IG] OFF
		echo [Prim IG] OFF >> log.log
	fi
else
	echo [Prim IG] OFF
	echo [Prim IG] OFF >> log.log
fi

# Erase ig in ig_merge_tmp and ig_land_compare

rm ig_merge_tmp/*
rm ig_land_compare/*

# Merge ig in ig_land_ld with ig_land_max_elev in ig_merge_tmp

dir_current=`pwd`
cd ig_land_ld
list_ig=`ls -1 *.[iI][gG] 2> /dev/null`
cd $dir_current
for filename in $list_ig ; do
	# Does this file exist in ig_land_max_elev ?
	if test -e ig_land_max_elev/$filename ; then
		# Yes, lets merge it 
		ig_add ig_merge_tmp/$filename ig_land_max_elev/$filename ig_land_ld/$filename ;
	else
		# No, only copy it
		cp ig_land_ld/$filename ig_merge_tmp/$filename ;
	fi

	# Idle
	../../idle.bat
done

# Merge ig in ig_land_max_elev with ig_land_ld in ig_merge_tmp

cd ig_land_max_elev
list_ig=`ls -1 *.[iI][gG] 2> /dev/null`
cd $dir_current
for filename in $list_ig ; do
	# Does this file exist in ig_land_ld ?
	if !(test -e ig_land_ld/$filename) then
		# No, only copy it
		cp ig_land_max_elev/$filename ig_merge_tmp/$filename ;
	fi

	# Idle
	../../idle.bat
done

# Merge ig in ig_merge_tmp with ig_land_ligo_elev in ig_land_compare

cd ig_merge_tmp
list_ig=`ls -1 *.[iI][gG] 2> /dev/null`
cd $dir_current
for filename in $list_ig ; do
	# Does this file exist in ig_land_ligo_elev ?
	if (test -e ig_land_ligo_elev/$filename) then
		# Yes, lets merge it 
		ig_add ig_land_compare/$filename ig_merge_tmp/$filename ig_land_ligo_elev/$filename ;
	else
		# No, only copy it
		cp ig_merge_tmp/$filename ig_land_compare/$filename ;
	fi

	# Idle
	../../idle.bat
done

# Merge ig in ig_land_ligo_elev with ig_merge_tmp in ig_land_compare

cd ig_land_ligo_elev
list_ig=`ls -1 *.[iI][gG] 2> /dev/null`
cd $dir_current
for filename in $list_ig ; do
	# Does this file exist in ig_merge_tmp ?
	if !(test -e ig_merge_tmp/$filename) then
		# No, only copy it
		cp ig_land_ligo_elev/$filename ig_land_compare/$filename ;
	fi

	# Idle
	../../idle.bat
done

# Compare and update

cd ig_land_compare
list_ig=`ls -1 *.[iI][gG]`
for filename in $list_ig ; do
	echo "Checking $filename for update"
	if test -e ../ig_land/$filename ; then
		must_update=`diff --binary -q $filename ../ig_land/$filename` ;
	else
		must_update=YES ;
	fi
	
	if test -n "$must_update" ; then
		echo "   Updating"
		cp -u -p $filename ../ig_land/$filename ;
	fi

	# Idle
	../../../idle.bat
done
cd ../ig_land
list_ig=`ls -1 *.[iI][gG]`
for filename in $list_ig ; do
	if !(test -e ../ig_land_compare/$filename) then
		echo "Remove $filename"
		rm $filename ;
	fi

	# Idle
	../../../idle.bat
done
cd $dir_current


# ******************
# List all the zones
# ******************

# Get the landscape name
landscape_name=`cat ../../cfg/config.cfg | grep "landscape_name" | sed -e 's/landscape_name//' | sed -e 's/ //g' | sed -e 's/=//g'`

# Landscape name exist ?
if ( test "$landscape_name" )
then
	# If the list file exists, erase it
	if ( test -f "$landscape_name"_ig.txt )
	then
		rm "$landscape_name"_ig.txt
	fi

	cd ig_land
	for i in *.[iI][gG] ; do
		# Build an ig list
		if ( test -f $i )
		then
			echo $i >> ../"$landscape_name"_ig.txt
		else
			echo >> ../"$landscape_name"_ig.txt
		fi
	done
	cd ..

	# Idle
	../../idle.bat
fi


