-- This script rename texture files in material

NEL3D_APPDATA_LOD							= 1423062537
NEL3D_APPDATA_LOD_NAME_COUNT				= (NEL3D_APPDATA_LOD)
NEL3D_APPDATA_LOD_NAME						= (NEL3D_APPDATA_LOD_NAME_COUNT+1)
NEL3D_APPDATA_LOD_NAME_COUNT_MAX			= 10
NEL3D_APPDATA_LOD_BLEND_IN					= (NEL3D_APPDATA_LOD_NAME+NEL3D_APPDATA_LOD_NAME_COUNT_MAX)
NEL3D_APPDATA_LOD_BLEND_OUT					= (NEL3D_APPDATA_LOD_BLEND_IN+1)
NEL3D_APPDATA_LOD_COARSE_MESH				= (NEL3D_APPDATA_LOD_BLEND_OUT+1)
NEL3D_APPDATA_LOD_DYNAMIC_MESH				= (NEL3D_APPDATA_LOD_COARSE_MESH+1)
NEL3D_APPDATA_LOD_DIST_MAX					= (NEL3D_APPDATA_LOD_DYNAMIC_MESH+1)
NEL3D_APPDATA_LOD_BLEND_LENGTH				= (NEL3D_APPDATA_LOD_DIST_MAX+1)
NEL3D_APPDATA_LOD_MRM						= (NEL3D_APPDATA_LOD_BLEND_LENGTH+1)
NEL3D_APPDATA_LOD_SKIN_REDUCTION			= (NEL3D_APPDATA_LOD_MRM+1)
NEL3D_APPDATA_LOD_NB_LOD					= (NEL3D_APPDATA_LOD_SKIN_REDUCTION+1)
NEL3D_APPDATA_LOD_DIVISOR					= (NEL3D_APPDATA_LOD_NB_LOD+1)
NEL3D_APPDATA_LOD_DISTANCE_FINEST			= (NEL3D_APPDATA_LOD_DIVISOR+1)
NEL3D_APPDATA_LOD_DISTANCE_MIDDLE			= (NEL3D_APPDATA_LOD_DISTANCE_FINEST+1)
NEL3D_APPDATA_LOD_DISTANCE_COARSEST			= (NEL3D_APPDATA_LOD_DISTANCE_MIDDLE+1)
NEL3D_APPDATA_ACCEL							= (1423062561)
NEL3D_APPDATA_OCC_MODEL						= (84682540)
NEL3D_APPDATA_OPEN_OCC_MODEL				= (84682541)
NEL3D_APPDATA_SOUND_GROUP					= (84682542)
NEL3D_APPDATA_ENV_FX						= (84682543)
NEL3D_APPDATA_INSTANCE_SHAPE				= (1970)
NEL3D_APPDATA_INSTANCE_NAME					= (1423062562)
NEL3D_APPDATA_DONT_ADD_TO_SCENE				= (1423062563)
NEL3D_APPDATA_IGNAME						= (1423062564)
NEL3D_APPDATA_INTERFACE_FILE				= (1423062700)
NEL3D_APPDATA_INTERFACE_THRESHOLD			= (1423062701)
NEL3D_APPDATA_GET_INTERFACE_NORMAL_FROM_SCENE_OBJECTS = (1423062702)
NEL3D_APPDATA_DONTEXPORT					= (1423062565)
NEL3D_APPDATA_LUMELSIZEMUL					= (1423062567)
NEL3D_APPDATA_SOFTSHADOW_RADIUS				= (1423062568)
NEL3D_APPDATA_SOFTSHADOW_CONELENGTH			= (1423062569)
NEL3D_APPDATA_FLOATING_OBJECT			    = (1423062570)
NEL3D_APPDATA_VEGETABLE						= (1423062580)
NEL3D_APPDATA_VEGETABLE_ALPHA_BLEND			= (1423062581)
NEL3D_APPDATA_VEGETABLE_ALPHA_BLEND_ON_LIGHTED	= (1423062582)
NEL3D_APPDATA_VEGETABLE_ALPHA_BLEND_OFF_LIGHTED	= (1423062583)
NEL3D_APPDATA_VEGETABLE_ALPHA_BLEND_OFF_DOUBLE_SIDED	= (1423062584)
NEL3D_APPDATA_BEND_CENTER					= (1423062585)
NEL3D_APPDATA_BEND_FACTOR					= (1423062586)
NEL3D_APPDATA_AUTOMATIC_ANIMATION			= (1423062617)
NEL3D_APPDATA_EXPORT_ANIMATED_MATERIALS		= (1423062587)
NEL3D_APPDATA_EXPORT_NOTE_TRACK				= (1423062566)
NEL3D_APPDATA_EXPORT_NODE_ANIMATION			= (1423062800)
NEL3D_APPDATA_EXPORT_ANIMATION_PREFIXE_NAME = (1423062801)
NEL3D_APPDATA_EXPORT_REALTIME_LIGHT			= (1423062588)
NEL3D_APPDATA_USE_LIGHT_LOCAL_ATTENUATION	= (1423062589)
NEL3D_APPDATA_EXPORT_LIGHTMAP_LIGHT			= (1423062590)
NEL3D_APPDATA_EXPORT_AS_SUN_LIGHT			= (1423062591)
NEL3D_APPDATA_VERTEXPROGRAM_ID				= (1423062592)
NEL3D_AppDataVPWTFreq0	= 1423062593
NEL3D_AppDataVPWTFreq1	= 1423062594 
NEL3D_AppDataVPWTFreq2	= 1423062595
NEL3D_AppDataVPWTFreqWD0 = 1423062596
NEL3D_AppDataVPWTFreqWD1 = 1423062597
NEL3D_AppDataVPWTFreqWD2 = 1423062598
NEL3D_AppDataVPWTDistXY0 = 1423062599
NEL3D_AppDataVPWTDistXY1 = 1423062600
NEL3D_AppDataVPWTDistXY2 = 1423062601
NEL3D_AppDataVPWTDistZ0 = 1423062602
NEL3D_AppDataVPWTDistZ1 = 1423062603
NEL3D_AppDataVPWTDistZ2 = 1423062604
NEL3D_AppDataVPWTBias0 = 1423062605
NEL3D_AppDataVPWTBias1 = 1423062606
NEL3D_AppDataVPWTBias2 = 1423062607
NEL3D_APPDATA_VPWT_USE_SPEC					= (1423062608)
NEL3D_APPDATA_VPWT_FREQ_SCALE				= (1423062609)
NEL3D_APPDATA_VPWT_DIST_SCALE				= (1423062610)
NEL3D_APPDATA_EXPORT_SWT					= (1423062611)
NEL3D_APPDATA_EXPORT_SWT_WEIGHT				= (1423062612)
NEL3D_APPDATA_COLLISION						= (1423062613)
NEL3D_APPDATA_COLLISION_EXTERIOR			= (1423062614)
NEL3D_APPDATA_BONE_LOD_DISTANCE				= (1423062615)
NEL3D_APPDATA_VEGETABLE_FORCE_BEST_SIDED_LIGHTING	= (1423062616)
NEL3D_APPDATA_CHARACTER_LOD					= (1423062618)
NEL3D_APPDATA_EXPORT_BONE_SCALE				= (1423062619)
NEL3D_APPDATA_EXPORT_BONE_SCALE_NAME_EXT	= (1423062620)
NEL3D_APPDATA_USE_REMANENCE					= (1423062631)
NEL3D_APPDATA_REMANENCE_SLICE_NUMBER		= (1423062632)
NEL3D_APPDATA_REMANENCE_SAMPLING_PERIOD     = (1423062633)
NEL3D_APPDATA_REMANENCE_ROLLUP_RATIO        = (1423062635)
NEL3D_APPDATA_REMANENCE_SHIFTING_TEXTURE    = (1423062634)
NEL3D_APPDATA_LIGHT_DONT_CAST_SHADOW_INTERIOR		= (1423062636)
NEL3D_APPDATA_LIGHT_DONT_CAST_SHADOW_EXTERIOR		= (1423062637)
NEL3D_APPDATA_RADIAL_NORMAL_SM				= 2089254647
NEL3D_APPDATA_RADIAL_NORMAL_SM_28			= 2089254647
NEL3D_APPDATA_RADIAL_NORMAL_SM_29			= 2089254648
NEL3D_APPDATA_RADIAL_NORMAL_SM_30			= 2089254649
NEL3D_APPDATA_RADIAL_NORMAL_SM_31			= 2089254650
NEL3D_APPDATA_LM			= 41654684
NEL3D_APPDATA_LM_ANIMATED_LIGHT	= (NEL3D_APPDATA_LM+1)
NEL3D_APPDATA_LM_ANIMATED	= (NEL3D_APPDATA_LM+2)
NEL3D_APPDATA_LM_LIGHT_GROUP =	(NEL3D_APPDATA_LM+3)
NEL3D_APPDATA_EXPORT_LMC_ENABLED = (1423062638)
NEL3D_APPDATA_EXPORT_LMC_MAX_LIGHT_GROUP =	16
NEL3D_APPDATA_EXPORT_LMC_AMBIENT_START = (1423062639)
NEL3D_APPDATA_EXPORT_LMC_DIFFUSE_START = NEL3D_APPDATA_EXPORT_LMC_AMBIENT_START + NEL3D_APPDATA_EXPORT_LMC_MAX_LIGHT_GROUP

value_array = 
#(	
	"LOD", NEL3D_APPDATA_LOD							,
	"LOD_NAME_COUNT",NEL3D_APPDATA_LOD_NAME_COUNT				,
	"LOD_NAME",NEL3D_APPDATA_LOD_NAME						,
	"LOD_BLEND_IN",NEL3D_APPDATA_LOD_BLEND_IN					,
	"LOD_BLEND_OUT",NEL3D_APPDATA_LOD_BLEND_OUT					,
	"LOD_COARSE_MESH",NEL3D_APPDATA_LOD_COARSE_MESH				,
	"LOD_DYNAMIC_MESH",NEL3D_APPDATA_LOD_DYNAMIC_MESH				,
	"LOD_DIST_MAX",NEL3D_APPDATA_LOD_DIST_MAX					,
	"LOD_BLEND_LENGTH",NEL3D_APPDATA_LOD_BLEND_LENGTH				,
	"LOD_MRM",NEL3D_APPDATA_LOD_MRM						,
	"LOD_SKIN_REDUCTION",NEL3D_APPDATA_LOD_SKIN_REDUCTION			,
	"LOD_NB_LOD",NEL3D_APPDATA_LOD_NB_LOD					,
	"LOD_DIVISOR",NEL3D_APPDATA_LOD_DIVISOR					,
	"LOD_DISTANCE_FINEST",NEL3D_APPDATA_LOD_DISTANCE_FINEST			,
	"LOD_DISTANCE_MIDDLE",NEL3D_APPDATA_LOD_DISTANCE_MIDDLE			,
	"LOD_DISTANCE_COARSEST",NEL3D_APPDATA_LOD_DISTANCE_COARSEST			,
	"ACCEL",NEL3D_APPDATA_ACCEL							,
	"OCC_MODEL",NEL3D_APPDATA_OCC_MODEL						,
	"OPEN_OCC_MODEL",NEL3D_APPDATA_OPEN_OCC_MODEL				,
	"SOUND_GROUP",NEL3D_APPDATA_SOUND_GROUP					,
	"ENV_FX",NEL3D_APPDATA_ENV_FX						,
	"Instance Shape",NEL3D_APPDATA_INSTANCE_SHAPE				,
	"Instance Name",NEL3D_APPDATA_INSTANCE_NAME					,
	"Don't Add To Scene",NEL3D_APPDATA_DONT_ADD_TO_SCENE				,
	"Instance Group Name",NEL3D_APPDATA_IGNAME						,
	"INTERFACE_FILE",NEL3D_APPDATA_INTERFACE_FILE				,
	"INTERFACE_THRESHOLD",NEL3D_APPDATA_INTERFACE_THRESHOLD			,
	"GET_INTERFACE_NORMAL_FROM_SCENE_OBJECTS",NEL3D_APPDATA_GET_INTERFACE_NORMAL_FROM_SCENE_OBJECTS ,
	"DONTEXPORT",NEL3D_APPDATA_DONTEXPORT					,
	"LUMELSIZEMUL",NEL3D_APPDATA_LUMELSIZEMUL					,
	"SOFTSHADOW_RADIUS",NEL3D_APPDATA_SOFTSHADOW_RADIUS				,
	"SOFTSHADOW_CONELENGTH",NEL3D_APPDATA_SOFTSHADOW_CONELENGTH			,
	"FLOATING_OBJECT",NEL3D_APPDATA_FLOATING_OBJECT			    ,
	"VEGETABLE",NEL3D_APPDATA_VEGETABLE						,
	"VEGETABLE_ALPHA_BLEND",NEL3D_APPDATA_VEGETABLE_ALPHA_BLEND			,
	"VEGETABLE_ALPHA_BLEND_ON_LIGHTED",NEL3D_APPDATA_VEGETABLE_ALPHA_BLEND_ON_LIGHTED	,
	"VEGETABLE_ALPHA_BLEND_OFF_LIGHTED",NEL3D_APPDATA_VEGETABLE_ALPHA_BLEND_OFF_LIGHTED	,
	"VEGETABLE_ALPHA_BLEND_OFF_DOUBLE_SIDED",NEL3D_APPDATA_VEGETABLE_ALPHA_BLEND_OFF_DOUBLE_SIDED	,
	"BEND_CENTER",NEL3D_APPDATA_BEND_CENTER					,
	"BEND_FACTOR",NEL3D_APPDATA_BEND_FACTOR					,
	"AUTOMATIC_ANIMATION",NEL3D_APPDATA_AUTOMATIC_ANIMATION			,
	"EXPORT_ANIMATED_MATERIALS",NEL3D_APPDATA_EXPORT_ANIMATED_MATERIALS		,
	"EXPORT_NOTE_TRACK",NEL3D_APPDATA_EXPORT_NOTE_TRACK				,
	"EXPORT_NODE_ANIMATION",NEL3D_APPDATA_EXPORT_NODE_ANIMATION			,
	"EXPORT_ANIMATION_PREFIXE_NAME",NEL3D_APPDATA_EXPORT_ANIMATION_PREFIXE_NAME ,
	"EXPORT_REALTIME_LIGHT",NEL3D_APPDATA_EXPORT_REALTIME_LIGHT			,
	"USE_LIGHT_LOCAL_ATTENUATION",NEL3D_APPDATA_USE_LIGHT_LOCAL_ATTENUATION	,
	"EXPORT_LIGHTMAP_LIGHT",NEL3D_APPDATA_EXPORT_LIGHTMAP_LIGHT			,
	"EXPORT_AS_SUN_LIGHT",NEL3D_APPDATA_EXPORT_AS_SUN_LIGHT			,
	"VERTEXPROGRAM_ID",NEL3D_APPDATA_VERTEXPROGRAM_ID				,
	"VPWTFreq0",NEL3D_AppDataVPWTFreq0	,
	"VPWTFreq1",NEL3D_AppDataVPWTFreq1	,
	"VPWTFreq2",NEL3D_AppDataVPWTFreq2	,
	"VPWTFreqWD0",NEL3D_AppDataVPWTFreqWD0 ,
	"VPWTFreqWD1",NEL3D_AppDataVPWTFreqWD1 ,
	"VPWTFreqWD2",NEL3D_AppDataVPWTFreqWD2 ,
	"VPWTDistXY0",NEL3D_AppDataVPWTDistXY0 ,
	"VPWTDistXY1",NEL3D_AppDataVPWTDistXY1 ,
	"VPWTDistXY2",NEL3D_AppDataVPWTDistXY2 ,
	"VPWTDistZ0",NEL3D_AppDataVPWTDistZ0 ,
	"VPWTDistZ1",NEL3D_AppDataVPWTDistZ1 ,
	"VPWTDistZ2",NEL3D_AppDataVPWTDistZ2 ,
	"VPWTBias0",NEL3D_AppDataVPWTBias0 ,
	"VPWTBias1",NEL3D_AppDataVPWTBias1 ,
	"VPWTBias2",NEL3D_AppDataVPWTBias2 ,
	"VPWT_USE_SPEC",NEL3D_APPDATA_VPWT_USE_SPEC					,
	"VPWT_FREQ_SCALE",NEL3D_APPDATA_VPWT_FREQ_SCALE				,
	"VPWT_DIST_SCALE",NEL3D_APPDATA_VPWT_DIST_SCALE				,
	"EXPORT_SWT",NEL3D_APPDATA_EXPORT_SWT					,
	"EXPORT_SWT_WEIGHT",NEL3D_APPDATA_EXPORT_SWT_WEIGHT				,
	"COLLISION",NEL3D_APPDATA_COLLISION						,
	"COLLISION_EXTERIOR",NEL3D_APPDATA_COLLISION_EXTERIOR			,
	"BONE_LOD_DISTANCE",NEL3D_APPDATA_BONE_LOD_DISTANCE				,
	"VEGETABLE_FORCE_BEST_SIDED_LIGHTING",NEL3D_APPDATA_VEGETABLE_FORCE_BEST_SIDED_LIGHTING	,
	"CHARACTER_LOD",NEL3D_APPDATA_CHARACTER_LOD					,
	"EXPORT_BONE_SCALE",NEL3D_APPDATA_EXPORT_BONE_SCALE				,
	"EXPORT_BONE_SCALE_NAME_EXT",NEL3D_APPDATA_EXPORT_BONE_SCALE_NAME_EXT	,
	"USE_REMANENCE",NEL3D_APPDATA_USE_REMANENCE					,
	"REMANENCE_SLICE_NUMBER",NEL3D_APPDATA_REMANENCE_SLICE_NUMBER		,
	"REMANENCE_SAMPLING_PERIOD",NEL3D_APPDATA_REMANENCE_SAMPLING_PERIOD     ,
	"REMANENCE_ROLLUP_RATIO",NEL3D_APPDATA_REMANENCE_ROLLUP_RATIO        ,
	"REMANENCE_SHIFTING_TEXTURE",NEL3D_APPDATA_REMANENCE_SHIFTING_TEXTURE    ,
	"LIGHT_DONT_CAST_SHADOW_INTERIOR",NEL3D_APPDATA_LIGHT_DONT_CAST_SHADOW_INTERIOR		,
	"LIGHT_DONT_CAST_SHADOW_EXTERIOR",NEL3D_APPDATA_LIGHT_DONT_CAST_SHADOW_EXTERIOR		,
	"RADIAL_NORMAL_SM",NEL3D_APPDATA_RADIAL_NORMAL_SM				,
	"RADIAL_NORMAL_SM_28",NEL3D_APPDATA_RADIAL_NORMAL_SM_28			,
	"RADIAL_NORMAL_SM_29",NEL3D_APPDATA_RADIAL_NORMAL_SM_29			,
	"RADIAL_NORMAL_SM_30",NEL3D_APPDATA_RADIAL_NORMAL_SM_30			,
	"RADIAL_NORMAL_SM_31",NEL3D_APPDATA_RADIAL_NORMAL_SM_31,
	"Lightmap Animation Name", NEL3D_APPDATA_LM_ANIMATED_LIGHT,
	"Animated Dynamic Lightmap", NEL3D_APPDATA_LM_ANIMATED,
	"Lightmap Group", NEL3D_APPDATA_LM_LIGHT_GROUP,
	"LMCEnabled", NEL3D_APPDATA_EXPORT_LMC_ENABLED,
	"LMCAlwaysAmbient", NEL3D_APPDATA_EXPORT_LMC_AMBIENT_START+0,
	"LMCAlwaysDiffuse", NEL3D_APPDATA_EXPORT_LMC_DIFFUSE_START+0,
	"LMCSunAmbient", NEL3D_APPDATA_EXPORT_LMC_AMBIENT_START+1,
	"LMCSunDiffuse", NEL3D_APPDATA_EXPORT_LMC_DIFFUSE_START+1,
	"LMCNightAmbient", NEL3D_APPDATA_EXPORT_LMC_AMBIENT_START+2,
	"LMCNightDiffuse", NEL3D_APPDATA_EXPORT_LMC_DIFFUSE_START+2)

rollout select_rollout "Properties"
(
	Label			IGNameLabel				"Value of the appdata:"					align:#left
	ListBox			IGNameList				height:29
	Button			RefreshBt				"Refresh list"					align:#left
	Dropdownlist		AppData					"AppData"

	on IGNameList doubleClicked toto do
	(
		max select none
		for node in objects do
		(
			tempidata = getAppData node value_array[AppData.selection*2]
			boolAppData = (tempidata == (IGNameList.items[toto]) )
			appDataUndefined = (tempidata == undefined)
			appDataEmpty = ((IGNameList.items[toto]) == "")
			if ( boolAppData or ( appDataUndefined and ( appDataEmpty ) ) ) then
			(
				unhide node
				selectmore node
			)
		)
	)

	fn refresh =
	(
		array=#()
		for node in objects do
		(
			tmpData = getAppData node value_array[AppData.selection*2]
			if (tmpData == undefined) then
				tmpData = ""
			found = false
			for i=1 to array.count do
			(
				if (array[i] == tmpData) then
				(
					found = true
					exit
				)
			)
			if (found == false) then
			(
				append array tmpData
			)
		)
		IGNameList.items = array
	)

	on RefreshBt pressed do
	(
		refresh()
	)

	on AppData selected sel do
	(
		refresh()
	)

	on select_rollout open do
	(
		temp = #()
		for i = 1 to (value_array.count/2) do
		(
			append temp value_array[i*2-1];
		)
		AppData.items = temp
		refresh()
	)
)

--

gc ()

if select_floater != undefined do
(
	closerolloutfloater select_floater
)

select_floater = newRolloutFloater "NeL select IG" 300 550
addrollout select_rollout select_floater rolledUp:false
