 namespace A
{
        public struct KeyValuePair[X,Y]
        {
                public this (_ : X, _ : Y)
                { (); }
        }

        public interface IComparer[T]
        {
                 Compare (mutable x : T) : int;
        }

        public class KeyValuePairComparer[K,V] : IComparer[KeyValuePair[K,V]]
        {
                public Compare (_ : KeyValuePair[K,V]) : int
                {
                         0;
                }
        }

        public class TreeBag[T]
        {
                 mutable comparer : IComparer[T];

                public this (comparer : IComparer[T])
                {
                        this.comparer = comparer;
                ();
                }

                public Find (item : ref T) : int
                {
                         comparer.Compare (item);
                }
        }

        public class X
        {
                public static Test () : void
                {
                        mutable pair = KeyValuePair (3, 89);
                        mutable comparer = KeyValuePairComparer ();
                        mutable bag = TreeBag (comparer);
                        _ = bag.Find (ref pair);
                }
        }
}

namespace B
{
        public class KeyValuePair[X,Y]
        {
                public this (_ : X, _ : Y)
                { (); }
        }

        public interface IComparer[T]
        {
                 Compare (_ : T) : int;
        }

        public class KeyValuePairComparer[K,V] : IComparer[KeyValuePair[K,V]]
        {
                public Compare (_ : KeyValuePair[K,V]) : int
                {
                         0;
                }
        }

        public class TreeBag[T]
        {
                 mutable comparer : IComparer[T];

                public this (mutable comparer : IComparer[T])
                {
                        this.comparer = comparer;
                ();
                }

                public Find (mutable item : ref T) : int
                {
                         comparer.Compare (item);
                }
        }

        public class X
        {
                public static Test () : void
                {
                        mutable pair = KeyValuePair (3, 89);
                        mutable comparer = KeyValuePairComparer ();
                        mutable bag = TreeBag (comparer);
                        _ = bag.Find (ref pair);
                }
        }
}

class X
{
        static Main () : void
        {
                A.X.Test ();
                B.X.Test ();
        ();
        }
}

/*
BEGIN-OUTPUT
END-OUTPUT
*/
