using Nemerle.IO;

class C {
  static this () {
    printf ("static ctor\n");
  }

  public this () {
    printf ("object ctor\n");
  }
}

class A {
  static this () {}
}

namespace RecordMacros 
{
  [Record (Include = [a, b, c])]
  class X1 {
    a : int; 
    aa : int;
    b : string;
    bb : string;
    c : double;
    cc : list [int];
  }
  
  [Record (Include = ".*sny", Exclude = "bra.*")]
  class X2 {
    x : int; // not included
    krasny : double;
    brasny : string; // not included
    pomosny : list [int];
  }
  
  [Record (Exclude = [xx])]
  class X3 {
    x : int;
    xx : string;
    xxx : double;
  }

  module A {
    Run () : void {
      def _ = X1(1, "a", 1.1);
      def _ = X2(2.0, []);
      def _ = X3(1, 1.1);  
    }
  }  
}

module M {
  public Main () : void {
    def _ = C ();
    _ = A ();
  }
}
/*
BEGIN-OUTPUT
static ctor
object ctor
END-OUTPUT
*/
