using System;

namespace POP3Client
{
	public enum Error
	{
		| FATALERROR
		| ERROR
	}
	
	
	public class CommandException : Exception
	{
		protected mutable error    : Error;
		protected mutable progress : int;
		protected mutable object_  : object;


		public this (error : Error)
		{
			this.error = error;
		}


		public this (error : Error, message : string)
		{
			base (message.Split ("\r".ToCharArray ())[0]);
			
			this.error = error;
		}


		public Type : Error
		{
			get	{ error	}
		}


		public Object : object
		{
			get { object_ }
			set	{ object_ = value }
		}


		public Progress : int
		{
			get { progress }
			set { progress = value }
		}
	}
}
