using System;
using System.IO;
using System.Xml;
using System.Net.Sockets;
using System.Threading;
using Nemerle.Collections;
using Gtk;
using Glade;

namespace Chat
{
    public class Communicator
    {

        // PRIVATE FIELDS
        private nick   : string;
        private store  : ListStore;
        private table  : Hashtable[string ,TreeIter];
        private thread : Thread;
        private dialog : Dialog;
        private server : string;
        private port   : int;
        // private iter   : TreeIter;
        
        private server_stream : NetworkStream;

        //Gtk WIDGETS
        [Glade.Widget] private window1    : Window;
        [Glade.Widget] private treeview1  : TreeView;
        [Glade.Widget] private textview1  : TextView;
        [Glade.Widget] private entry1     : Entry;        
        [Glade.Widget] private scrolledwindow1  : ScrolledWindow;
        
        // PRIVATE CLASSES
        private class Nick
        {
            // PRIVATE FIELDS
            private args : array[string];
            
            // Gtk WIDGETS
           // [Glade.Widget] private entry1  : Entry;
           // [Glade.Widget] private button1 : Button;
           // [Glade.Widget] private window1 : Window;

            //CONSTRUCTOR
            public this (args : array[string]) 
            {
                this.args = args;
                Application.Init();
                def gxml = Glade.XML ("nick.glade", "window1", null);
                gxml.Autoconnect (this);
                Application.Run();
            }

            // EVENTS
            /*
            public on_window1_delete_event (_ : object, args : DeleteEventArgs) : void
            {
                Application.Quit ();
                args.RetVal = true;
            }

            public on_entry1_activate(_ : object, _ : EventArgs) : void
            {
                when(entry1.Text != "")
                {
                    (window1 : Gtk.Object).Destroy();
                    def _ = Communicator(entry1.Text,args);
                    ()
                }
            }

            public on_button1_clicked(_ : object, _ : EventArgs) : void
            {
                when(entry1.Text != "")
                {
                    (window1 : Gtk.Object).Destroy();
                    def _ = Communicator(entry1.Text,args);
                    ()
                }
            }
            */
        }

        // MAIN METHOD
        
        public static Main(args : array[string]) : void
        {
            if(args.Length >= 1 && args[0]=="--help")
            {
                Console.WriteLine("usage: chat.exe [options] SERVER_NAME PORT");
                Console.WriteLine("options:");
                Console.WriteLine("\t--help               - displays this message\n");
                Console.WriteLine("parameters:");
                Console.WriteLine("\tSERVER_NAME - name of server to connect (default - localhost)");
                Console.WriteLine("\tPORT        - number of port used to communicate (default - 3000)\n");
            }
            else
            {
                def _ = Nick(args);
                ()
            }
        }

        // CONSTRUCTOR
        
        public this (nick : string,args : array[string]) 
        {
            table     = Hashtable();
            store     = ListStore(array [typeof(string)]);
            this.nick = nick;

            server = if(args.Length < 1)
                         "localhost";
                      else
                          args[0];
                          
            port = if(args.Length < 2)
                       3000
                    else
                        int.Parse(args[1]);
            // CONNECT TO SERVER
            try
            {
                def stream = connect(server,port,nick);
                server_stream = stream;
                def msg    = receive(server_stream);
                def doc    = XmlDocument();
                
                doc.LoadXml(msg);
                def nodes = doc.SelectNodes("userlist/login");
                
                for(mutable i=0;i<nodes.Count;i=i+1)
                {
                    def iter = store.AppendValues( array[nodes[i].InnerText]);
                    table.Add(nodes[i].InnerText,iter);
                };
                
                // glade start
                Application.Init();
                def gxml = Glade.XML ("gui.glade", "window1", null);
                gxml.Autoconnect (this);
                
                window1.Title   = "Interactive chat: " + nick;
                treeview1.Model = store;
                ignore(treeview1.AppendColumn ("Users", CellRendererText (), array[("text" : object),(0 : object)]));
                scrolledwindow1.Vadjustment.Changed += on_scrolledwindow1_vadjustment_changed;
                thread = Thread(ThreadStart(handle_messages));
                thread.Start();
                Application.Run();
                // glade end
            }
            catch
            {
                _ is SocketException =>
                {
                    dialog = Dialog ();
                    dialog.Title = "Cannot connect to server";
                    ignore(dialog.AddButton ("Close", 5));
                    dialog.Response += ResponseHandler (ResponseCB);
                    dialog.SetDefaultSize (250, 40);
                    ignore(dialog.Run());
                    Application.Quit();
                }
            }
            
        }

        // PRIVATE METHODS
        
        private static connect (server : string,port : int,nick : string) : NetworkStream
        {
            def client = TcpClient(server,port);
            def stream = client.GetStream();
            def con    = Connect( nick );
            con.Send(stream);
            stream
        }
        
        private static receive(stream : NetworkStream) : string
        {
            def buffer = array (1024);
            mutable msg               = string.Empty;
            mutable numberOfBytesRead = 0;
            
            numberOfBytesRead = stream.Read(buffer, 0, buffer.Length);  
            msg = 
            String.Concat(msg, System.Text.Encoding.ASCII.GetString(buffer, 0, numberOfBytesRead));
            while(stream.DataAvailable)
            {
                numberOfBytesRead = stream.Read(buffer, 0, buffer.Length);  
                msg = 
                String.Concat(msg, System.Text.Encoding.ASCII.GetString(buffer, 0, numberOfBytesRead));
            };
            msg
        }

        private handle_messages() : void
        {
            try
            {
            while(true)
            {
                def msg = receive(server_stream);
                def doc = XmlDocument();
                doc.LoadXml(msg);
                def mes_node = doc.SelectNodes("message");
                if(mes_node.Count==1)
                {
                    textview1.Buffer.Text = textview1.Buffer.Text + mes_node[0].SelectSingleNode("login").InnerText + "> "
                                             + mes_node[0].SelectSingleNode("message").InnerText + "\n";
                }
                else
                {
                    def add_node = doc.SelectNodes("addtolist/login");
                    if(add_node.Count==1)
                    {
                        def iter = store.AppendValues( array[add_node[0].InnerText]);
                        table.Add(add_node[0].InnerText,iter);
                    }
                    else
                    {
                        def remove_node = doc.SelectNodes("removefromlist/login");
                        when(remove_node.Count==1)
                        {
                            match(table.Get(remove_node[0].InnerText))
                            {
                                | None => ()
                                | Some(iter) => //ignore(TreeMod.Remove(store,store.GetPath(iter)));
                                  {
                                      mutable treeiter = iter;
                                      ignore(store.Remove(ref treeiter));
                                  }
                            };
                            table.Remove(remove_node[0].InnerText);
                        }
                    }
                }
            }
            }
            catch
            {
                | _ is IOException  => Application.Quit();System.Environment.Exit (0);
                | _ is XmlException =>
                  {
                      Console.WriteLine("Server disconnected");
                      thread.Abort();
                      Application.Quit();
                      System.Environment.Exit (0);
                  }
            }   
        }
        
        // EVENTS

        private static  ResponseCB (_ : object, _ : ResponseArgs) : void
        {
            Application.Quit ();
            System.Environment.Exit (0);
        }

        
        public on_entry1_activate(_ : object, _ : EventArgs) : void
        {
            when(entry1.Text!="")
            {
                try{
                    textview1.Buffer.Text = textview1.Buffer.Text + nick + "> " + entry1.Text + "\n";
                    def message = Message(nick,entry1.Text);
                    message.Send(server_stream);
                    entry1.Text = "";
                }
                catch
                {
                    | _ is IOException  =>
                      {
                          Console.WriteLine("Server disconnected");
                          thread.Abort();
                          Application.Quit();
                          System.Environment.Exit (0);
                      }
                }
            }
        }
        
        public on_treeview1_row_activated(_ : object, args : RowActivatedArgs) : void
        {
            Console.WriteLine("---"+args.Column.ToString());
        }

        public on_window1_delete_event (_ : object, args : DeleteEventArgs) : void
        {
            thread.Abort();
            Application.Quit();
            args.RetVal = true;
            System.Environment.Exit (0);
        }

        public on_scrolledwindow1_vadjustment_changed (_ : object,_ : EventArgs) : void
        {
            scrolledwindow1.Vadjustment.Value = scrolledwindow1.Vadjustment.Upper - scrolledwindow1.Vadjustment.PageSize;
            scrolledwindow1.Vadjustment.ChangeValue();
        }
        
    }
}
