/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.refactoring.whereused;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import javax.jmi.reflect.RefObject;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.taglib.TLDLoader;
import org.netbeans.modules.web.taglib.model.FunctionType;
import org.netbeans.modules.web.taglib.model.TagType;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.netbeans.modules.web.taglib.model.ValidatorType;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

/**
 *
 * @author Martin Grebac
 */
public final class TldWhereUsedRefactoring {
    
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.whereused");   // NOI18N

    public TldWhereUsedRefactoring() { }

    /** Find usages in web deployment descriptor: web.xml 
     */
    public Problem prepare(AbstractRefactoring refactoring, RefObject refObject, RefactoringElementsBag refactoringElements) {
            
        Problem problem = null;
        if (refObject instanceof JavaClass) {
            
            JavaClass jClass = (JavaClass)refObject;
            err.log("jClass: " + jClass);
            
            String name = jClass.getName();
            err.log("name: " + name);
            Resource res = jClass.getResource();
            err.log("res: " + res);
            
            FileObject fo = JavaModel.getFileObject(res);
            err.log("fo: " + fo);

            WebModule wm = WebModule.getWebModule(fo);
            if (wm != null) {              // the class is in a web module
                FileObject webInf = wm.getWebInf();
                Enumeration e = null;
                if (webInf != null) {
                    e = webInf.getChildren(true);
                }
                if (e != null) {
                    while (e.hasMoreElements()) {
                        FileObject tld = (FileObject)e.nextElement();
                        if (isTld(tld)) {
                            DataObject tldData = null;
                            try {
                                tldData = DataObject.find(tld);
                            } catch (DataObjectNotFoundException dne) {
                                // ignore
                            }
                            if ((tldData != null) && (tldData instanceof TLDDataObject)) {
                                Taglib taglib = null;
                                try {
                                    taglib = ((TLDDataObject)tldData).getTaglib();
                                } catch (IOException ioe) {}
                                if (taglib != null) {
                                    // tag element
                                    TagType[] tagTypes = taglib.getTag();
                                    if ((tagTypes != null) && (tagTypes.length > 0)) {
                                        for (int tt = 0; tt < tagTypes.length; tt++) {
                                            TagType tagT = tagTypes[tt];
                                            String tagClass = tagT.getTagClass();
                                            if ((tagClass != null) && (tagClass.equals(name))) {
                                                RefactoringElementImplementation elem = new TaglibTagClassWhereUsedRefactoringElement(taglib, name, tld);
                                                refactoringElements.add(refactoring, elem);
                                            }
                                            String teiClass = tagT.getTeiClass();
                                            if ((teiClass != null) && (teiClass.equals(name))) {
                                                RefactoringElementImplementation elem = new TaglibTeiClassWhereUsedRefactoringElement(taglib, name, tld);
                                                refactoringElements.add(refactoring, elem);
                                            }
                                        }
                                    }

                                    FunctionType[] functionTypes = taglib.getFunction();
                                    if ((functionTypes != null) && (functionTypes.length > 0)) {
                                        for (int tt = 0; tt < functionTypes.length; tt++) {
                                            FunctionType functionT = functionTypes[tt];
                                            String functionClass = functionT.getFunctionClass();
                                            if ((functionClass != null) && (functionClass.equals(name))) {
                                                RefactoringElementImplementation elem = new TaglibFunctionClassWhereUsedRefactoringElement(taglib, name, tld);
                                                refactoringElements.add(refactoring, elem);
                                            }
                                        }
                                    }

                                    // validator element
                                    ValidatorType validatorType = taglib.getValidator();
                                    if (validatorType != null) {
                                        String validatorClass = validatorType.getValidatorClass();
                                        if ((validatorClass != null) && (validatorClass.equals(name))) {
                                            RefactoringElementImplementation elem = new TaglibValidatorClassWhereUsedRefactoringElement(taglib, name, tld);
                                            refactoringElements.add(refactoring, elem);
                                        }
                                    }

                                    // listener element
                                    org.netbeans.modules.web.taglib.model.ListenerType[] listenerTypes = taglib.getListener();
                                    if ((listenerTypes != null) && (listenerTypes.length > 0)) {
                                        for (int tt = 0; tt < listenerTypes.length; tt++) {
                                            org.netbeans.modules.web.taglib.model.ListenerType listenerT = listenerTypes[tt];
                                            String listenerClass = listenerT.getListenerClass();
                                            if ((listenerClass != null) && (listenerClass.equals(name))) {
                                                RefactoringElementImplementation elem = new TaglibListenerClassWhereUsedRefactoringElement(taglib, name, tld);
                                                refactoringElements.add(refactoring, elem);
                                            }
                                        }
                                    }

                                } else {
                                    Object[] args = new Object [] {tld.getNameExt()};
                                    String msg = MessageFormat.format(NbBundle.getMessage(TldWhereUsedRefactoring.class, "TXT_TaglibWhereUsedInvalidProblem"), args);
                                    Problem newProblem = new Problem(false, msg);
                                    problem = Utility.addProblemsToEnd(problem, newProblem);
                                }
                            }
                        }
                    }
                }
            }
        } // javaclass
        return problem;
    }

    private boolean isTld(FileObject fo) {
        boolean isTld = false;
        if (fo != null) {
            String ext = fo.getExt();
            if (TLDLoader.tldExt.equalsIgnoreCase(ext)) {
                isTld = true;
            }
        }
        return isTld;
    }
    
    public final class TaglibTagClassWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected Taglib taglib;

        /** Creates a new instance of TaglibTagClassWhereUsedRefactoringElement */
        public TaglibTagClassWhereUsedRefactoringElement(Taglib taglib, String name, FileObject parentFile) { 
            this.taglib = taglib;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(TldWhereUsedRefactoring.class, "TXT_TaglibTagClassWhereUsed"), args);
        }
    }

    public final class TaglibTeiClassWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected Taglib taglib;

        /** Creates a new instance of TaglibTeiClassWhereUsedRefactoringElement */
        public TaglibTeiClassWhereUsedRefactoringElement(Taglib taglib, String name, FileObject parentFile) { 
            this.taglib = taglib;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(TldWhereUsedRefactoring.class, "TXT_TaglibTeiClassWhereUsed"), args);
        }
    }

    public final class TaglibValidatorClassWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected Taglib taglib;

        /** Creates a new instance of TaglibValidatorClassWhereUsedRefactoringElement */
        public TaglibValidatorClassWhereUsedRefactoringElement(Taglib taglib, String name, FileObject parentFile) { 
            this.taglib = taglib;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(TldWhereUsedRefactoring.class, "TXT_TaglibValidatorClassWhereUsed"), args);
        }
    }
    
    public final class TaglibListenerClassWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected Taglib taglib;

        /** Creates a new instance of TaglibListenerClassWhereUsedRefactoringElement */
        public TaglibListenerClassWhereUsedRefactoringElement(Taglib taglib, String name, FileObject parentFile) { 
            this.taglib = taglib;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(TldWhereUsedRefactoring.class, "TXT_TaglibListenerClassWhereUsed"), args);
        }
    }    

    public final class TaglibFunctionClassWhereUsedRefactoringElement extends AbstractWhereUsedRefactoringElement {

        protected Taglib taglib;

        /** Creates a new instance of TaglibFunctionClassWhereUsedRefactoringElement */
        public TaglibFunctionClassWhereUsedRefactoringElement(Taglib taglib, String name, FileObject parentFile) { 
            this.taglib = taglib;
            this.name = name;
            this.parentFile = parentFile;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {name};
            return MessageFormat.format(NbBundle.getMessage(TldWhereUsedRefactoring.class, "TXT_TaglibFunctionClassWhereUsed"), args);
        }
    }    
        
}
