/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Ralph Krueger.
 */
package org.netbeans.modules.changelog.wizard;

/**
 *
 * @author  ralph
 */

import org.openide.util.*;
import org.openide.*;
import org.openide.filesystems.*;
import org.openide.loaders.*;
import org.openide.modules.*;

import javax.swing.event.*;
import javax.swing.*;
import java.util.*;
import org.netbeans.modules.changelog.*;
import org.netbeans.modules.changelog.html.*;


public class HtmlPanel extends javax.swing.JPanel {

    private HtmlPanelCustomizer customizer;
    private ChangeLogHTMLService[] array;
    private boolean loadingSemafore = false;
    /** Creates new form FilterPanel */
    public HtmlPanel() {
        initComponents();
        putClientProperty ("WizardPanel_contentSelectedIndex", new Integer (2)); // NOI18N
        customizer = new HtmlPanelCustomizer();
        customizer.disableEditing(true);
        pnlCustom.add(customizer, java.awt.BorderLayout.CENTER);
        
        array = null;
        
        comServerDef.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent event) {
                if (!loadingSemafore) {
                    changeItem();
                }
            }
        });
        btnEdit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent event) {
                doEdit();
            }
        });
        btnSaveAs.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent event) {
                doSaveAs();
            }
        });
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        lblServerDef = new javax.swing.JLabel();
        comServerDef = new javax.swing.JComboBox();
        btnEdit = new javax.swing.JButton();
        btnSaveAs = new javax.swing.JButton();
        pnlCustom = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        setMinimumSize(new java.awt.Dimension(400, 200));
        setPreferredSize(new java.awt.Dimension(600, 300));
        getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACSN_HtmlPanel"));
        getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACSD_HtmlPanel"));
        lblServerDef.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_lblServerDef_mnc").charAt(0));
        lblServerDef.setLabelFor(comServerDef);
        lblServerDef.setText(org.openide.util.NbBundle.getBundle(HtmlPanel.class).getString("HtmlPanel.lblServerDef.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 0);
        add(lblServerDef, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 6, 0, 0);
        add(comServerDef, gridBagConstraints);
        comServerDef.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACSD_comServerDef"));

        btnEdit.setMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_btnEdit_mnc").charAt(0));
        btnEdit.setText(org.openide.util.NbBundle.getBundle(HtmlPanel.class).getString("HtmlPanel.btnEdit.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 6, 0, 0);
        add(btnEdit, gridBagConstraints);
        btnEdit.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACSD_btnEdit"));

        btnSaveAs.setMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_btnSaveAs_mnc").charAt(0));
        btnSaveAs.setText(org.openide.util.NbBundle.getBundle(HtmlPanel.class).getString("HtmlPanel.btnSave.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 6, 0, 12);
        add(btnSaveAs, gridBagConstraints);
        btnSaveAs.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACSD_btnSaveAs"));

        pnlCustom.setLayout(new java.awt.BorderLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 12, 12);
        add(pnlCustom, gridBagConstraints);

    }//GEN-END:initComponents
    
    private void changeItem() {
        int index = comServerDef.getSelectedIndex();
        customizer.setObject(array[index]);
        customizer.disableEditing(true);
    }
    
    private void doEdit() {
        customizer.disableEditing(false);
    }
    
    private void doSaveAs() {
        // optionally:
        int index = comServerDef.getSelectedIndex();
        NotifyDescriptor.InputLine dial = new NotifyDescriptor.InputLine("Name:", "Save As", NotifyDescriptor.OK_CANCEL_OPTION, NotifyDescriptor.QUESTION_MESSAGE);
        Object ret = TopManager.getDefault().notify(dial);
        if (ret.equals(NotifyDescriptor.OK_OPTION)) {
            ChangeLogHTMLService service = array[index];
            service.setName(dial.getInputText());
            DataFolder f = DataFolder.findFolder(
                Repository.getDefault().getDefaultFileSystem().findResource("Services/ChangeLogHtmlType")); //NOI18N
            ModuleInfo m = null;
            Iterator it = Lookup.getDefault().lookup(
                new Lookup.Template(ModuleInfo.class,
                    null, null)).allInstances().iterator();
            while (it.hasNext()) {
                ModuleInfo _m = (ModuleInfo)it.next();
                if (_m.getCodeNameBase().equals("org.netbeans.modules.changelog")) { //NOI18N
                    m = _m;
                    break;
                }
            }
            if (m == null) throw new IllegalStateException();
            try {
                InstanceDataObject ido = InstanceDataObject.create(f, null, service, m, true);
            } catch (java.io.IOException exc) {
                ErrorManager.getDefault().log(ErrorManager.USER, "Cannot save new Server Info"); 
                return;
            }
        }
        loadCombo();
        comServerDef.setSelectedIndex(array.length - 1);
        changeItem();
    }
    
    private void loadCombo() {
        //INIT combobox..
        loadingSemafore = true;
        Lookup.Template template = new Lookup.Template(ChangeLogHTMLService.class);
        Lookup.Result result = Lookup.getDefault().lookup(template);
        Collection coll = result.allInstances();
        array = new ChangeLogHTMLService[coll.size() + 1];
        String[] names = new String[coll.size() + 1];
        Iterator it = coll.iterator();
        int count = 1;
        while (it.hasNext()) {
            ChangeLogHTMLService serv = (ChangeLogHTMLService)it.next();
            array[count] = (ChangeLogHTMLService)serv.createClone();
            names[count] = serv.getName();
            count = count + 1;
        }
        array[0] = new ChangeLogHTMLService();
        names[0] = org.openide.util.NbBundle.getBundle(HtmlPanel.class).getString("No_server_specific_processing");
        comServerDef.setModel(new DefaultComboBoxModel(names));
        loadingSemafore = false;
        
    }
    

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnSaveAs;
    private javax.swing.JComboBox comServerDef;
    private javax.swing.JButton btnEdit;
    private javax.swing.JPanel pnlCustom;
    private javax.swing.JLabel lblServerDef;
    // End of variables declaration//GEN-END:variables


    public static class Panel implements org.openide.WizardDescriptor.Panel  {

        private HtmlPanel panel;
        private String name;


        public Panel (String name) {
            this.name = name;
        }

        /** Get the component displayed in this panel.
         * @return the component
         */
        public synchronized java.awt.Component getComponent() {
            if (this.panel == null) {
                this.panel = new HtmlPanel();
                this.panel.setName (this.name);
            }
            return this.panel;
        }

        /** Help for this panel.
         * When the panel is active, this is used as the help for the wizard dialog.
         * @return the help or <code>null</code> if no help is supplied
         */
        public HelpCtx getHelp() {
            return new HelpCtx(this.getClass());
        }

        /** Add a listener to changes of the panel's validity.
         * @param l the listener to add
         * @see #isValid
         */
        public void addChangeListener(ChangeListener l) {
        }

        /** Remove a listener to changes of the panel's validity.
         * @param l the listener to remove
         */
        public void removeChangeListener(ChangeListener l) {
        }

        public boolean isValid() {
            return true;
        }

        /** Provides the wizard panel with the opportunity to update the
         * settings with its current customized state.
         * Rather than updating its settings with every change in the GUI, it should collect them,
         * and then only save them when requested to by this method.
         * Also, the original settings passed to {@link #readSettings} should not be modified (mutated);
         * rather, the (copy) passed in here should be mutated according to the collected changes.
         * This method can be called multiple times on one instance of <code>WizardDescriptor.Panel</code>.
         * @param settings the object representing a settings of the wizard
         */
        public void storeSettings(Object settings) {
            if (settings instanceof ChangeLogProcessor) {
                ChangeLogProcessor proces = (ChangeLogProcessor)settings;
                HtmlPanel p = (HtmlPanel) this.getComponent();
                if (p.comServerDef.getSelectedIndex() != 0) {
                    int index = p.comServerDef.getSelectedIndex();
                    proces.setHtmlSiteProcessor(p.array[index]);
                } else {
                    proces.setHtmlSiteProcessor(null);
                }
            }
        }

        /** Provides the wizard panel with the current data--either
         * the default data or already-modified settings, if the user used the previous and/or next buttons.
         * This method can be called multiple times on one instance of <code>WizardDescriptor.Panel</code>.
         * @param settings the object representing wizard panel state, as originally supplied to {@link WizardDescriptor#WizardDescriptor(WizardDescriptor.Iterator,Object)}
         * @exception IllegalStateException if the the data provided
         * by the wizard are not valid.
         */
        public void readSettings(Object settings) {
            if (settings instanceof ChangeLogProcessor) {
                HtmlPanel p = (HtmlPanel) this.getComponent();
                p.loadCombo();
                ChangeLogProcessor proces = (ChangeLogProcessor)settings;
                if (proces.getHtmlSiteProcessor() == null) {
                    p.comServerDef.setSelectedIndex(0);
                    p.changeItem();
                } else {
                    ChangeLogHTMLService service = proces.getHtmlSiteProcessor();
                    for (int i = 0; i < p.array.length; i++) {
                        if (p.array[i].getName().equals(service.getName())) {
                            p.comServerDef.setSelectedIndex(i);
                            p.changeItem();
                            break;
                        }
                    }
                }
            }
        }

    }

}
