package org.netbeans.modules.scala.project.ui.wizards;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.scala.project.ui.UIUtil;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/**
 * @author  Martin Krauskopf
 */
final class BasicInfoVisualPanel extends BasicVisualPanel {
    
    private final NewScalaProjectWizardData data;
    
    private boolean nameUpdated;
    private boolean locationUpdated;
    
    BasicInfoVisualPanel(final NewScalaProjectWizardData data) {
        super(data.getSettings());
        this.data = data;
        initComponents();
        attachDocumentListeners();
        initValues();
    }
    
    private void initValues() {
        locationText.setText(data.getProjectLocation());
        String projectName = data.getProjectName();
        nameText.setText(projectName);
        mainClassText.setText(projectName + ".Main"); // NOI18N
    }
    
    private void attachDocumentListeners() {
        DocumentListener fieldsDL = new UIUtil.DocumentAdapter() {
            public void insertUpdate(DocumentEvent e) { updateAndCheck(); }
        };
        nameText.getDocument().addDocumentListener(fieldsDL);
        nameText.getDocument().addDocumentListener(new UIUtil.DocumentAdapter() {
            public void insertUpdate(DocumentEvent e) { nameUpdated = true; }
        });
        locationText.getDocument().addDocumentListener(fieldsDL);
        locationText.getDocument().addDocumentListener(new UIUtil.DocumentAdapter() {
            public void insertUpdate(DocumentEvent e) { locationUpdated = true; }
        });
    }
    
    void updateAndCheck() {
        folderText.setText(getFolder().getPath());
        
        if ("".equals(getNameText())) {
            setError(getMessage("MSG_NameCannotBeEmpty"));
        } else if ("".equals(getLocationText())) {
            setError(getMessage("MSG_LocationCannotBeEmpty"));
        } else if (getFolder().exists()) {
            setError(getMessage("MSG_ProjectFolderExists"));
        } else if (!getLocationFile().exists()) {
            setError(getMessage("MSG_LocationMustExist"));
        } else if (!getLocationFile().canWrite()) {
            setError(getMessage("MSG_LocationNotWritable"));
        } else {
            markValid();
        }
    }
    
    protected void storeData() {
        data.setProjectName(getNameText());
        data.setProjectLocation(getLocationText());
        data.setProjectFolder(folderText.getText());
        data.setSetAsMainProject(setAsMainProject.isSelected());
        data.setCreateMainClass(createMainClass.isSelected());
        data.setMainClass(mainClassText.getText());
    }
    
    private File getFolder() {
        StringBuilder destFolder = new StringBuilder(getLocationText());
        if (destFolder.length() != 0) {
            destFolder.append(File.separator);
        }
        destFolder.append(getNameText());
        return FileUtil.normalizeFile(new File(destFolder.toString()));
    }
    
    private String getNameText() {
        return nameText.getText().trim();
    }
    
    private String getLocationText() {
        return locationText.getText().trim();
    }
    
    private File getLocationFile() {
        return new File(getLocationText());
    }
    
    private static String getMessage(String key) {
        return NbBundle.getMessage(BasicInfoVisualPanel.class, key);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        nameLabel = new javax.swing.JLabel();
        locationLabel = new javax.swing.JLabel();
        folderLabel = new javax.swing.JLabel();
        nameText = new javax.swing.JTextField();
        locationText = new javax.swing.JTextField();
        folderText = new javax.swing.JTextField();
        browseButton = new javax.swing.JButton();
        separator = new javax.swing.JSeparator();
        setAsMainProject = new javax.swing.JCheckBox();
        createMainClass = new javax.swing.JCheckBox();
        mainClassText = new javax.swing.JTextField();

        nameLabel.setLabelFor(nameText);
        org.openide.awt.Mnemonics.setLocalizedText(nameLabel, org.openide.util.NbBundle.getMessage(BasicInfoVisualPanel.class, "BasicInfoVisualPanel.nameLabel.text")); // NOI18N

        locationLabel.setLabelFor(locationText);
        org.openide.awt.Mnemonics.setLocalizedText(locationLabel, org.openide.util.NbBundle.getMessage(BasicInfoVisualPanel.class, "BasicInfoVisualPanel.locationLabel.text")); // NOI18N

        folderLabel.setLabelFor(folderText);
        org.openide.awt.Mnemonics.setLocalizedText(folderLabel, org.openide.util.NbBundle.getMessage(BasicInfoVisualPanel.class, "BasicInfoVisualPanel.folderLabel.text")); // NOI18N

        folderText.setEditable(false);

        org.openide.awt.Mnemonics.setLocalizedText(browseButton, org.openide.util.NbBundle.getMessage(BasicInfoVisualPanel.class, "BasicInfoVisualPanel.browseButton.text")); // NOI18N
        browseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseButtonActionPerformed(evt);
            }
        });

        setAsMainProject.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(setAsMainProject, org.openide.util.NbBundle.getMessage(BasicInfoVisualPanel.class, "BasicInfoVisualPanel.setAsMainProject.text")); // NOI18N
        setAsMainProject.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        setAsMainProject.setMargin(new java.awt.Insets(0, 0, 0, 0));

        createMainClass.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(createMainClass, org.openide.util.NbBundle.getMessage(BasicInfoVisualPanel.class, "BasicInfoVisualPanel.createMainClass.text")); // NOI18N
        createMainClass.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        createMainClass.setMargin(new java.awt.Insets(0, 0, 0, 0));

        mainClassText.setText(org.openide.util.NbBundle.getMessage(BasicInfoVisualPanel.class, "BasicInfoVisualPanel.mainClassText.text")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(locationLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(folderLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(nameLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(nameText, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 173, Short.MAX_VALUE)
                    .add(folderText, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 173, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(locationText, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 173, Short.MAX_VALUE)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(browseButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 80, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
            .add(layout.createSequentialGroup()
                .add(12, 12, 12)
                .add(separator, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 341, Short.MAX_VALUE)
                .addContainerGap())
            .add(layout.createSequentialGroup()
                .add(setAsMainProject)
                .addContainerGap())
            .add(layout.createSequentialGroup()
                .add(createMainClass)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(mainClassText, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 235, Short.MAX_VALUE))
        );

        layout.linkSize(new java.awt.Component[] {folderLabel, locationLabel, nameLabel}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(nameText, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(nameLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(browseButton)
                    .add(locationLabel)
                    .add(locationText, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(folderText, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(folderLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(separator, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(setAsMainProject)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(createMainClass)
                    .add(mainClassText, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(161, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    private void browseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseButtonActionPerformed
        JFileChooser chooser = new JFileChooser(getLocationText());
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int ret = chooser.showOpenDialog(this);
        if (ret == JFileChooser.APPROVE_OPTION) {
            locationText.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }//GEN-LAST:event_browseButtonActionPerformed
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton browseButton;
    private javax.swing.JCheckBox createMainClass;
    private javax.swing.JLabel folderLabel;
    private javax.swing.JTextField folderText;
    private javax.swing.JLabel locationLabel;
    private javax.swing.JTextField locationText;
    private javax.swing.JTextField mainClassText;
    javax.swing.JLabel nameLabel;
    private javax.swing.JTextField nameText;
    private javax.swing.JSeparator separator;
    private javax.swing.JCheckBox setAsMainProject;
    // End of variables declaration//GEN-END:variables
    
}
