/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.groovy.support.common;

import java.util.HashMap;
import java.util.Map;
import org.openide.actions.*;
import org.openide.filesystems.FileObject;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

/** 
 * Recognizes single files in the Repository as being of a certain type.
 *
 * @author Petr Hamernik
 */
public abstract class ScriptLoader extends MultiFileLoader {
    /** Name of the property 'extensions'
     */
    public static final String PROP_EXTENSIONS = "extensions"; // NOI18N
 
    static final long serialVersionUID = 3325143099729278589L;

    /** Create new instance of loader
     */
    public ScriptLoader() {
        this("org.netbeans.modules.groovy.support.common.ScriptDataObject"); // NOI18N
    }
    
    /** Constructor for subclasses.
     */
    protected ScriptLoader( String recognizedObjectClass ) {
        super(recognizedObjectClass);
    }
    
    @Override
    protected String defaultDisplayName() {
        return NbBundle.getMessage(ScriptLoader.class, "LBL_loaderName");
    }
    
    @Override
    protected SystemAction[] defaultActions() {
        return new SystemAction[] {
            SystemAction.get(OpenAction.class),
            SystemAction.get(RunScriptAction.class),
            null,
            SystemAction.get(CutAction.class),
            SystemAction.get(CopyAction.class),
            SystemAction.get(PasteAction.class),
            null,
            SystemAction.get(DeleteAction.class),
            SystemAction.get(RenameAction.class),
            null,
            SystemAction.get(SaveAsTemplateAction.class),
            null,
            SystemAction.get(ToolsAction.class),
            SystemAction.get(PropertiesAction.class),
        };
    }
    
    /** @return The list of extensions this loader recognizes
    * (the default contains only java)
    */
    public abstract ExtensionList getExtensions ();
    
    /** Subclasses should specify the mime type of the script file.
     */
    public abstract String getScriptMIME();

    protected FileObject findPrimaryFile (FileObject fo) {
	// never recognize folders.
        if (fo.isFolder()) return null;
        if (getExtensions().isRegistered(fo)) {
            return fo;
        }
        return null;
    }
    
    protected MultiDataObject.Entry createPrimaryEntry (MultiDataObject obj, FileObject primaryFile) {
        FileEntry.Format entry = new FileEntry.Format(obj,primaryFile) {
            protected java.text.Format createFormat (FileObject target, String n, String e) {
                Map<String, String> m = new HashMap<String, String>();
                m.put( "NAME", n ); //NOI18N
                MapFormat f = new MapFormat( m );
                f.setLeftBrace( "__" ); //NOI18N
                f.setRightBrace( "__" ); //NOI18N
                return f;
            }
        };
        return entry;
    }
    
    protected MultiDataObject.Entry createSecondaryEntry (MultiDataObject obj, FileObject secondaryFile) {
        return new FileEntry(obj,secondaryFile);
    }
}
