/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.xml.xpath.visitor;

import java.util.Collection;
import java.util.Iterator;

import org.netbeans.modules.xml.xpath.LocationStep;
import org.netbeans.modules.xml.xpath.XPathCoreFunction;
import org.netbeans.modules.xml.xpath.XPathCoreOperation;
import org.netbeans.modules.xml.xpath.XPathExpression;
import org.netbeans.modules.xml.xpath.XPathExpressionPath;
import org.netbeans.modules.xml.xpath.XPathExtensionFunction;
import org.netbeans.modules.xml.xpath.XPathLocationPath;
import org.netbeans.modules.xml.xpath.XPathNumericLiteral;
import org.netbeans.modules.xml.xpath.XPathOperationOrFuntion;
import org.netbeans.modules.xml.xpath.XPathPredicateExpression;
import org.netbeans.modules.xml.xpath.XPathStringLiteral;
import org.netbeans.modules.xml.xpath.XPathVariableReference;


/**
 * 
 * @author radval
 *
 */
public abstract class AbstractXPathVisitor implements XPathVisitor {

	public void visit(LocationStep locationStep) {
	}

	public void visit(XPathCoreFunction coreFunction) {
	}

	public void visit(XPathCoreOperation coreOperation) {
	}

	public void visit(XPathExpressionPath expressionPath) {
	}

	public void visit(XPathExtensionFunction extensionFunction) {
	}

	public void visit(XPathLocationPath locationPath) {
	}

	public void visit(XPathNumericLiteral numericLiteral) {
	}

	public void visit(XPathStringLiteral stringLiteral) {
	}

	public void visit(XPathVariableReference vReference) {
	}
	
	
	public void visit(XPathPredicateExpression predicate) {
		XPathExpression predicateExpression = predicate.getPredicate();
		if(predicateExpression != null) {
			predicateExpression.accept(this);
		}
	}

	protected void visitChildren(XPathOperationOrFuntion expr) {
		 Collection children = expr.getChildren();
		 if(children != null) {
			 Iterator it = children.iterator();
			 while(it.hasNext()) {
				 XPathExpression child = (XPathExpression) it.next();
				 child.accept(this);
				 
			 }
		 }
	}
	
}
