/*

Copyright (C) 2000, 2001, 2002 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_main_h
#define __nd_main_h

#include <glib.h>

typedef struct nd_cmd_options
{
  /* When TRUE, enable debugging output: */
  gboolean     debug;

  /* When TRUE, list all registered protocols, then exit: */
  gboolean     show_protos;

} ND_CmdOptions;

extern ND_CmdOptions cmd_options;

/**
 * nd_main_safe_exit - exit routine with trace state checking.
 *
 * The function causes Netdude to exit. If there are any modified
 * traces still open, the exit dialog is shown for confirmation.
 */
void     nd_main_safe_exit(void);

/**
 * nd_main_unsafe_exit - fast exit.
 *
 * The function causes Netdude to exit immediately, without
 * checking for unsaved files etc. Called by nd_main_safe_exit()
 * when there are no unsaved traces.
 */
void     nd_main_unsafe_exit(void);

#endif
     
