geometry = ngsolve/pde_tutorial/square.in2d
mesh = ngsolve/pde_tutorial/square.vol

# geometry = ngsolve/pde_tutorial/cube.geo
# mesh = ngsolve/pde_tutorial/cube.vol

define coefficient lam
1,

define coefficient penalty
1e5, 0, 0, 0, 

define coefficient coef_source
1,

define fespace v -order=5
define gridfunction u -fespace=v -nested

define bilinearform a -fespace=v -symmetric
laplace lam
robin penalty

define linearform f -fespace=v
source coef_source

define preconditioner c -type=direct -bilinearform=a
# define preconditioner c -type=local -bilinearform=a
# define preconditioner c -type=multigrid -bilinearform=a -smoothingsteps=1


numproc bvp np1 -bilinearform=a -linearform=f -gridfunction=u -preconditioner=c -maxsteps=1000



define bilinearform ag -fespace=v -nonassemble
laplace lam
numproc drawflux np2 -bilinearform=ag -solution=u -label=flux
