/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgAddGroup.cpp: implementation of the DlgAddGroup class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgAddGroup.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgAddGroup, wxDialog)
    EVT_BUTTON(IDC_OK, DlgAddGroup::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgAddGroup::OnCancel)
END_EVENT_TABLE()

DlgAddGroup::DlgAddGroup(wxWindow * wParent, const UsersGroup & Group, PkiClient * ClientPKI):wxDialog(wParent, (wxWindowID)-1, (Group?_("Rename Group"):_("Add Group")), wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION)
{
	m_IsOK=false;

	m_Group = Group;
	m_ClientPKI = ClientPKI;

	DlgAddGroup_SetWindow(this);
	
	if(m_Group.get_name().size())
		((wxTextCtrl *)FindWindow(IDC_NAME))->SetValue(m_Group.get_name().c_str());

	CenterOnScreen();
	ShowModal();
}

DlgAddGroup::~DlgAddGroup()
{
}

bool DlgAddGroup::IsOK()
{
	return m_IsOK;
}

void DlgAddGroup::OnOk(wxCommandEvent& event)
{
	bool ret;
	wxString Name;
	Name = ((wxTextCtrl *)FindWindow(IDC_NAME))->GetValue();
	if(!Name.Len()) return;

	//Adding a group
	if(!m_Group.get_name().size())
	{
		if(DisplayMessage(this, _("Are you sure to want to create this group ?"), wxYES_NO) == wxNO) return;
	}

	DlgMessage dlg(this);
	
	if(!m_Group.get_name().size())
		dlg.wShow(_("Adding Group..."));
	else
		dlg.wShow(_("Modifying Group..."));

	//Adding a group
	if(!m_Group.get_name().size())
	{
		ret = m_ClientPKI->AddGroup(Name.GetData());
	}
	else
	{
		ret = m_ClientPKI->RenameGroup(m_Group.get_serial(), Name.GetData());
	}

	if(!ret)
	{
		dlg.wHide();
		HandleError(m_ClientPKI->GetError(), this);
		return;
	}
	dlg.wHide();
	Close(TRUE);
	m_IsOK = true;
}

void DlgAddGroup::OnCancel(wxCommandEvent& event)
{
	m_IsOK = false;
	Close(TRUE);
}
