/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgAddValueExt.cpp: implementation of the DlgAddValueExt class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgAddValueExt.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgAddValueExt, wxDialog)
    EVT_BUTTON(IDC_OK, DlgAddValueExt::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgAddValueExt::OnCancel)
END_EVENT_TABLE()



DlgAddValueExt::DlgAddValueExt(wxWindow * wParent, const mString & Name, const mString & Value):wxDialog(wParent, (wxWindowID)-1, (Name.size()?_("Modify Extension value"):_("Add Extension value")), wxDefaultPosition)
{
	m_IsOK = false;

	DlgAddValueExt_SetWindow(this);

	if(Name.size())
		((wxTextCtrl *)FindWindow(IDC_NAME))->SetValue(Name.c_str());
	if(Value.size())
		((wxTextCtrl *)FindWindow(IDC_VALUE))->SetValue(Value.c_str());

	CenterOnScreen();
	ShowModal();
}

DlgAddValueExt::~DlgAddValueExt()
{
}


const mString & DlgAddValueExt::GetName()
{
	return m_Name;
}

const mString & DlgAddValueExt::GetValue()
{
	return m_Value;
}

void DlgAddValueExt::OnOk(wxCommandEvent& event)
{
	wxString Name;
	wxString Value;

	Name = ((wxTextCtrl *)FindWindow(IDC_NAME))->GetValue();
	Value = ((wxTextCtrl *)FindWindow(IDC_VALUE))->GetValue();

	if(!Name.Len() || !Value.Len()) return;

	m_Name = Name.GetData();
	m_Value = Value.GetData();


	m_IsOK = true;
	Close(TRUE);
}
void DlgAddValueExt::OnCancel(wxCommandEvent& event)
{
	m_IsOK = false;
	Close(TRUE);
}

bool DlgAddValueExt::IsOK()
{
	return m_IsOK;
}
