/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgConfigureEE.cpp: implementation of the DlgConfigureEE class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgConfigureEE.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


BEGIN_EVENT_TABLE(DlgConfigureEE, wxDialog)
    EVT_BUTTON(IDC_OK, DlgConfigureEntity::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgConfigureEntity::OnCancel)
    EVT_COMBOBOX(IDC_DISCLAIMER_NAME, DlgConfigureEE::OnSetDisclaimer)
    EVT_CHECKBOX(IDC_CREATE_PROFILE, DlgConfigureEE::OnAllowCreateProfile)
    EVT_TEXT(IDC_DISCLAIMER_VALUE, DlgConfigureEE::OnDisclaimerChanged)
	EVT_CHECKBOX(IDC_ALLOW_LDAP_BIND, DlgConfigureEE::OnLdapBind)
END_EVENT_TABLE()


DlgConfigureEE::DlgConfigureEE(wxWindow * wParent, const PKI_CERT & entity_cert, PkiClient * ClientPki):DlgConfigureEntity(wParent, entity_cert, ClientPki)
{
	DlgConfigureEE_SetWindow(this);
	Frames = (wxNotebook*)FindWindow(ID_NOTEBOOK);
	
	((wxTextCtrl *)Frames->FindWindow(IDC_MIN_KEY_LEN))->Enable(false);
	((wxTextCtrl *)Frames->FindWindow(IDC_MIN_PWD_LEN))->Enable(false);
	((wxCheckBox *)Frames->FindWindow(IDC_REQUEST_P12))->Enable(false);
	((wxCheckBox *)Frames->FindWindow(IDC_REQUEST_P10))->Enable(false);
	((wxCheckBox *)Frames->FindWindow(IDC_GENERATE_P10))->Enable(false);

	if(!Init(ENTITY_TYPE_EE))
	{
		Close(TRUE);
		return;
	}

	CenterOnScreen();
	ShowModal();		
}

DlgConfigureEE::~DlgConfigureEE()
{
}

bool DlgConfigureEE::DisplayConf()
{
	wxString tt;
	size_t i;
	wxString Port;
	
	((wxTextCtrl *)Frames->FindWindow(IDC_SITE_NAME))->SetValue(m_EntityConf.get_eeConf().EE_CONF_PTR.get_siteName().c_str());

	dnValDisclaimer = m_EntityConf.get_eeConf().EE_CONF_PTR.get_dnValDisclaimer();
	((wxComboBox *)Frames->FindWindow(IDC_DISCLAIMER_NAME))->Append("DN Validation Disclaimer", (void*)&dnValDisclaimer);

	
	selectedDisclaimer = &dnValDisclaimer;
	((wxComboBox *)Frames->FindWindow(IDC_DISCLAIMER_NAME))->SetSelection(0);
	((wxTextCtrl *)Frames->FindWindow(IDC_DISCLAIMER_VALUE))->SetValue(dnValDisclaimer.c_str());

	tt.sprintf("%ld", m_EntityConf.get_eeConf().EE_CONF_PTR.get_minkeylen());
	((wxTextCtrl *)Frames->FindWindow(IDC_MIN_KEY_LEN))->SetValue(tt);
	tt.sprintf("%ld", m_EntityConf.get_eeConf().EE_CONF_PTR.get_minpwdlen());
	((wxTextCtrl *)Frames->FindWindow(IDC_MIN_PWD_LEN))->SetValue(tt);

	if(ASN1_BIT_STRING_get_bit(m_EntityConf.get_eeConf().EE_CONF_PTR.get_flags(), EE_ALLOW_CREATE_PROFILE))
		((wxCheckBox *)Frames->FindWindow(IDC_CREATE_PROFILE))->SetValue(true);
	else
		((wxCheckBox *)Frames->FindWindow(IDC_CREATE_PROFILE))->SetValue(false);

	for(i=0; i<m_EntityConf.get_eeConf().EE_CONF_PTR.get_cas().size(); i++)
	{
		((wxComboBox *)FindWindow(IDC_LIST_CA))->Append(m_EntityConf.get_eeConf().EE_CONF_PTR.get_cas()[i].c_str());
	}
	((wxComboBox *)FindWindow(IDC_LIST_CA))->SetSelection(0);



	if(ASN1_BIT_STRING_get_bit(m_EntityConf.get_eeConf().EE_CONF_PTR.get_flags(), EE_LDAP_AUTHENTICATE))
		((wxCheckBox *)Frames->FindWindow(IDC_ALLOW_LDAP_BIND))->SetValue(TRUE);
	else
		((wxCheckBox *)Frames->FindWindow(IDC_ALLOW_LDAP_BIND))->SetValue(FALSE);

	if(m_EntityConf.get_eeConf().EE_CONF_PTR.get_ldapUtf8())
		((wxCheckBox *)Frames->FindWindow(IDC_UTF8))->SetValue(TRUE);
	else
		((wxCheckBox *)Frames->FindWindow(IDC_UTF8))->SetValue(FALSE);
	
	if(m_EntityConf.get_eeConf().EE_CONF_PTR.get_ldapPort())
		Port.sprintf("%ld", m_EntityConf.get_eeConf().EE_CONF_PTR.get_ldapPort());
	else
		Port = "389";

	((wxTextCtrl *)Frames->FindWindow(IDC_SERVER))->SetValue(m_EntityConf.get_eeConf().EE_CONF_PTR.get_ldapServer().c_str());
	((wxTextCtrl *)Frames->FindWindow(IDC_PORT))->SetValue(Port);
	((wxTextCtrl *)Frames->FindWindow(IDC_USERNAME))->SetValue(m_EntityConf.get_eeConf().EE_CONF_PTR.get_ldapUsername().c_str());
	((wxTextCtrl *)Frames->FindWindow(IDC_PASSWORD))->SetValue(m_EntityConf.get_eeConf().EE_CONF_PTR.get_ldapPassword().c_str());
	((wxTextCtrl *)Frames->FindWindow(IDC_BASE))->SetValue(m_EntityConf.get_eeConf().EE_CONF_PTR.get_ldapBase().c_str());
	((wxTextCtrl *)Frames->FindWindow(IDC_FILTERS))->SetValue(m_EntityConf.get_eeConf().EE_CONF_PTR.get_ldapFilters().c_str());
	((wxTextCtrl *)Frames->FindWindow(IDC_ATTR_NAME))->SetValue(m_EntityConf.get_eeConf().EE_CONF_PTR.get_ldapAttrName().c_str());
	
	wxCommandEvent event;
	OnAllowCreateProfile(event);
	OnLdapBind(event);

	return true;
}


bool DlgConfigureEE::SetConf()
{
	wxString Value;
	long lng;

	m_EntityConf.get_eeConf().EE_CONF_PTR.set_siteName(
			((wxTextCtrl *)Frames->FindWindow(IDC_SITE_NAME))->GetValue().c_str());

	m_EntityConf.get_eeConf().EE_CONF_PTR.set_dnValDisclaimer(dnValDisclaimer);

	if(((wxCheckBox *)Frames->FindWindow(IDC_ALLOW_LDAP_BIND))->GetValue())
	{
		Value = ((wxTextCtrl *)Frames->FindWindow(IDC_SERVER))->GetValue();
		if(!Value.Len())
		{
			HandleError(_("\"Server\" must have a value"), this);
			return false;
		}
		m_EntityConf.get_eeConf().EE_CONF_PTR.set_ldapServer(Value.GetData());

		Value = ((wxTextCtrl *)Frames->FindWindow(IDC_PORT))->GetValue();
		if(!Value.Len())
		{
			HandleError(_("\"Port\" must have a value"), this);
			return false;
		}
		Value.ToLong(&lng);
		m_EntityConf.get_eeConf().EE_CONF_PTR.set_ldapPort(lng);

		Value = ((wxTextCtrl *)Frames->FindWindow(IDC_USERNAME))->GetValue();
		m_EntityConf.get_eeConf().EE_CONF_PTR.set_ldapUsername(Value.GetData());
		
		Value = ((wxTextCtrl *)Frames->FindWindow(IDC_PASSWORD))->GetValue();
		m_EntityConf.get_eeConf().EE_CONF_PTR.set_ldapPassword(Value.GetData());

		Value = ((wxTextCtrl *)Frames->FindWindow(IDC_BASE))->GetValue();
		m_EntityConf.get_eeConf().EE_CONF_PTR.set_ldapBase(Value.GetData());

		Value = ((wxTextCtrl *)Frames->FindWindow(IDC_ATTR_NAME))->GetValue();
		m_EntityConf.get_eeConf().EE_CONF_PTR.set_ldapAttrName(Value.GetData());

		ASN1_BIT_STRING_set_bit(m_EntityConf.get_eeConf().EE_CONF_PTR.get_flags(), EE_LDAP_AUTHENTICATE, 1);

		Value = ((wxTextCtrl *)Frames->FindWindow(IDC_FILTERS))->GetValue();
		m_EntityConf.get_eeConf().EE_CONF_PTR.set_ldapFilters(Value.GetData());

		if(((wxCheckBox *)Frames->FindWindow(IDC_UTF8))->GetValue())
			m_EntityConf.get_eeConf().EE_CONF_PTR.set_ldapUtf8(1);
		else
			m_EntityConf.get_eeConf().EE_CONF_PTR.set_ldapUtf8(0);
	}
	else
	{
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_eeConf().EE_CONF_PTR.get_flags(), EE_LDAP_AUTHENTICATE, 0);
	}

	return true;
}

void DlgConfigureEE::OnSetDisclaimer(wxCommandEvent& event)
{
	selectedDisclaimer = (mString *)((wxComboBox *)Frames->FindWindow(IDC_DISCLAIMER_NAME))->GetClientData(
									((wxComboBox *)Frames->FindWindow(IDC_DISCLAIMER_NAME))->GetSelection());

	((wxTextCtrl *)Frames->FindWindow(IDC_DISCLAIMER_VALUE))->SetValue(selectedDisclaimer->c_str());
}

void DlgConfigureEE::OnAllowCreateProfile(wxCommandEvent& event)
{
	if(((wxCheckBox *)Frames->FindWindow(IDC_CREATE_PROFILE))->GetValue())
	{
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_eeConf().EE_CONF_PTR.get_flags(), EE_ALLOW_CREATE_PROFILE, 1);

		if(ASN1_BIT_STRING_get_bit(m_EntityConf.get_eeConf().EE_CONF_PTR.get_flags(), EE_ALLOW_SERVER_SIDE_KEY_GEN))
			((wxCheckBox *)Frames->FindWindow(IDC_REQUEST_P12))->SetValue(true);
		else
			((wxCheckBox *)Frames->FindWindow(IDC_REQUEST_P12))->SetValue(false);

		if(ASN1_BIT_STRING_get_bit(m_EntityConf.get_eeConf().EE_CONF_PTR.get_flags(), EE_ALLOW_PKCS10_IMPORT))
			((wxCheckBox *)Frames->FindWindow(IDC_REQUEST_P10))->SetValue(true);
		else
			((wxCheckBox *)Frames->FindWindow(IDC_REQUEST_P10))->SetValue(false);

		if(ASN1_BIT_STRING_get_bit(m_EntityConf.get_eeConf().EE_CONF_PTR.get_flags(), EE_ALLOW_SC_KEY_GEN))
			((wxCheckBox *)Frames->FindWindow(IDC_GENERATE_P10))->SetValue(true);
		else
			((wxCheckBox *)Frames->FindWindow(IDC_GENERATE_P10))->SetValue(false);
	}
	else
	{
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_eeConf().EE_CONF_PTR.get_flags(), EE_ALLOW_CREATE_PROFILE, 0);
		
		((wxCheckBox *)Frames->FindWindow(IDC_REQUEST_P12))->SetValue(false);
		((wxCheckBox *)Frames->FindWindow(IDC_REQUEST_P10))->SetValue(false);
		((wxCheckBox *)Frames->FindWindow(IDC_GENERATE_P10))->SetValue(false);
	}
}

void DlgConfigureEE::OnDisclaimerChanged(wxCommandEvent& event)
{
	(*selectedDisclaimer) = ((wxTextCtrl *)Frames->FindWindow(IDC_DISCLAIMER_VALUE))->GetValue().c_str();
}

void DlgConfigureEE::OnLdapBind(wxCommandEvent &event)
{
	bool value = ((wxCheckBox *)Frames->FindWindow(IDC_ALLOW_LDAP_BIND))->GetValue();

	((wxStaticText *)Frames->FindWindow(IDC_LBL_SERVER))->Enable(value);
	((wxStaticText *)Frames->FindWindow(IDC_LBL_PORT))->Enable(value);
	((wxStaticText *)Frames->FindWindow(IDC_LBL_USERNAME))->Enable(value);
	((wxStaticText *)Frames->FindWindow(IDC_LBL_PASSWORD))->Enable(value);
	((wxStaticText *)Frames->FindWindow(IDC_LBL_BASE))->Enable(value);
	((wxStaticText *)Frames->FindWindow(IDC_LBL_ATTR_NAME))->Enable(value);
	((wxStaticText *)Frames->FindWindow(IDC_LBL_FILTERS))->Enable(value);

	((wxTextCtrl *)Frames->FindWindow(IDC_SERVER))->Enable(value);
	((wxTextCtrl *)Frames->FindWindow(IDC_PORT))->Enable(value);
	((wxTextCtrl *)Frames->FindWindow(IDC_USERNAME))->Enable(value);
	((wxTextCtrl *)Frames->FindWindow(IDC_PASSWORD))->Enable(value);
	((wxTextCtrl *)Frames->FindWindow(IDC_BASE))->Enable(value);
	((wxTextCtrl *)Frames->FindWindow(IDC_ATTR_NAME))->Enable(value);
	((wxTextCtrl *)Frames->FindWindow(IDC_FILTERS))->Enable(value);
	((wxCheckBox *)Frames->FindWindow(IDC_UTF8))->Enable(value);
}

