/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgConfigurePlugin.cpp: implementation of the DlgConfigurePlugin class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgConfigurePlugin.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgConfigurePlugin, wxDialog)
    EVT_BUTTON(IDC_OK, DlgConfigurePlugin::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgConfigurePlugin::OnCancel)
    EVT_BUTTON(IDC_BROWSE_XML, DlgConfigurePlugin::OnBrowseXML)
    EVT_BUTTON(IDC_ADD_VALUE, DlgConfigurePlugin::OnAddValue)
    EVT_BUTTON(IDC_MODIFY_VALUE, DlgConfigurePlugin::OnModifyValue)
    EVT_BUTTON(IDC_DELETE_VALUE, DlgConfigurePlugin::OnDelValue)
END_EVENT_TABLE()

DlgConfigurePlugin::DlgConfigurePlugin(wxWindow * wParent, HashTable_String * Options, const mString & LibPath):wxDialog(wParent, (wxWindowID)-1, _("Manage plug-in"), wxDefaultPosition)
{
	ctxt = NULL;
	m_Options = Options;
	// On sauvegarde la liste en cas d'annulation
	SavedListe.AllowDuplicateNames();
	SavedListe = *Options;

	m_IsOk = false;

	DlgConfigurePlugin_SetWindow(this);

	m_listCtrl = ((wxListCtrl *)FindWindow(IDC_LIST_FIELDS));

	wxIcon ico;
	m_imageListSmall = new wxImageList(16, 16, TRUE);	
	ico.CopyFromBitmap(DlgConfigurePlugin_GetBitmap(0));
	m_imageListSmall->Add(ico);

	m_listCtrl->SetImageList(m_imageListSmall, wxIMAGE_LIST_SMALL);

	m_listCtrl->InsertColumn(0, _("Name"), wxLIST_FORMAT_LEFT, 130);
	m_listCtrl->InsertColumn(1, _("Value"), wxLIST_FORMAT_LEFT, 80);
	m_listCtrl->InsertColumn(2, _("Type"), wxLIST_FORMAT_LEFT, 50);
	m_listCtrl->InsertColumn(3, _("Help"), wxLIST_FORMAT_LEFT, 130);

	if(LibPath.size())
		((wxTextCtrl*)FindWindow(IDC_PATH))->SetValue(LibPath.c_str());
	ReloadList();


	CenterOnScreen();
	ShowModal();
}

DlgConfigurePlugin::~DlgConfigurePlugin()
{
	if(m_imageListSmall) delete m_imageListSmall;
	if(ctxt) xmlFreeParserCtxt(ctxt);
}


void DlgConfigurePlugin::ReloadList()
{
	const char * Value;
	const char * Name;
	xmlNodePtr root;
	xmlNodePtr currOption;
	xmlAttrPtr currAttr;
	xmlChar * OptionName;
	xmlChar * AttrValue;
	mString Helper;
	mString Type;

	if(ctxt)
		root = xmlDocGetRootElement(ctxt->myDoc);
	else
		root = NULL;


	m_listCtrl->DeleteAllItems();

	for(int i=0; i<m_Options->EntriesCount(); i++)
	{
		Name = m_Options->GetName(i);
		Value = m_Options->Get(i);
		if(!Name || !Value) continue;

		// Do we need to search the XML ?
		if(root)
		{
			for(currOption = root->children; currOption; currOption=currOption->next)
			{
				if(xmlIsBlankNode(currOption)) continue;
				OptionName = xmlNodeGetContent(currOption);
				if(!OptionName) continue;

				if(*OptionName)
				{
					//Is it the option i'm looking for ?
					if(xmlStrcasecmp(OptionName, (unsigned char*)Name) != 0) continue;


					for(currAttr = currOption->properties; currAttr; currAttr = currAttr->next)
					{				
						//Convert datas to SQL format
						AttrValue = xmlGetProp(currOption, currAttr->name);
						if(xmlStrcasecmp(currAttr->name, (unsigned char*)"help") == 0)
							Helper = AttrValue;
						else if(xmlStrcasecmp(currAttr->name, (unsigned char*)"type") == 0)
							Type = AttrValue;
						xmlFree(AttrValue);
					}
					xmlFree(OptionName);
				}
				break;
			}
			//We didn't find a corresponding entry, move to the next one !
			if(!currOption)
			{
				m_Options->Delete(i);
				i--;
				continue;
			}
		}

		m_listCtrl->InsertItem(i, Name, 0);
		m_listCtrl->SetItemData(i, i);
		m_listCtrl->SetItem(i, 1, Value);
		m_listCtrl->SetItem(i, 2, Type.c_str());
		m_listCtrl->SetItem(i, 3, Helper.c_str());
	}
}




void DlgConfigurePlugin::OnAddValue(wxCommandEvent& event)
{
	wxString Ext;
	mString mName;
	mString mValue;

	if(!ctxt) return;

	DlgAddValuePlugin Dlg(this, "", "", ctxt);

	if(!Dlg.IsOK()) return;

	mName = Dlg.GetName();
	mValue = Dlg.GetValue();

	m_Options->Add(mName.c_str(), mValue.c_str());

	ReloadList();
}

void DlgConfigurePlugin::OnModifyValue(wxCommandEvent& event)
{
	wxString Value;
	wxString Name;;

	mString mName;
	mString mValue;

	long SelectedItem;
	wxListItem ItemInfo;

	if(!ctxt) return;



	SelectedItem = m_listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	SelectedItem = m_listCtrl->GetItemData(SelectedItem);

	mName = m_Options->GetName(SelectedItem);
	mValue = m_Options->Get(SelectedItem);
	if(!mName.size() || !mValue.size()) return;


	DlgAddValuePlugin Dlg(this, mName, mValue, ctxt);

	if(!Dlg.IsOK()) return;

	mName = Dlg.GetName();
	mValue = Dlg.GetValue();


	m_Options->Delete(SelectedItem);
	m_Options->Add(mName.c_str(), mValue.c_str());
	
	ReloadList();
}

void DlgConfigurePlugin::OnDelValue(wxCommandEvent& event)
{
	long SelectedItem;


	SelectedItem = m_listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	SelectedItem = m_listCtrl->GetItemData(SelectedItem);
	
	m_Options->Delete(SelectedItem);
	ReloadList();
}

bool DlgConfigurePlugin::IsOK()
{
	return m_IsOk;
}


void DlgConfigurePlugin::OnOk(wxCommandEvent& event)
{
	m_LibPath = ((wxTextCtrl*)FindWindow(IDC_PATH))->GetValue().GetData();
	if(!m_LibPath.size())
		return;

	m_IsOk = true;
	Close(TRUE);
}


void DlgConfigurePlugin::OnBrowseXML(wxCommandEvent& event)
{
	wxFileDialog dialog(this, "Open XML options template", "", "", "XML (*.xml)|*.xml", wxOPEN);
	if (dialog.ShowModal() != wxID_OK)
	{
		return;
	}
	if(ctxt)
	{
		xmlFreeParserCtxt(ctxt);
		ctxt = NULL;
	}

	ctxt = xmlCreateFileParserCtxt(dialog.GetPath());
    xmlParseDocument(ctxt);
    if (!ctxt->wellFormed || !ctxt->valid)
	{
		HandleError(_("Invalid XML template"), this);
		return;
	}
	((wxTextCtrl*)FindWindow(IDC_XML_OPTION))->SetValue(dialog.GetPath());
	ReloadList();
}

void DlgConfigurePlugin::OnCancel(wxCommandEvent& event)
{
	*m_Options = SavedListe;
	m_IsOk = false;
	Close(TRUE);
}

const mString & DlgConfigurePlugin::GetLibPath()
{
	return m_LibPath;
}
