/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgGUI.cpp: implementation of the DlgGUI class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgCertProperties.h"
#include "DlgDisplayLogs.h"
#include "DlgSplash.h"
#include "DlgMessage.h"

#include "DlgGUI.h"
#include "dlgs_wdr.h"
#include "clintl.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


DlgGUI::DlgGUI(wxWindow * wParent, PkiClient * ClientPki, const char * EntityName, const char * UserName, const char * Password):wxFrame(wParent, -1, "", wxPoint(-1,-1), wxSize(10,10), wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION | wxMAXIMIZE_BOX | wxRESIZE_BORDER)
{
	wxIconBundle Icons;
	wxIcon ico;

	m_DlgMsg = new DlgMessage(this);
	if(!m_DlgMsg)
	{
		Close(TRUE);
		return;
	}

	SetBackgroundColour(wxSystemSettings::GetSystemColour(wxSYS_COLOUR_3DFACE));
	m_ClientPki = ClientPki;
	m_EntityName = EntityName;
	m_UserName = UserName;
	m_Password = Password;
	m_ClientPki->GetEntityCert(m_EntityCert);

	ico.CopyFromBitmap(DlgGUI_GetBitmap(IDB_NEWPKI_BIG));
	Icons.AddIcon(ico);
	ico.CopyFromBitmap(DlgGUI_GetBitmap(IDB_NEWPKI_SMALL));
	Icons.AddIcon(ico);

	SetIcons(Icons);
}

DlgGUI::~DlgGUI()
{
	if(m_ClientPki) delete m_ClientPki;
	if(m_DlgMsg) delete m_DlgMsg;
}


void DlgGUI::OnReconnect(wxCommandEvent &event)
{
	DlgMessage DlgMsg(this);
	DlgMsg.wShow(_("Initializing SSL Layer..."));
	int UserType;
	AdminReqLogin login;

	if(!m_ClientPki->Reconnect())
	{
		DlgMsg.wHide();
		HandleError(m_ClientPki->GetError(), this);
		return;
	}

	login.set_entity(m_EntityName);
	login.set_username(m_UserName);
	login.set_password(m_Password);

	if(!m_ClientPki->UserLogin(login, UserType))
	{
		DlgMsg.wHide();
		HandleError(m_ClientPki->GetError(), this);
		return;
	}
	DlgMsg.wHide();
	m_ClientPki->GetEntityCert(m_EntityCert);
	ReloadConf();
}

void DlgGUI::ShowSSL_Certificate(wxCommandEvent& event)
{
	PKI_CERT cert;
	m_ClientPki->GetPeerCertificate(cert);
	DlgCertProperties Dlg(this, cert);
}

void DlgGUI::ShowEntity_Certificate(wxCommandEvent& event)
{
	DlgCertProperties Dlg(this, m_EntityCert);
}

void DlgGUI::OnShowLogs(wxCommandEvent& event)
{
	DlgDisplayLogs Dlg(this, m_ClientPki, m_EntityCert);
}

void DlgGUI::OnAbout(wxCommandEvent &event)
{
	DlgSplash Dlg(this);
}

void DlgGUI::OnQuit(wxCommandEvent &event)
{
	Close(TRUE);
}

const char * DlgGUI::GetProfileStatusString(unsigned long status)
{
	switch(status)
	{
		case NEWPKI_PROFILE_STATE_WAITING_FOR_ADMIN_VALIDATION:
			return _("Waiting for admin validation");
			break;
		case NEWPKI_PROFILE_STATE_VALIDATED:
			return _("Ready for certification");
			break;
		case NEWPKI_PROFILE_STATE_WAITING_FOR_VALIDATION:
			return _("Waiting for End-User validation");
			break;
		default:
			return _("Unknown");
			break;
	}
}

const char * DlgGUI::GetCertificateTypeString(unsigned long type)
{
	switch(type)
	{
		case NEWPKI_PROFILE_CERT_TYPE_PKCS10:
			return _("Simple Certificate");
			break;

		case NEWPKI_PROFILE_CERT_TYPE_PKCS12:
			return _("PKCS#12");
			break;

		case NEWPKI_PROFILE_CERT_TYPE_SC:
			return _("Smart Card");
			break;

		default:
			return _("Unknown type");
			break;
	}
}

const char * DlgGUI::GetCertificateStatusString(unsigned long status)
{
	switch(status)
	{
		case NEWPKI_PROFILE_CERT_STATE_REVOKED:
			return _("Revoked");
			break;

		case NEWPKI_PROFILE_CERT_STATE_SUSPENDED:
			return _("Suspended");
			break;

		case NEWPKI_PROFILE_CERT_STATE_ACTIVE:
			return _("Active");
			break;

		case NEWPKI_PROFILE_CERT_STATE_WAITING:
			return _("Waiting for certification");
			break;

		case NEWPKI_PROFILE_CERT_STATE_ERROR:
			return _("Error during certification");
			break;

		case NEWPKI_PROFILE_CERT_STATE_WAITING_REV:
			return _("Waiting for revocation");
			break;

		case NEWPKI_PROFILE_CERT_STATE_WAITING_SUSP:
			return _("Waiting for suspension");
			break;

		case NEWPKI_PROFILE_CERT_STATE_WAITING_UNSUSP:
			return _("Waiting for unsuspension");
			break;
		
		default:
			return _("Unknown status");
			break;
	}
}

void DlgGUI::SavePKCS12(const PKI_PKCS12 & p12)
{
	const char * cn;
	FILE * fd;
	int pos;

	if(p12.GetEndUserCert() && 
		(pos = p12.GetEndUserCert().GetCertDN().SeekEntryName("commonName", HASHTABLE_NOT_FOUND)) != HASHTABLE_NOT_FOUND
		)
	{
		cn = p12.GetEndUserCert().GetCertDN().Get(pos);
	}
	else
	{
		cn = NULL;
	}
	if(!cn)
		cn="";

	
	wxFileDialog dialog(this, _("Save PKCS#12"), "", cn, _("PKCS#12 File (*.p12)|*.p12"), wxSAVE|wxOVERWRITE_PROMPT);

	if (dialog.ShowModal() != wxID_OK)
	{
		return;
	}

	fd = fopen(dialog.GetPath() , "wb");	
	if(!fd)
	{
		HandleErrorResult(NULL, this, 0);
		return;
	}
	if (i2d_PKCS12_fp(fd, p12.GetPKCS12()) <= 0)
	{
		HandleError(NULL , this);
	}
	fclose(fd);
}

