/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgImportSignReq.cpp: implementation of the DlgImportSignReq class.
//
//////////////////////////////////////////////////////////////////////

#ifdef _WIN32
#pragma warning(disable:4786)
#endif
#include "DlgImportSignReq.h"
#include "DlgMessage.h"
#include "dlgs_wdr.h"
#include "clintl.h"
#include <fstream>
using namespace std;



//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


BEGIN_EVENT_TABLE(DlgImportSignReq, wxDialog)
    EVT_BUTTON(IDC_OK, DlgImportSignReq::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgImportSignReq::OnCancel)
    EVT_BUTTON(IDC_OPEN, DlgImportSignReq::OnOpen)
END_EVENT_TABLE()

DlgImportSignReq::DlgImportSignReq(wxWindow * wParent, PkiClient * ClientPki):wxDialog(wParent, (wxWindowID)-1, _("Import entity signing request"), wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION)
{
	m_ClientPki = ClientPki;
	m_IsOk = false;


	DlgImportSignReq_SetWindow(this);

	((wxTextCtrl *)FindWindow(IDC_DISPLAY))->SetBackgroundColour(GetBackgroundColour());

	CenterOnScreen();
	ShowModal();
}

DlgImportSignReq::~DlgImportSignReq()
{
}

void DlgImportSignReq::OnOk(wxCommandEvent &event)
{
	DlgMessage Dlg(this);

	EntitySignatureResp resp;
	wxString FileName;
	mString pemdatas;

	if(!req) return;
	if(DisplayMessage(this, _("Are you sure, you want to sign this request ?"), wxYES_NO) == wxNO) return;

	Dlg.wShow(_("Importing Entity Signing Request..."));
	if(!m_ClientPki->SignEntity(req, resp))
	{
		Dlg.wHide();
		HandleError(m_ClientPki->GetError(), this);
		return;
	}
	Dlg.wHide();

	FileName.sprintf("%s.esp", req.get_name().c_str());

	wxFileDialog dialog(this, "Save Entity signing response", "", FileName, "Entity signing response File (*.esp)|*.esp", wxSAVE | wxOVERWRITE_PROMPT);
	if (dialog.ShowModal() != wxID_OK)
	{
		return;
	}

	if(!resp.to_PEM(pemdatas))
	{
		HandleErrorResult(NULL, this, 0);
		return;
	}
	fstream wd;
	wd.open(dialog.GetPath(), fstream::binary | fstream::out);
	if(!wd)
	{
		HandleErrorResult(NULL, this, errno);
		return;
	}
	wd << pemdatas.c_string();
	wd.close();

	m_IsOk = true;
	Close(TRUE);
}

void DlgImportSignReq::OnCancel(wxCommandEvent &event)
{
	m_IsOk = false;
	Close(TRUE);
}

void DlgImportSignReq::OnOpen(wxCommandEvent &event)
{
	ERR_clear_error();
	wxFileDialog dialog(this, "Open Entity signing request", "", "", "Entity signing request File (*.esr)|*.esr", wxOPEN);
	if (dialog.ShowModal() != wxID_OK)
	{
		return;
	}
	((wxTextCtrl *)FindWindow(IDC_DISPLAY))->SetValue("");

	ifstream rd(dialog.GetPath());
	if(!rd)
	{
		HandleErrorResult(NULL, this, 0);
		return;
	}
	struct stat  info;
	char * buffer;
	stat(dialog.GetPath(), &info);

	if(!(buffer = (char*)malloc(info.st_size+1)))
	{
		HandleErrorResult(NULL, this, errno);
		return;
	}
	rd.read(buffer, info.st_size);
	buffer[info.st_size] = 0;


	if(!req.from_PEM(buffer))
	{
		HandleErrorResult(NULL, this, 0);
		free(buffer);
		return;
	}
	free(buffer);

	mString txt;
	mString tmpLng;
	EVP_PKEY * pubKey;
	
	txt += _("Name: ");
	txt += req.get_name();
	txt += "\n";

	txt += _("Email: ");
	txt += req.get_email();
	txt += "\n";

	txt += _("Type: ");
	switch(req.get_body().get_type())
	{
		case ENTITY_TYPE_RA:
			txt += _("RA");
			txt += "\n";

			pubKey = X509_PUBKEY_get((X509_PUBKEY*)req.get_body().get_entitypubkey());
			if(pubKey)
			{
				txt += _("Entity key length: ");
				tmpLng.sprintf("%d bits", RSA_size(pubKey->pkey.rsa)*8);
				EVP_PKEY_free(pubKey);
				txt += tmpLng;
				txt += "\n";
			}
			break;
		case ENTITY_TYPE_CA:
			txt += _("CA");
			txt += "\n";

			pubKey = X509_PUBKEY_get((X509_PUBKEY*)req.get_body().get_entitypubkey());
			if(pubKey)
			{
				txt += _("Entity key length: ");
				tmpLng.sprintf("%d bits", RSA_size(pubKey->pkey.rsa)*8);
				EVP_PKEY_free(pubKey);
				txt += tmpLng;
				txt += "\n";
			}
			break;
		case ENTITY_TYPE_REPOSITORY:
			txt += _("Repository");
			txt += "\n";

			pubKey = X509_PUBKEY_get((X509_PUBKEY*)req.get_body().get_signRep().get_entitypubkey());
			if(pubKey)
			{
				txt += _("Entity key length: ");
				tmpLng.sprintf("%d bits", RSA_size(pubKey->pkey.rsa)*8);
				EVP_PKEY_free(pubKey);
				txt += tmpLng;
				txt += "\n";
			}
			txt += _("Repository address: ");
			txt += req.get_body().get_signRep().get_address();
			txt += "\n";
			txt += _("Repository port: ");
			tmpLng.sprintf("%ld", req.get_body().get_signRep().get_port());
			txt += tmpLng;
			txt += "\n";
			break;
		case ENTITY_TYPE_PUBLICATION:
			txt += _("Publication");
			txt += "\n";

			pubKey = X509_PUBKEY_get((X509_PUBKEY*)req.get_body().get_signPub().get_entitypubkey());
			if(pubKey)
			{
				txt += _("Entity key length: ");
				tmpLng.sprintf("%d bits", RSA_size(pubKey->pkey.rsa)*8);
				EVP_PKEY_free(pubKey);
				txt += tmpLng;
				txt += "\n";
			}
			pubKey = X509_PUBKEY_get((X509_PUBKEY*)req.get_body().get_signPub().get_ocsppubkey());
			if(pubKey)
			{
				txt += _("OCSP key length: ");
				tmpLng.sprintf("%d bits", RSA_size(pubKey->pkey.rsa)*8);
				EVP_PKEY_free(pubKey);
				txt += tmpLng;
				txt += "\n";
			}

			break;
		case ENTITY_TYPE_KEY_STORE:
			txt += _("Key Store");
			txt += "\n";

			pubKey = X509_PUBKEY_get((X509_PUBKEY*)req.get_body().get_entitypubkey());
			if(pubKey)
			{
				txt += _("Entity key length: ");
				tmpLng.sprintf("%d bits", RSA_size(pubKey->pkey.rsa)*8);
				EVP_PKEY_free(pubKey);
				txt += tmpLng;
				txt += "\n";
			}
			break;
		case ENTITY_TYPE_EE:
			txt += _("EE");
			txt += "\n";

			pubKey = X509_PUBKEY_get((X509_PUBKEY*)req.get_body().get_entitypubkey());
			if(pubKey)
			{
				txt += _("Entity key length: ");
				tmpLng.sprintf("%d bits", RSA_size(pubKey->pkey.rsa)*8);
				EVP_PKEY_free(pubKey);
				txt += tmpLng;
				txt += "\n";
			}
			break;
		default:
			txt += _("Unknown");
			txt += "\n";
			break;
	}
	
	((wxTextCtrl *)FindWindow(IDC_DISPLAY))->SetValue(txt.c_str());
}

bool DlgImportSignReq::IsOK()
{
	return m_IsOk;
}
