/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgAddValueDN.h: interface for the DlgAddValueDN class.
//
//////////////////////////////////////////////////////////////////////

#ifndef DLGSETLOGFILTERS_H
#define DLGSETLOGFILTERS_H

#include <stdio.h>
#include <ASN1/Asn1Logs.h>

#include <HashTable/HashTable_String.h>


#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif
#include <wx/calctrl.h>
#include <wx/dialog.h>


class DlgSetLogFilters: public wxDialog
{
public:
	DlgSetLogFilters(wxWindow * wParent, const mVector<unsigned long> & Types, const AdminReqEnumLogs & Filters);
	virtual ~DlgSetLogFilters();

	void OnChkType(wxCommandEvent &event);
	void OnChkDate(wxCommandEvent &event);
	void OnChkStatus(wxCommandEvent &event);
	void OnChkOpId(wxCommandEvent &event);
	void OnChkObject(wxCommandEvent &event);

	void OnOk(wxCommandEvent& event);
	void OnCancel(wxCommandEvent& event);
	bool IsOK();
	const AdminReqEnumLogs & GetFilters();

private:
	wxCalendarCtrl * m_DateFromCtrl;
	wxCalendarCtrl * m_DateToCtrl;
	bool m_IsOK;
	AdminReqEnumLogs m_Filters;
	DECLARE_EVENT_TABLE()
};

#endif
