#! /bin/sh
#
# 
# This file has been written Thomas Dupouy <moz@gmx.fr>
# for newpki-server package
# Based on mldonkey initscript

PATH=/sbin:/bin:/usr/sbin:/usr/bin
WRAPPER=/usr/sbin/newpki-server
NAME=newpki-server
DESC="NewPKI"
CONFIG=/etc/default/newpki-server
PIDFILE=/var/run/$NAME.pid

test -x $WRAPPER || exit 0

test -e $CONFIG || exit 0

set -e

. $CONFIG

#if [ "$LAUNCH_AT_STARTUP" != "true" ]; then
#	exit 0
#fi
if [ -z "$NEWPKI_CONF" ]; then
	NEWPKI_CONF="/etc/newpki/config.conf"
fi
if [ -z "$NEWPKI_USER" ]; then
	NEWPKI_USER="newpki"
fi

# Stop processing if the config file is not there
if [ ! -r "$NEWPKI_CONF" ]; then
  cat <<EOF >&2
No configuration file was found for newpki-server at $NEWPKI_CONF.
If you have moved the newpki-server configuration file please modify
/etc/default/newpki-server to reflect this.  If you chose to not
configure newpki-server during installation then you need to do so
prior to attempting to start newpki-server.
An example config.conf is in /usr/share/doc/newpki-server
EOF
  exit 0 # Should this be 1?
fi


case "$1" in
  start)
	echo -n "Starting $DESC: $NAME"

	start-stop-daemon --start --quiet --exec $WRAPPER \
		-- -config $NEWPKI_CONF -user $NEWPKI_USER -detach -pidfile $PIDFILE
	
	echo "."
	;;
  stop)
	echo -n "Stopping $DESC: $NAME"
	
	start-stop-daemon --stop --quiet --pidfile $PIDFILE >/dev/null 2>&1 || true

	echo "."
	;;
  restart)
	$0 stop
	sleep 3
	$0 start
  
	echo "."
	;;
  force-reload)
  	$0 restart
	echo "."
	;;
	
  *)
	echo "Usage: $0 {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
