# -*- coding: ascii -*-
#
#  communicate.py - ghost-to-ghost communication mechanism
#  Copyright (C) 2002-2005 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#  Copyright (C) 2002, 2003 by MATSUMURA Namihiko <nie@counterghost.net>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
#  $Id: communicate.py,v 1.15 2006/05/28 07:19:50 shy Exp $
#


class Communicate:

    def __init__(self):
        self.__ghosts = {}

    def rebuild_ghostdb(self, ghost, name='', s0=0, s1=10):
        if ghost in self.__ghosts.keys():
            del self.__ghosts[ghost]
        if name is None:
            return
        else:
            self.__ghosts[ghost] = (name, s0, s1)

    def get_otherghostname(self, name):
        otherghostname = []
        for value in self.__ghosts.itervalues():
            if value[0] != name:
                otherghostname.append(chr(1).join(value))
        return otherghostname

    def send_message(self, name, sender, sentence):
        if name == "__SYSTEM_ALL_GHOST__":
            for ghost in self.__ghosts.iterkeys():
                ghost.notify_communicate(sender, sentence)
        elif chr(1) in name:
            to = name.split(chr(1))
            for ghost, value in self.__ghosts.iteritems():
                if value[0] in to:
                    ghost.notify_communicate(sender, sentence)
                    to.remove(value[0])
                    if not to:
                        break
        else:
            for ghost, value in self.__ghosts.iteritems():
                if value[0] == name:
                    ghost.notify_communicate(sender, sentence)
                    break
