/* Written by and copyright Carlo Strozzi <carlos@linux.it>. */

/* hashkey: returns the hash offset for a kay string.

   Copyright (C) 2001 Carlo Strozzi <carlos@linux.it>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


   Usage:  hashkey rows keystring


   This program adds the ASCII value of each character in 'keystring'
   (except blanks) and returns the modulo of 'rows'. This is for computing
   the hash offset into hash index tables.

   Examples :

     $ hashkey 11 ABCD
     2

     $ hashkey 29 abcdefg
     4

 ****************************************************************************/

/*
static char Psz_RCS [] =
    "$Id: hashkey.c,v 1.1.1.1 2003/03/17 09:49:20 carlo Exp $";
*/

/****************************************************************************/

#include <stdio.h>
#include <stdlib.h>

int main(int argc, char **argv) {

   int i = 0, j = 0, key_hash = 0, rows = 0;

   if (argc < 3) {
         fprintf(stderr, "usage: hashkey rows keystring\n");
         exit(1);
   }

   rows = atoi(argv[1]);

   if (rows < 1) {
	 fprintf(stderr, "hashkey: invalid argument '%s'\n", argv[1]);
	 exit(1);
   }

   for (i = 2; i < argc; i++) {
      j = 0;
      while (argv[i][j]) {
	    if (argv[i][j] == ' ' && argv[i][j] == '\t') {
	       j++;
	       continue;	/* Skip blanks and tabs */
	    }
	    key_hash += argv[i][j];
	    j++;
      }
   }

   printf("%i\n", key_hash % rows);

   exit(0);
}

/* End of program */
