#include <stdio.h>
#include <stdlib.h>
#include "util.h"

#define	max(a,b)	((a)>(b)?(a):(b))

Strlist *
strlistn(int len)
{
	Strlist *sl = emalloc(sizeof(Strlist));
	sl->list = emalloc(len * sizeof(void*));
	sl->p = sl->list;
	sl->e = sl->p+len;
	return sl;
}

Strlist*
strlist(void)
{
	return strlistn(128);
}

void
slfree(Strlist *sl)
{
	free(sl->list);
	free(sl);
}

static void
slgrow(Strlist *sl, int grow)
{
	int len = sllen(sl);
	int new = max(len+grow, len*1.5);
	sl->list = erealloc(sl->list, new*sizeof(char*));
	sl->p = sl->list+len;
	sl->e = sl->list+new;
}

void
slappend(Strlist *sl, char *s)
{
	if (sl->p >= sl->e)
		slgrow(sl, 1);
	*(sl->p)++ = s;
}
