/* $Id: nws_proxy.h,v 1.3 2005/06/10 21:09:58 graziano Exp $ */

#ifndef NWS_PROXY_H
#define NWS_PROXY_H

#include "nws_api.h"

#ifdef __cplusplus
extern "C" {
#endif


/* let's define DataDescriptors for the Measurement, Forecast and
 * ForecastCollection */
static const DataDescriptor measurementDescriptor[] = {
	SIMPLE_MEMBER(DOUBLE_TYPE, 1, offsetof(NWSAPI_Measurement, timeStamp)),
	SIMPLE_MEMBER(DOUBLE_TYPE, 1, offsetof(NWSAPI_Measurement, measurement))};
#define measurementDescriptorLength (2)

static const DataDescriptor forecastDescriptor[] = {
	SIMPLE_MEMBER(DOUBLE_TYPE, 1, offsetof(NWSAPI_Forecast, forecast)),
	SIMPLE_MEMBER(DOUBLE_TYPE, 1, offsetof(NWSAPI_Forecast, error)),
	SIMPLE_MEMBER(DOUBLE_TYPE, 1, offsetof(NWSAPI_Forecast, MAE_error)),
	SIMPLE_MEMBER(UNSIGNED_INT_TYPE, 1, offsetof(NWSAPI_Forecast, methodUsed))};
#define forecastDescriptorLength (4)

static const DataDescriptor forecastCollectionDescriptor[] = {
	{STRUCT_TYPE, 1, offsetof(NWSAPI_ForecastCollection, measurement),
		(DataDescriptor *)&measurementDescriptor, 
		measurementDescriptorLength, 
		PAD_BYTES(NWSAPI_Measurement, measurement, double, 1)},
	{STRUCT_TYPE, 2, offsetof(NWSAPI_ForecastCollection, forecasts),
		(DataDescriptor *)&forecastDescriptor,
		forecastDescriptorLength,
		PAD_BYTES(NWSAPI_Forecast, methodUsed, unsigned int, 1)}};
#define forecastCollectionDescriptorLength (2)

#ifdef __cplusplus
}
#endif

#endif /* NWS_PROX_H */
