#include "config_nws.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/time.h> 
#include <string.h>
#include <errno.h>
#ifdef HAVE_UTMPX_H
#	include <utmpx.h>
#endif

#include "availtest.h"
#include "diagnostic.h"
#include "osutil.h"


/* get aliases for getutxent and getutent */
#ifdef HAVE_GETUTXENT
#	define _MY_SETUTENT	setutxent()
#	define _MY_GETUTENT	getutxent()
#	define _MY_GETUTID(ut)	getutxid(ut)
#	define _MY_ENDUTENT	endutxent()
#	define _MY_UTMP		utmpx
#elif defined(HAVE_GETUTENT)
#	define _MY_SETUTENT	setutent()
#	define _MY_GETUTENT	getutent()
#	define _MY_GETUTID(ut)	getutid(ut)
#	define _MY_ENDUTENT	endutent()
#	define _MY_UTMP		utmp
#endif 

static double 
get_uptime() {
	int fd;
	char *buf;
	double uptime, tmp;
#ifdef _MY_UTMP
	struct _MY_UTMP localut, *myutx;
#endif

	uptime = -1;

	/* if we have /proc/uptime, let's use it, since it's faster */
	buf = (char *)malloc(sizeof(char[4096]));
	memset(buf, 0, sizeof(char[4096]));

	if (buf == NULL) {
		ERROR("get_uptime: out of memory\n");
		return 0;
	}
  
	fd = open("/proc/uptime", O_RDONLY);
	if (fd >=  0) {
		/* we have /proc/uptime: great, let's use it */
		if (read(fd, buf, 4096) >= 0) {
			sscanf(buf, "%lf %lf", &uptime, &tmp);
		}
		close(fd);
	}
	free(buf);

#ifdef _MY_SETUTENT
	/* we try it only if reading /proc didn't work */
	if (uptime == -1) {
		_MY_SETUTENT;
		localut.ut_type = BOOT_TIME;
		myutx = _MY_GETUTID(&localut);
		/* search till we find the last time we rebooted the machine */
		while(myutx != NULL) {
			uptime = CurrentTime() - (double)(myutx->ut_tv.tv_sec);
			/* we have to more forward because getutid cache the
			 * result */
			myutx->ut_type++;
			myutx = _MY_GETUTID(&localut);
		}
		_MY_ENDUTENT;
	}
#endif

	if (uptime > 0) {
		/* we can read data so we can monitor */
		return(uptime);
	}

	return (0);
}


static double
get_start() {
	struct timeval tv;
	double now;
	static double start_time = 0;

	gettimeofday(&tv,NULL);
	now = tv.tv_sec + (tv.tv_usec / 1000000.0);

	if(start_time == 0.0) {
		start_time = now;
	}

	return (now - start_time);
}

	
void 
AvailabilityUseSkill(	const char *options,
			int *length,
			SkillResult **results) {
	double d;
	static short first = 1;

	/* we don't need to parse the options since there is no options
	 * for the availability sensor */
	d = get_uptime();
	if (d != 0) {
		AppendResult(upTime, "", 1, d, 0, length, results);
	} else {
		AppendResult(upTime, "", 0, 0, 0, length, results);
		if (first) {
			WARN("AvailabilityUseSkill: cannot get system uptime, reporting only startTime\n");
			first = 0;
		}
	}
	AppendResult(startTime, "", 1, get_start(), 0, length, results);

	return;
}

int
AvailabilityMonitorAvailable(const char *options) {
	/* startTime is alwyas avaiable */
	return 1;
}
