<?php
///////////////////////////////////////////////////////////////////////////////
// OBM - File : of_display.inc                                               //
//     - Desc : OBM Framework Display Objects and functions                  //
// 2005-07-01 Pierre Baudracco                                               //
///////////////////////////////////////////////////////////////////////////////
// $Id: of_display.inc 2781 2008-02-26 17:12:56Z mehdi $
///////////////////////////////////////////////////////////////////////////////

class OBM_DISPLAY {
  var $display_type;      // determines the type of display. possible values
    // - PREFERENCES  : to set the display preference
    // - DATA         : to display all elements, for exemple all contacts
  var $display_name;      // Display Name (to differentiate same displays)
  var $display_module;    // module where to find the entity in use
  var $display_entity;    // entity used (deal, contact, parentdeal,...)
  var $display_pref;      // User preferences : Array[fieldname] order,status
  var $display_link = 1;  // If false, extern links aren't displayed
  var $display_ext = "";  // External action called (allow Special handling)

  //----------- TYPE SECTION : PREFERENCES --------//
  var $pref_title;       // title of the preference panel
  var $pref_dis_help;    // flag to tell if the pref help screen shoulg be dis.

  //----------- TYPE SECTION : DATA -----------//
  var $data_set;              // Data set :DB_OBM: data rows to be displayed
  var $data_header = "top";   // Table header location (top|both) (+bottom)
  var $data_page = true;      // Page management (true | false)
  var $data_url = "";         // Base URL (with search) used for links in Index
  var $data_order = true;     // Order can be changed (click on column title)
  var $data_cb_text = "";     // Checkbox column text
  var $data_cb_side = "left"; // Checkbox position in the row (left|right)
  var $data_cb_name = "";     // Base name of the checkbox element (+id)
  var $data_cb_field = "";    // Field from which cb is filled (1=selected)
  var $data_idfield = "_id";  // Index field for the data row
  var $data_cb_show = 1;      // To set visible
                              //   1 -> visible
                              //   "string" if ->f["string"] == 0 -> visible
  var $data_form_head = "";   // Form header
  var $data_form_end = "";    // Form end
  var $delimiter = '"';       // CVS field delimiter (enclosed by)
  var $sql_order_dir = "ASC"; // SQL Sorting direction

  /////////////////////////////////////////////////////////////////////////////
  // OBM_DISPLAY Constructor
  // Parameters:
  //   - $type   : display type
  //   - $pref   : display pref : DBO
  //   - $module : calling module
  //   - $entity : entity to display
  //   - $name   : dataset name
  /////////////////////////////////////////////////////////////////////////////
  function OBM_DISPLAY($type, $pref, $module, $entity="", $name="") {
    global $params;

    if ( ($type != "PREFERENCES") && 
	($type != "DATA") ) {
      die("ERROR: the type MUST be PREFERENCES or DATA");
    } else {
      $this->display_type = $type;
    }
    if (isset($pref)) {
      $this->display_pref = $pref;
    }
    if (isset($module)) {
      $this->display_module = $module;
    }
    if (isset($entity) && ($entity != "")) {
      $this->display_entity = $entity;
    } else {
      $this->display_entity = $this->display_module;
    }
    if (isset($name)) {
      $this->display_name = $name;
    }
    $this->sql_order_dir = ($params["sql_order_dir"] == "DESC" ? "DESC" : "ASC");
  }
  
  /////////////////////////////////////////////////////////////////////////////
  // OBM_DISPLAY main display function
  /////////////////////////////////////////////////////////////////////////////
  function display($dis_data_entity="") {
    if ($this->display_type == "PREFERENCES") {
      $this->check_preferences_vars();
      return $this->dis_preferences();
    } else if ($this->display_type == "DATA") {
      $this->check_data_vars();
      return $this->dis_data($dis_data_entity);
    }
  }

  /////////////////////////////////////////////////////////////////////////////
  // Function that check if DATA variables are set, if not die               //
  /////////////////////////////////////////////////////////////////////////////
  function check_data_vars() {
    if (!is_array($this->display_pref)) {
      die("THE display_pref VARIABLE MUST BE SET");
    }
  }

  /////////////////////////////////////////////////////////////////////////////
  // Function that check if PREFERENCES variables are set, if not die        //
  /////////////////////////////////////////////////////////////////////////////
  function check_preferences_vars() {
    if (! is_array($this->display_pref)) {
      die("THE display_pref VARIABLE MUST BE SET");
    }
    if (!isset($this->display_entity)) {
      die("THE display_entity VARIABLE MUST BE SET");
    }
    if (!isset($this->pref_title)) {
      die("THE pref_title VARIABLE MUST BE SET");
    }
  }


  /////////////////////////////////////////////////////////////////////////////
  // Function that display the preferences screen for the dataset            //
  /////////////////////////////////////////////////////////////////////////////
  function dis_preferences() {
    global $l_default, $l_displayed, $l_order, $l_field, $l_move, $l_mandatory;
    global $l_display_no, $l_display_yes, $l_down, $l_up;
    // Images
    global $ico_arrow_mount, $ico_arrow_umount, $ico_nok;
    global $fieldnames, $cgp_hide, $ico_ok, $ico_lock;
    
    $nb_field = count($this->display_pref) - 1;

    // actions names
    $action_display = "dispref_display";
    $action_level = "dispref_level";

    $entity = $this->display_entity;

    if ($this->display_module != "") {
      $url = $this->display_module . "_index.php";
    } else {
      $url = $this->display_entity . "_index.php";
    }

    $block = "
    <div class=\"displayPref\">
    <h1>".$this->pref_title."</h1>
    <table >
    <thead>
    <tr>
      <td>$l_default</td>
      <td>$l_displayed</td>
      <td>$l_order</td>
      <td>$l_field</td>
      <td>$l_move</td>
    </tr>
    </thead>";

    $i = 0;
    $nb_field_hidden = 0;
    while ( list($fieldname, $fieldinfo) = each($this->display_pref) ) {
      $fieldstatus = $fieldinfo["status"];
      $fieldorder = $fieldinfo["order"];
      $fielddefault = (! $fieldinfo["notdefault"]);

      if ($fielddefault) {
        $dis_default = "=";
      } else {
        $dis_default = "&nbsp;";
      }

      // Check if field (or field family has to be displayed)
      // If type is hidden, hide all type_* fields
      $pos_base = strpos($fieldname, "_");
      if ($pos_base > 0) {
	$fieldname_base = (substr($fieldname, 0, $pos_base));
      } else {
	$fieldname_base = $fieldname;
      }

      if ($cgp_hide[$entity][$fieldname]
	  || $cgp_hide[$entity][$fieldname_base]) {
	$td_class = "resultPrefHide";
      } 
      if($i%2 == 0) {
        $class = "class=\"pair\"";
      } else {
        $class = "";
      }
      $block .= "
    <tr $class>
    <td class=\"$td_class\">$dis_default</td>
    <td class=\"$td_class\">";

      if ($fieldstatus == 0) {
	$new_status = 1;
	$nb_field_hidden++;
	$block .= "
      <a class=\"$td_class\" href=\"".url_prepare("$url?action=$action_display&amp;entity=$entity&amp;fieldname=$fieldname&amp;fieldstatus=$new_status")."\">
      <img alt=\"$l_display_yes\" src=\"$ico_nok\" /></a>";
      } else if ($fieldstatus == 1) {
	$new_status = 0;
	$block .= "
      <a class=\"$td_class\" href=\"".url_prepare("$url?action=$action_display&amp;entity=$entity&amp;fieldname=$fieldname&amp;fieldstatus=$new_status")."\">
      <img alt=\"$l_display_no\" src=\"$ico_ok\" /></a>";
      } else if ($fieldstatus == 2) {
	$block .= "
      <img alt=\"$l_mandatory\" src=\"$ico_lock\" />";
      }

      $block .= "
      </td>
      <td class=\"$td_class\">";

      if ($fieldstatus == 0) {
	$block .= "&nbsp;";
      } else {
	$pos = $fieldorder - $nb_field_hidden;
	$block .= "$pos";
      }
      $block .= "</td>
    <td class=\"$td_class\">".$fieldnames[$fieldname]."</td>
    <td class=\"$td_class\">";
      // If last field we doesn't display the down arrow
      if ($i != $nb_field) {
        $sql_order_field = $fieldorder + 1;
	$block .= "
        <a href=\"$url?action=$action_level&amp;entity=$entity&amp;fieldname=$fieldname&amp;fieldorder=$sql_order_field\">
        <img alt=\"$l_down\" src=\"$ico_arrow_umount\" /></a>";
      }
      
      // If first field we don't display the up arrow
      if ($i != 0) {
        $sql_order_field = $fieldorder - 1;
	$block .= "
          <a href=\"$url?action=$action_level&amp;entity=$entity&amp;fieldname=$fieldname&amp;fieldorder=$sql_order_field\">
          <img alt=\"$l_up\" src=\"$ico_arrow_mount\" /></a>";
      }
      $block .= "
    </td>
  </tr>";
      $i++;
    } // While end

    $block .= "
    </table>";

    // If help is set, we display the help panel
    if ($this->pref_dis_help == 1) {
      $block .= $this->dis_pref_help();
    }
    $block .= "</div>";

    return $block;
  }


  /////////////////////////////////////////////////////////////////////////////
  // Function that display the preference help screen
  /////////////////////////////////////////////////////////////////////////////
  function dis_pref_help() {
    global $l_help, $l_help_display_yes, $l_help_display_no, $l_help_mandatory;
    global $l_help_down, $l_help_up;
    // Images
    global $ico_arrow_mount, $ico_arrow_umount, $ico_ok;
    global $ico_nok, $ico_lock;

    $block = "
    <h1>$l_help</h1>
    <p>
    <img src=\"$ico_ok\" alt=\"$l_help_display_yes\" /> $l_help_display_yes<br />
    <img src=\"$ico_nok\" alt=\"$l_help_display_no\" /> $l_help_display_no<br />
    <img src=\"$ico_lock\" alt=\"$l_help_mandatory\" /> $l_help_mandatory<br />
    <img src=\"$ico_arrow_mount\" alt=\"$l_help_down\" /> $l_help_down<br />
    <img src=\"$ico_arrow_umount\" alt=\"$l_help_down\" /> $l_help_up<br />
    </p>
    ";

    return $block;
  }


  /////////////////////////////////////////////////////////////////////////////
  // Display: Returns the dataset display
  // Parameters:
  //   - $dis_data_entity : function to call
  /////////////////////////////////////////////////////////////////////////////
  function dis_data($dis_data_entity) {
    global $path, $cgp_hide, $cdg_id;

    $link_ok = $this->display_link;
    $entity = $this->display_entity;
    $block .= "<div class=\"result\">";

    $module = $this->display_module;

    // We display page management only if enabled and a search url is given
    if (($this->data_page) && ($this->data_url != "")) {
      $block_page = $this->dis_data_index($this->data_url, $dis_data_entity);
      $block .= $block_page;
    }

    $block .= $this->data_form_head;
    $block .= "<table>";
    $block_header = $this->dis_data_header($this->data_url);
    $block .= $block_header;
    $block .= "<tbody>";
    reset($this->display_pref);
    $cpt = 0;

    // Iteration on each data row of dataset
    while ( ($this->data_set->next_record() )
            && ( ($cpt < $_SESSION['set_rows']) || ( ! $this->data_page) ) ) {

      if (function_exists($dis_data_entity)) {
	$res = $dis_data_entity($this, "row_style", $link_ok);
	$rowstyle = $res["style"];
      }
      if (!$rowstyle && $cpt%2 == 0) {
        $rowstyle = "class='pair'";
      } 
      
      $cpt++;
      $block .= "<tr $rowstyle>";

      // If debug level Id is set, display the entity id
      if (($_SESSION['set_debug'] > 0) && (($_SESSION['set_debug'] & $cdg_id) == $cdg_id)) {
	$dg_id = $this->data_set->f("id");
	$block .= "<td>$dg_id</td>";
      }

      // If a left checkbox has to be displayed
      if (($this->data_cb_side == "left") && ($this->data_cb_text != "")) {
	$col_show = $this->data_cb_show;
        // If cb are to be displayed or column telling visibility is true
        if (($col_show == "1") || ($this->data_set->f($col_show))) {
	  $name = $this->data_cb_name;
	  $name .= $this->data_set->f($this->data_idfield);
	  if ($this->data_set->f($this->data_cb_field)) {
	    $cb_check = "checked";
	  } else {
	    $cb_check = "";
	  }
	  if (function_exists($dis_data_entity)) {
	    $data_element = $dis_data_entity($this, "data_element", $link_ok);
	    $data_element = $data_element["name"];
	  }	  
	  $block .= "<td $style>
                <input type=\"checkbox\" id=\"$name\" name=\"$name\" $cb_check />$data_element </td>";
	}
	else
	  $block .= "<td $style>&nbsp;</td>";
      }


      // For each field in the data row we walk through the pref dbo ordered
      // and for each entry (field) we set special parameters and display it
      while ( list($fieldname, $fieldinfo) = each ($this->display_pref) ) {

	// Check if field (or field family has to be displayed)
	// If type is hidden, hide all type_* fields
	$pos_base = strpos($fieldname, "_");
	if ($pos_base > 0) {
	  $fieldname_base = (substr($fieldname, 0, $pos_base));
	} else {
	  $fieldname_base = $fieldname;
	}

	if (! ($cgp_hide[$entity][$fieldname]
	       || $cgp_hide[$entity][$fieldname_base])) {

	  // Default values
	  $name = $this->data_set->f($fieldname);
	  $url = "";
	  $popup = false;
	  $popup_width = 600;
	  $popup_height = 400;
	  $align = "left";

	  //--------------------------------------------------
	  // Global field display disposition
	  //--------------------------------------------------
	  // Format dates
	  if (substr($fieldname,0,4) == "date") {
	    $name = of_date_format($this->data_set->f($fieldname), 1);
	  }
	  elseif ($fieldname == "timeupdate") {
	    $name = of_datetime_format($this->data_set->f($fieldname), 1);
	  }
	  else if ($fieldname == "timecreate") {
	    $name = of_datetime_format($this->data_set->f($fieldname), 1);
	  }
	  
	  //--------------------------------------------------
	  // We call module specific field display disposition
	  //--------------------------------------------------
	  if (function_exists($dis_data_entity)) {
	    $res = $dis_data_entity($this, $fieldname, $link_ok);
	    if ($res["name"] != "") $name = $res["name"];
	    $url = $res["url"];
	    $align = $res["align"];
	    $style = $res["style"];
	    $window = $res["window"];
	    $popup = $res["popup"];
	    $popup_width = $res["popup_width"];
	    $popup_height = $res["popup_height"];
	  }

	  //--------------------------------------------------
	  // Column display
	  //--------------------------------------------------
	  $content = "";
	  
	  // Set the style
	  if ($style != "") {
	    $td = "<td $style>";
	  } else if ($align == "center") {
	    $td = "<td class=\"C\">";
	  } else {
	    $td = "<td>";
	  }
	  
	  // Pre cell display (open popup, link)
	  if ($popup) {
	    $content = "<a href=\"#\" onclick=\"window.name='root';popup('$url',''); return false;\">";
	  } else if ($window) {
	    $content = "<a href=\"#\" onclick=\"window.name='root';popup('$url',''); return false;\">";
	  } else if ($url != "") {
	    $content = "<a href=\"".url_prepare("$url")."\">";
	  }
	
	  // Cell display
	  $content .= $name;
	  
	  // Post cell display (close link, popup)
	  if ($popup || ($url != "")) {
	    $content .= "</a>";
	  }
	  
	  // Cell writing
	  $block .= "$td $content </td>\n";
	}
      }

      // If a right checkbox has to be displayed
      if (($this->data_cb_side == "right") && ($this->data_cb_text != "")) {
	$col_show = $this->data_cb_show;
        // If cb are to be displayed or column telling visibility is true
        if (($col_show == "1") || ($this->data_set->f($col_show))) {
	  $name = $this->data_cb_name;
	  $name .= $this->data_set->f($this->data_idfield);
	  if ($this->data_set->f($this->data_cb_field)) {
	    $cb_check = "checked";
	  } else {
	    $cb_check = "";
	  }
	  $block .= "<td>
            <input type=\"checkbox\" id=\"$name\" name=\"$name\" $cb_check /></td>";
	}
	else
	  $block .= "<td>&nbsp;</td>";
      }

      reset($this->display_pref);
      $block .= "</tr>";
    }

    //--------------------------------------------------------
    // Data Set end : if header set to both, display an header
    //--------------------------------------------------------
    $block .= "</tbody>";
    if ($this->data_header == "both") {
      $block .= $block_header;
    }
    $block .= "</table>
      " . $this->data_form_end . "
      ";
    if ($this->data_header == "both") {
      $block .= $block_page;
    }
    $block .= "</div>";
    return $block;
  }


  /////////////////////////////////////////////////////////////////////////////
  // Display : Returns the dataset index display (page management)
  // Parameters:
  //   - $url             : URL with search fields to link to index pages
  //   - $dis_data_entity : function to call (module formatting fields)
  /////////////////////////////////////////////////////////////////////////////
    function dis_data_index($url, $dis_data_entity) {
    global $path, $params, $ctu_sql_limit;
    global $cak_prev, $cak_next, $cak_page_prev, $cak_page_next, $cak_begin, $cak_end;
    global $set_rows_default,$module, $l_select_all, $l_unselect_all;
    global $l_entries, $l_page_res, $l_export, $l_export_all;
    global $ico_export, $ico_export_all, $ico_begin, $ico_end, $ico_previous, $ico_next;

    $nb_page_dis = 10;
    $this_entity = $this->display_entity;
    $this_name = $this->display_name;
    $sql_order_dir = $this->sql_order_dir;
    $query = $this->data_set->obm_query;
    $have_cb = ($this->data_cb_text != "");
    // If displayed without links (in popup) add this in url
    if (! $this->display_link) {
      $url .= "&amp;popup=1";
    }
    // Page display management
    // If page not set or page not for this display (this entity)
    if ((!isset($params["page"])) || ($params["page"] == "") || ($params["of_display_name"] != $this_name)) {
      $lpage = 1;
    } else {
      $lpage = $params["page"];
    }

    if ($_SESSION['set_rows'] < 1) $_SESSION['set_rows'] = $set_rows_default;
    $nb_rows = $this->data_set->num_rows_total();
    // If we delete all contacts of the last page, we must go to $page-1 (list)
    if ($lpage > 1) {
      if ($nb_rows < (($lpage-1)*$_SESSION['set_rows'])+1) {
         $lpage-- ;
      }
    }

    $nb_page = floor(($nb_rows-1) / $_SESSION['set_rows']) + 1;
    $first_row = ($lpage - 1) * $_SESSION['set_rows'];
    $start_page =  (floor(($lpage - 1) / $nb_page_dis) * $nb_page_dis) + 1;
    $end_page = $start_page + $nb_page_dis - 1;
    $end_page = min ($end_page, $nb_page); 

    if ($nb_rows < $_SESSION['set_rows']) {
      $export_rows = $nb_rows;
    } else {
      $export_rows = $_SESSION['set_rows'];
    }
    if($have_cb) {
      $cb_script = "
        function selectAllCb(container) {
          var container = $(container);
          var chks = container.getElements('input[type=checkbox]');
          chks.each(function (chk) {
            chk.checked = true;
          })
        }
        function unSelectAllCb(container) {
          container = $(container);
          var chks = container.getElements('input[type=checkbox]');
          chks.each(function (chk) {
            chk.checked = false;
          })          
        }
      ";
      $cb_links = "
        <span>
        <a href=\"\" onclick=\"selectAllCb(this.parentNode.parentNode.parentNode);return false;\">$l_select_all</a>
        <a href=\"\" onclick=\"unSelectAllCb();return false;\">$l_unselect_all</a>
        </span>
      ";
    }
    $export_url = "$path/exportcsv/exportcsv_index.php";
    $content = "<div>
      $cb_links
      <script type=\"text/javascript\">
        function exportResultSet(firstRow,nbRows) {
          form = new Element('form');
          form.setProperties({action:'$export_url', method:'POST'});
          form.adopt(new Element('input').setProperties({type:'hidden', name:'action', value:'export_page'}));
          form.adopt(new Element('input').setProperties({type:'hidden', name:'call_module', value:'$module'}));
          form.adopt(new Element('input').setProperties({type:'hidden', name:'of_display_name', value:'$this_name'}));
          form.adopt(new Element('input').setProperties({type:'hidden', name:'entity', value:'$this_entity'}));
          form.adopt(new Element('input').setProperties({type:'hidden', name:'first_row', value:firstRow}));
          form.adopt(new Element('input').setProperties({type:'hidden', name:'nb_rows', value:nbRows}));
          form.adopt(new Element('input').setProperties({type:'hidden', name:'query', value:'".phpStringToJsString($query)."'}));
          form.adopt(new Element('input').setProperties({type:'hidden', name:'func_data', value:'$dis_data_entity'}));
          form.injectInside($(document.body));
          form.submit();
          return false;
        }
        $cb_script
      </script>
    <a href=\"#\" onclick=\"return exportResultSet('$first_row','$export_rows');\" >$l_export</a>      
    <a href=\"#\" onclick=\"return exportResultSet('0','$nb_rows');\" >$l_export_all</a>   
            
      $l_entries $nb_rows | $l_page_res : ($nb_page) &nbsp;&nbsp;&nbsp;&nbsp;";

    // Rewind to 1st page
    if ($lpage > 1) {
      $content .= "<a accesskey=\"$cak_begin\" href=\"$url&amp;page=1&amp;sql_order_field=$params[sql_order_field]&amp;sql_order_dir=$sql_order_dir&amp;of_display_name=$this_name&amp;entity=$this_entity\">|&lt;&lt;</a>&nbsp;&nbsp;";
    }

    // Rewind nb_page_dis page
    if ($start_page > 1) {
      $i = $start_page - $nb_page_dis;
      $content .= "<a accesskey=\"$cak_page_prev\" href=\"$url&amp;page=$i&amp;sql_order_field=$params[sql_order_field]&amp;sql_order_dir=$sql_order_dir&amp;of_display_name=$this_name&amp;entity=$this_entity\">-$nb_page_dis</a>&nbsp;&nbsp;";
    }

    // Previous page
    if ($lpage > 1) {
      $tmppage = $lpage - 1;
      $content .= "<a accesskey=\"$cak_prev\" href=\"$url&amp;page=$tmppage&amp;sql_order_field=$params[sql_order_field]&amp;sql_order_dir=$sql_order_dir&amp;of_display_name=$this_name&amp;entity=$this_entity\">&lt;</a>&nbsp;&nbsp;";
    }

    $i = $start_page;
    // Pages display
    while ($i <= $end_page) {
      if ($i != $lpage) {
	$content .= "<a href=\"$url&amp;page=$i&amp;sql_order_field=$params[sql_order_field]&amp;sql_order_dir=$sql_order_dir&amp;of_display_name=$this_name&amp;entity=$this_entity\">$i</a> | \n";
      } else {
	$content .= "$i | \n";
      }
      $i++;
    }

    // Next page
    if ($lpage < $nb_page) {
      $tmppage = $lpage + 1;
      $content .= "&nbsp;&nbsp;<a accesskey=\"$cak_next\" href=\"$url&amp;page=$tmppage&amp;sql_order_field=$params[sql_order_field]&amp;sql_order_dir=$sql_order_dir&amp;of_display_name=$this_name&amp;entity=$this_entity\">&gt;</a>";
    }

    // Go to next $nb_page_dis pages
    if ($end_page < $nb_page) {
      $i = $end_page + 1;
      $content .= "&nbsp;&nbsp;<a accesskey=\"$cak_page_next\" href=\"$url&amp;page=$i&amp;sql_order_field=$params[sql_order_field]&amp;sql_order_dir=$sql_order_dir&amp;of_display_name=$this_name&amp;entity=$this_entity\">+$nb_page_dis</a>";
    }

    // Go to last page
    if ($lpage < $nb_page) {
      $content .= "&nbsp;&nbsp;
      <a accesskey=\"$cak_end\" href=\"$url&amp;page=$nb_page&amp;sql_order_field=$params[sql_order_field]&amp;sql_order_dir=$sql_order_dir&amp;of_display_name=$this_name&amp;entity=$this_entity\">&gt;&gt;|</a>";
    }

    // Export - Uses forms to allow big queries to be transmitted
    $module = $this->display_module;

    $content .= "
    </div>
";

    // If limit is not used, we seek to the first row to display
    if (! $ctu_sql_limit) {
      $this->data_set->seek($first_row);
    }

    return $content;
  }


  /////////////////////////////////////////////////////////////////////////////
  // Display : Returns the dataset header display (Columns names)
  // Parameters:
  //   - $url : URL with search fields to link to index pages
  /////////////////////////////////////////////////////////////////////////////
  function dis_data_header($url) {
    global $params;
    global $fieldnames, $cgp_hide, $cdg_id, $l_id;
    global $ico_arrow_up, $ico_arrow_down, $ico_arrow_off;

    // If displayed without links (in popup) add this in url
    if (! $this->display_link) {
      $url .= "&amp;popup=1";
    }

    $entity = $this->display_entity;
    $this_name = $this->display_name;
    $sql_order_dir = $this->sql_order_dir;
    $new_sql_order_dir = ($sql_order_dir == "ASC" ? "DESC" : "ASC"); 
    $block = "
      <thead>
    <tr>";
    
    // If debug level Id is set, display the entity id
    if (($_SESSION['set_debug'] > 0) && (($_SESSION['set_debug'] & $cdg_id) == $cdg_id)) {
      $block .= "<td>$l_id</td>";
    }

    // Display the checkbox title if needed (exists and left side)
    if (($this->data_cb_side == "left")
          && ($this->data_cb_text != "")) {
      $block .= "<td>".$this->data_cb_text."</td>";
    }

    reset($this->display_pref);
    while ( list($fieldname, $fieldinfo) = each ($this->display_pref) ) {

      // Check if field (or field family has to be displayed)
      // If moduletype is hidden, hide all moduletype_* fields
      $pos_base = strpos($fieldname, "_");
      if ($pos_base > 0) {
	$fieldname_base = (substr($fieldname, 0, $pos_base));
      } else {
	$fieldname_base = $fieldname;
      }

      if (! ($cgp_hide[$entity][$fieldname]
	     || $cgp_hide[$entity][$fieldname_base])) {
	$label = $fieldnames[$fieldname];
  
        $img = "";
        $onclick = ""; 
	if ($this->data_order) {
	  $furl = $url;
          if ($url != "") {
            if ($params["sql_order_field"] == $fieldname) {
              if ($sql_order_dir == "DESC") {
                $img = "<img src='$ico_arrow_up' alt='sort' />";
              } else {
                $img = "<img src='$ico_arrow_down' alt='sort' />";
              }
            }
	    // If action on this dataset
	    if ($this_name == $params["of_display_name"]) {
	      $furl .= "&amp;page=$params[page]&amp;sql_order_field=$fieldname&amp;sql_order_dir=$new_sql_order_dir&amp;of_display_name=$this_name&amp;entity=$entity";
	    } else {
	      $furl .= "&amp;page=1&amp;sql_order_field=$fieldname&amp;sql_order_dir=$new_sql_order_dir&amp;of_display_name=$this_name&amp;entity=$entity";
	    }
          }
          $onclick = "onclick=\"window.location.href='$furl'\" onmouseover=\"this.className='hover'\" onmouseout=\"this.className=''\" ";
	}
	$block .= "<td $onclick>$label $img</td>";
      }
    }

    // Display the checkbox title if needed (exists and right side)
    if (($this->data_cb_side == "right")
         && ($this->data_cb_text != "")) {
      $block .= "<td>".$this->data_cb_text."</td>";
    }
    $block .= "</tr></thead>";

    return $block;
  }


  /////////////////////////////////////////////////////////////////////////////
  // Function that display the dataset headers (col names)
  // for result in a file (as .csv)
  /////////////////////////////////////////////////////////////////////////////
  function dis_data_header_file($sep) {
    global $cgp_hide, $fieldnames, $cdg_id;

    $entity = $this->display_entity;

    reset($this->display_pref);
    while ( list($fieldname, $fieldinfo) = each ($this->display_pref) ) {

      // Check if field (or field family has to be displayed)
      // If type is hidden, hide all type_* fields
      $pos_base = strpos($fieldname, "_");
      if ($pos_base > 0) {
	$fieldname_base = (substr($fieldname, 0, $pos_base));
      } else {
	$fieldname_base = $fieldname;
      }

      if (! ($cgp_hide[$entity][$fieldname]
	  || $cgp_hide[$entity][$fieldname_base])) {
	$label = $fieldnames[$fieldname];
	// if label empty or is an image or a link, we display the column name
	if ( ($label == "") || (preg_match("/.*<.*>.*/", $label) ) ) {
	  $label = $fieldname;
	}
	echo "$label$sep";
      }
    }
    echo "\n";
  }


  /////////////////////////////////////////////////////////////////////////////
  // Function that display the dataset
  //   for result in a file (as .csv)
  /////////////////////////////////////////////////////////////////////////////
  function dis_data_file($first_row, $nb_rows, $sep, $dis_data_entity) {
    global $cgp_hide, $cdg_id, $ctu_sql_limit;

    $entity = $this->display_entity;
    $this->dis_data_header_file($sep);

    // If limit is not used, we seek to the first row to display
    if (! $ctu_sql_limit) {
      $this->data_set->seek($first_row);
    }

    // Iteration on each data row of dataset
    $cpt = 0;
    while (($this->data_set->next_record()) && ($cpt < $nb_rows)) {

      // For each field in the data row we walk through the pref array
      // and for each entry (field) we set special parameters and display it
      reset($this->display_pref);
      while ( list($fieldname, $fieldinfo) = each ($this->display_pref) ) {

	// Check if field (or field family has to be displayed)
	// If type is hidden, hide all type_* fields
	$pos_base = strpos($fieldname, "_");
	if ($pos_base > 0) {
	  $fieldname_base = (substr($fieldname, 0, $pos_base));
	} else {
	  $fieldname_base = $fieldname;
	}

	if (! ($cgp_hide[$entity][$fieldname]
	       || $cgp_hide[$entity][$fieldname_base])) {
	  $txt_name = $this->data_set->f($fieldname);

	  //--------------------------------------------------
	  // Global field display disposition
	  //--------------------------------------------------
	  // Format dates
	  if (substr($fieldname,0,4) == "date") {
	    $txt_name = of_date_format($this->data_set->f($fieldname));
	  }
	  elseif ($fieldname == "timeupdate") {
	    $txt_name = of_datetime_format($this->data_set->f($fieldname));
	  }
	  else if ($fieldname == "timecreate") {
	    $txt_name = of_datetime_format($this->data_set->f($fieldname));
	  }
	  
	  //--------------------------------------------------
	  // We call module specific field display disposition
	  //--------------------------------------------------
	  if (function_exists($dis_data_entity)) {
	    $res = $dis_data_entity($this, $fieldname, $link_ok);
	  }	  

	  if ($res["txt_name"] != "") {
	    $name = $res["txt_name"];
	  } else if ($res["name"] != "") {
	    $name = $res["name"];
	  } else {
	    $name = $txt_name;
	  }
	  $delimiter = $this->delimiter;
	  // If double quote in field, we double these and set field delimiter
	  if ( (($delimiter == '"') || ($delimiter == ''))
               && (strstr($name, '"'))) {
	    $name = str_replace('"', '""', $name);
	    $delimiter = '"';
	  } else if (($sep != '') && (strstr($name, $sep))) {
	    if ($delimiter == "") {
	      $delimiter = '"';
	    }
	  }
	  echo "${delimiter}${name}${delimiter}$sep";

	}
      }

      echo "\n";
      $cpt++;
    }
    echo "\n\n";
  }

}


// Themes generic display functions -----------------------------------------//


///////////////////////////////////////////////////////////////////////////////
// Display: XHTML Head
// Parameters:
//   - $module  : selected module
///////////////////////////////////////////////////////////////////////////////
function display_head($p_module) { 
  global $l_obm_title, $extra_css, $extra_js, $extra_file_js,$css_obm;

  // If a theme specif function is provided
  if (function_exists("display_head_theme")) {
    return display_head_theme($p_module);
  }
  if (is_array($extra_css)) {
    foreach($extra_css as $css_file) {
      $dis_extra_css = "<link rel=\"stylesheet\" type=\"text/css\" href=\"$css_file\" />";
    }
  } elseif (isset($extra_css)) {
    $dis_extra_css = "<link rel=\"stylesheet\" type=\"text/css\" href=\"$extra_css\" />";
  }

  $headers_e = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"
\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">
<html xmlns=\"http://www.w3.org/1999/xhtml\"> ";

  //  if ($extra_file_js) {
  //    $file_js = "<script language=\"JavaScript\" type=\"text/javascript\" src=\"$extra_file_js\" />";
  //  }

  return "$headers_e
<head>
  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-15\" />
  <title>$l_obm_title - $p_module</title>
  <link rel=\"stylesheet\" type=\"text/css\" href=\"$css_obm\" />
  $dis_extra_css
  $file_js
<script type=\"text/javascript\">
  $extra_js
</script>
</head>

<body onload=\"if (document.f_search) {
    document.f_search.elements[0].focus();
  } else if (document.f_entity) {
    document.f_entity.elements[0].focus();
  } \">

"
.display_debug()
;
}


///////////////////////////////////////////////////////////////////////////////
// Display : Returns the section display block
// Parameters:
//   - $section : active section
///////////////////////////////////////////////////////////////////////////////
function display_sections($section) {
  global $cgp_show, $sections, $perm;
  
  // If a theme specif function is provided
  if (function_exists("display_sections_theme")) {
    return display_sections_theme($section);
  }

  // Else
  $ret = "<div class='section'>\n";
  foreach ($cgp_show["section"] as $key => $show) {
    if ($show) {
      $value = $sections[$key];
      $section_name = $value["Name"];
      $section_target = $value["Target"];
      $section_right = $perm->get_section_rights($key);
      if ($section_right) {
        if ($key == $section) {
          $ret .= "<p class='actif'>$section_name</p>\n";
        } else {
	  if (isset($section_target)) {
	    $target = "target='$section_target'";
	  }
	  $ret .= "<p class='inactif'><a $target href='".$value["Url"]."'>$section_name</a></p>\n";
        }
      }
    }
  }
  $ret .= "</div>";

  return $ret;
}


///////////////////////////////////////////////////////////////////////////////
// Display : Returns the section menus display block
// Parameters:
//   - $section : selected section
//   - $module  : selected module
///////////////////////////////////////////////////////////////////////////////
function display_modules($section, $module) {
  global $cme_txt, $cme_ico, $cme_both;
  global $path, $perm, $modules, $cgp_show;

  // If a theme specif function is provided
  if (function_exists("display_modules_theme")) {
    return display_modules_theme($section, $module);
  }

  if (($_SESSION['set_menu'] == $cme_ico) || ($_SESSION['set_menu'] == $cme_both))
    $fico = true;
  else $fico = false;

  if (($_SESSION['set_menu'] == $cme_txt) || ($_SESSION['set_menu'] == $cme_both))
    $ftext = true;
  else $ftext = false;

  if ($section != "") {
    $section_link = array_keys($cgp_show["module"],$section);
    if (is_array($section_link)) {
      $block .= "<ul class='module'>\n";

      foreach ($section_link as $mod) {
        $module_name = $modules[$mod]["Name"];
        $module_right = $perm->get_module_rights($mod); 
        if (($module_right & $modules[$mod]["Right"]) == $modules[$mod]["Right"]) {
          if ($mod == $module) {
            $block .= "<li class=\"activeModule\">";
	  } else {
	    $block .= "<li class=\"inactiveModule\">";
	  }
          if ($fico) {
	    $ico = $modules[$mod]["Ico"];
	    if ($ico) {
	      $block .= "<a href='".$modules[$mod]["Url"]."' class='ico'><img src='$ico' alt='$module_name' /></a> ";
	    }
	  }
	  $block .= "<a href='".$modules[$mod]["Url"]."'>";
	  if ($ftext) $block .= $module_name;
          $block .= "</a></li>\n";
        }
      }
      $block .= "</ul>";
    }
  }

  return $block;
}


///////////////////////////////////////////////////////////////////////////////
// Display : Returns the action display block of the selected module
// Parameters:
//   - $section : selected section
//   - $module  : selected module
///////////////////////////////////////////////////////////////////////////////
function display_actions($section, $module) {
  global  $modules, $action;
  global $actions, $perm;

  // If a theme specif function is provided
  if (function_exists("display_actions_theme")) {
    return display_actions_theme($section, $module);
  }

  $name = $modules[$module]["Name"];
  $ico = $modules[$module]["Ico"];
  if ($ico != "")
    $dico = "<img src=\"$ico\" alt=\"\" />&nbsp;";
  else
    $dico = "";

  $ret = "
  <ul class=\"action\">
  ";
  if (is_array($actions[$module])) {
    $module_right = $perm->get_module_rights($module);

    foreach ($actions[$module] as $key => $value) {

      // If the current action has this action in target
      if (!in_array("!$action",$value["Condition"]) 
        && (in_array("all", $value["Condition"])
        || in_array($action, $value["Condition"]))) {

	if (($module_right & $value["Right"]) == $value["Right"]) {

	  $ret .= "<li>";
	  if ($value["Popup"] == 1) {
	    if ($value["Target"]) {
	      $wtarget = "window.name='" . $value['Target'] . "';";
	    }
	    $ret .= "
              <a href=\"#\" class=\"action\" 
              onclick=\"$wtarget popup('".$value['Url']."',''); return false;\">
	      ".$value["Name"]."</a> &nbsp;";
	  } else {
	    $ret .= "
               <a class=\"action\" href=\"".$value["Url"]."\">".$value["Name"]."</a> &nbsp;";
	  }
	  $ret .= "</li>";
	}
      }
    }
  }
   
  $ret .= "
  </ul>
";

  return $ret;
}


///////////////////////////////////////////////////////////////////////////////
// Display : Returns the last visited display block
// Parameters:
//   - $path : path to the obm php root (for the first screen after login)
///////////////////////////////////////////////////////////////////////////////
function display_last_visited() {
  global $path, $cgp_show, $last_v, $l_last_visit, $path;

  // If a theme specif function is provided
  if (function_exists("display_last_visited_theme")) {
    return display_last_visited_theme($path);
  }

  foreach ($cgp_show["module"] as $module => $val) {

    if (($cgp_show["module"][$module]) && ($_SESSION['last_v'][$module]["text"] != "")) {
      $id = $_SESSION['last_v'][$module]["id"];
      $text = substr($_SESSION['last_v'][$module]["text"], 0, 30);
      $l_ico = "ico_$module";
      global ${$l_ico};
      $mod_url = url_prepare("$path/$module/${module}_index.php?action=detailconsult&amp;${module}_id=$id");
      $dis_last .= "
        <li><a href=\"$mod_url\"><img src=\"${$l_ico}\" alt=\"$module\" /> $text</a></li>";
    }
  }

  $block .= "
  <div class=\"portlet\" id=\"lastVisitPortlet\"> 
    <h1>$l_last_visit</h1>
    <ul>
    $dis_last
    </ul>
  </div>";

  return $block;
}


///////////////////////////////////////////////////////////////////////////////
// Display : Returns the Todo display block
// Parameters:
//   - $path : path to the obm php root (for the first screen after login)
///////////////////////////////////////////////////////////////////////////////
function display_todos($path="..") {
  global $cgp_show, $l_module_todo;

  if (! $cgp_show["module"]["todo"]) {
    return "";
  }

  // If a theme specif function is provided
  if (function_exists("display_todos_theme")) {
    return display_todos_theme($path);
  }

  $nb = count($_SESSION['todos']);

  for ($i = 1; $i <= $nb; $i++) {
    $t_id = $_SESSION['todos'][$i]["id"];
    $t_title = $_SESSION['todos'][$i]["title"];
    $todo_url = url_prepare("$path/todo/todo_index.php?action=detailconsult&amp;todo_id=$t_id");
    $todo_title = substr($t_title, 0, 30);
    $block_todo .= "
      <li><a href=\"$todo_url\">$todo_title</a></li>";
  }

  if ($nb >= 1) {
    $block = "<div class=\"portlet\" id=\"todoPortlet\">
      <h1>$l_module_todo</h1>
      <ul>
      $block_todo
     </ul>
      </div>";
  } else {
    $block = "";
  }

  return $block;
}


///////////////////////////////////////////////////////////////////////////////
// Display an entity dates and users creation / update infos
// Parameters:
//   - $obm_q : DBO object : used fields
//          usercreate userupdate timecreate timeupdate datasource_name privacy
///////////////////////////////////////////////////////////////////////////////
function display_record_info($obm_q) {
  global  $l_infos , $l_public, $l_private, $ico_data;
  global  $ico_privacy, $ico_new ,$ico_update;

  if (is_object($obm_q)) {
    $usercreate = $obm_q->f("usercreate");
    $userupdate = $obm_q->f("userupdate");
    $timecreate = of_datetime_format($obm_q->f("timecreate"), 1);
    $timeupdate = of_datetime_format($obm_q->f("timeupdate"), 1);
    $datasource = $obm_q->f("datasource_name");
    $privacy = ($obm_q->f("privacy") == 0 ? $l_public : $l_private);
    $created = "$usercreate : $timecreate";
    $updated = "$userupdate : $timeupdate";

    if ($datasource != "") {
      $dis_dsrc = "<li><img src=\"$ico_data\" alt=\"Datasource\" /> : $datasource</li>";
    } else {
      $dis_dsrc = "";
    }
    
    $block = "<div class=\"portlet\" id=\"recordPortlet\"><h1>$l_infos</h1>
      <ul>
      <li><img src=\"$ico_new\" alt=\"created by\"/> $created</li>
      <li><img src=\"$ico_update\" alt=\"updated by\"/> $updated </li>
      <li><img src=\"$ico_privacy\" alt=\"privacy\" /> : $privacy</li>
      $dis_dsrc
      </ul>
  </div>";
  }

  return $block;
}


///////////////////////////////////////////////////////////////////////////////
// Display : end of an HTML page
///////////////////////////////////////////////////////////////////////////////
function display_end() { 

  return "
    </body>
    </html>
  ";
}


///////////////////////////////////////////////////////////////////////////////
// Display : debug
///////////////////////////////////////////////////////////////////////////////
function display_debug() {
  global $l_dg_sql, $l_dg_param, $l_dg_sess,$global_dis_debug_custom;
  global $global_dis_debug_msg, $global_dis_debug_param, $dis_session;
  global $cdg_param, $cdg_sql, $cdg_exe, $cdg_sess;

  if (debug_level_isset($cdg_sql) || debug_level_isset($cdg_exe)) {
    $dis_debug_sql = "
      <h1>$l_dg_sql</h1>
      $global_dis_debug_msg";
  }
    
  if (debug_level_isset($cdg_param)) {
    $dis_debug_param = "
      <h1>$l_dg_param</h1>
      $global_dis_debug_param";
  }
    
  if (debug_level_isset($cdg_sess)) {
    $dis_session_content = "
      <h1>$l_dg_sess</h1>
      $dis_session";
  }
  if ($_SESSION['set_debug'] > 0) {
    $dis_debug_custom = "
      <h1>=>$l_dg_custom</h1>
      $global_dis_debug_custom";
  }
  
  if ($_SESSION['set_debug'] > 0) {
    return "
      <div class=\"debug\">".
      $dis_session_content.
      $dis_debug_sql.
      $dis_debug_param.
      $dis_debug_custom.
      "</div>";
  } else { 
    return "";
  }
}


///////////////////////////////////////////////////////////////////////////////
// Display : title
///////////////////////////////////////////////////////////////////////////////
function display_title($title) { 

  return "<div class=\"title\">$title</div>";
}


///////////////////////////////////////////////////////////////////////////////
// Display an OK message
// Parameters:
//   - $msg     : message to display
//   - $special : if true (default), html special chars just displayed
///////////////////////////////////////////////////////////////////////////////
function display_ok_msg($msg, $special=true) {

  if ($msg != "") {
    if ($special) {
      $msg = htmlspecialchars($msg);
    }
    $ret = "<p class=\"message ok\">$msg</p>";
  }
  
  return $ret;
}


///////////////////////////////////////////////////////////////////////////////
// Display an Info message
// Parameters:
//   - $msg     : message to display
//   - $special : if true (default), html special chars just displayed
///////////////////////////////////////////////////////////////////////////////
function display_info_msg($msg, $special=true) {

  if ($msg != "") {
    if ($special) {
      $msg = htmlspecialchars($msg);
    }
    $ret = "<p class=\"message info\">$msg</p>";
  }
  
  return $ret;
}


///////////////////////////////////////////////////////////////////////////////
// Display a warning message
// Parameters:
//   - $msg     : message to display
//   - $special : if true (default), html special chars just displayed
///////////////////////////////////////////////////////////////////////////////
function display_warn_msg($msg, $special=true) {
  
  if ($msg != "") {
    if ($special) {
      $msg = htmlspecialchars($msg);
    }
    $ret = "<p class=\"message warning\">$msg</p>";
  }
  
  return $ret;
}


///////////////////////////////////////////////////////////////////////////////
// Display an error message
// Parameters:
//   - $msg     : message to display
//   - $special : if true (default), html special chars just displayed
///////////////////////////////////////////////////////////////////////////////
function display_err_msg($msg, $special=true) {

  if ($msg != "") {
    if ($special) {
      $msg = htmlspecialchars($msg);
    }
    $ret = "<p class=\"message error\">$msg</p>";
  }
  
  return $ret;
}

///////////////////////////////////////////////////////////////////////////////
// Display document form
// Parameters:
//   - $params[] : 
//   - $label    :  
///////////////////////////////////////////////////////////////////////////////
function display_document_form($params, $label="") {
  global $l_document;

  if($label == "") {
    $label = $l_document;
  }

  if (isset($params["file"])) { $file = $params["file"]; }

  $block = "<tr>
    <th class=\"$class[file]\">$label</th>
    <td>
      <input type=\"file\" name=\"fi_file\" size=\"30\" value=\"$file\" /></td>
  </tr>";

  return $block;

}


?>
