/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * *.M3u file-reader/parser
 *
 * revision history: (please note changes here)
 *  -ss051231  Stian Skjelstad <stian@nixia.no>
 *    -first release
 */

#include "config.h"
#include <stdio.h>
#include <fcntl.h>
#include <fnmatch.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include "types.h"
#include "adb.h"
#include "dirdb.h"
#include "gendir.h"
#include "mdb.h"
#include "modlist.h"
#include "pfilesel.h"
#include "playlist.h"
#include "stuff/compat.h"

static int m3uReadDir(struct modlist *ml, const struct dmDrive *drive, const uint32_t path, const char *mask, unsigned long opt)
{
	char *s1, *s2;
#if 0
	char *s3;
#endif
	char newpath[PATH_MAX+1];

	char *readbuffer;

	char *buftail;
	int buftail_n;
	
	int fd;
	struct stat st;

	if (drive!=dmFILE)
		return 1;
	
	dirdbGetFullName(path, newpath, DIRDB_FULLNAME_NOBASE); /* no file: */

	/* Does the file end in .M3U ? */
	s1=newpath+strlen(newpath)-4;
	if (s1<newpath)
		return 1;
	if (strcasecmp(s1, ".M3U"))
		return 1;
	
	/* Try to open the file */
	if ((fd=open(newpath, O_RDONLY))<0)
		return 1;

	(*rindex(newpath, '/'))=0; /* remove ....pls from path-name */

	if (fstat(fd, &st)<0)
	{
		close(fd);
		return 1;
	}
	/* regular file? */
	if (!S_ISREG(st.st_mode))
	{
		close(fd);
		return 1;
	}
	/* file too big? */
	if (st.st_size>(1024*1024))
	{
		fprintf(stderr, "[M3U] File too big\n");
		close(fd);
		return 1;
	}

	readbuffer=malloc(st.st_size);
	if (read(fd, readbuffer, st.st_size)!=st.st_size)
	{
		close(fd);
		return 1;
	}
	close(fd);

	buftail=readbuffer;
	buftail_n=st.st_size;

	while (buftail_n>0)
	{
		/* find new-line */
		s1=memchr(buftail, '\n', buftail_n);
		s2=memchr(buftail, '\r', buftail_n);
		if (!s1)
		{
			if (!s2)
				break;
			s1=s2;
		} else if (s2)
			if (s2<s1)
				s1=s2;
		*s1=0; /* and terminate the line */
#if 0
		s2=buftail;
#endif
		
		if (buftail[0]=='#')
			goto newline;
		if (!buftail[0])
			goto newline;
#if 1
		fsAddPlaylist(ml, newpath, mask, opt, buftail);
#else
		{
			const char *dmDrive=NULL;
			char fullpath[PATH_MAX+1];
			struct stat st;
			struct modlistentry retval;

			if (s2[0]!='/')
			{
				if ((s3=index(s2, '/')))
					if (s3[-1]==':')
					{
						if (!(dmDrive=dmFindDrive(s2)))
						{
							*s3=0;
							fprintf(stderr, "[M3U] Drive/Protocol not supported (%s)\n", s2);
							/* Drive/Protocol not supported */
							goto newline;
						}
						s2+=strlen(dmDrive);
					}
			}
			if (!dmDrive)
				dmDrive=drive;

			gendir(newpath, s2, fullpath);
			if ((s3=rindex(fullpath, '/')))
				s3++;
			else
				s3=fullpath;

			if (strcmp(dmDrive, "file:"))
			{
				fprintf(stderr, "[M3U], API for getting handlers via dmDrive needed. TODO\n");
				goto newline;
			}
			
			memset(&st, 0, sizeof(st));
			memset(&retval, 0, sizeof(retval));

			if (stat(fullpath, &st)<0)
			{
				fprintf(stderr, "[M3U] stat() failed for %s\n", fullpath);
				goto newline;
			}

			retval.drive=dmDrive;
			strncpy(retval.name, s3, NAME_MAX);
			retval.name[NAME_MAX]=0;

			strncpy(retval.fullname, fullpath, PATH_MAX);
			retval.fullname[PATH_MAX]=0;

			fs12name(retval.shortname, s3);	

			if (S_ISREG(st.st_mode))
			{
				if (isarchivepath(retval.fullname))
				{
					retval.flags=MODLIST_FLAG_ARC;
					strncat(retval.fullname, "/", PATH_MAX-strlen(retval.fullname)-1);
				} else {
					char curext[NAME_MAX+1];
					_splitpath(retval.fullname, 0, 0, 0, curext);
				      	if ((fnmatch(mask, retval.name, FNM_CASEFOLD))||(!fsIsModule(curext)))
						goto newline;
					retval.fileref=mdbGetModuleReference(retval.shortname, st.st_size);
					retval.flags=MODLIST_FLAG_FILE;
				}
			} else if (S_ISDIR(st.st_mode))
			{
				if ((opt&RD_PUTDSUBS))
				{
					retval.flags=MODLIST_FLAG_DIR;
					strncat(retval.fullname, "/", PATH_MAX-strlen(retval.fullname)-1);
				} else if ((opt&RD_PUTRSUBS))
				{
					strncat(retval.fullname, "/", PATH_MAX-strlen(retval.fullname)-1);
					fsReadDir(ml,drive, retval.fullname, mask, opt);
					goto newline;
				} else
					goto newline;
			} else
				goto newline;
			retval.Read=dosfile_Read;
			retval.ReadHeader=dosfile_ReadHeader;
			retval.ReadHandle=dosfile_ReadHandle;
			ml->append(ml, &retval); /* this call no longer can fail */
		}
#endif
newline:
		buftail_n-=(s1-buftail)+1;
		buftail=s1+1;
	}

	free(readbuffer);
	return 1;
}

struct mdbreaddirregstruct m3uReadDirReg = {m3uReadDir};
