# rpm spec file for RedHat / Fedora linux

%define name ocp
%define version 0.1.15

Name: %{name}
Version: %{version}
Release: 0
Summary: Linux port of Open Cubic Player
Group: Applications/Multimedia
URL: http://stian.lunafish.org/coding-ocp.php
Buildroot: /var/tmp/ocp-buildroot
Source: http://stian.lunafish.org/ocp/%{name}-%{version}.tar.bz2
License: GPL-2
BuildRequires: ncurses-devel zlib-devel adplug-devel libmad-devel libogg-devel libvorbis-devel libsidplay-devel gcc >= 3.0-0 gcc-c++ >= 3.0-0 flac-devel

%description
Open Cubic Player is a music player ported from DOS. Provides a nice text-based
frontend, with some few optional features in graphical. Plays modules, sids,
wave and mp3

%prep
%setup -q -n %{name}-%{version}

%build
./configure --prefix=%{_prefix} --exec_prefix=%{_exec_prefix} --infodir=%{_infodir}
make

%install
rm -rf %{buildroot}
mkdir -p %{buildroot}
make DESTDIR=%{buildroot} install

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root)
%doc %{_prefix}/share/ocp-%{version}/AUTHORS
%doc %{_prefix}/share/ocp-%{version}/BUGS
%doc %{_prefix}/share/ocp-%{version}/COPYING
%doc %{_prefix}/share/ocp-%{version}/CREDITS
%doc %{_prefix}/share/ocp-%{version}/KEYBOARD_REMAPS
%doc %{_prefix}/share/ocp-%{version}/SUID
%doc %{_prefix}/share/ocp-%{version}/TODO
%{_prefix}/share/ocp-%{version}/data/ocp.pak
%config %{_prefix}/share/ocp-%{version}/etc/ocp.ini
%{_exec_prefix}/lib/ocp-%{version}
%{_prefix}/bin/ocp-%{version}
%{_prefix}/bin/ocp
%{_prefix}/bin/ultrafix.sh
%{_infodir}/ocp.info.gz
%doc %{_prefix}/share/doc/ocp-%{version}/html
%{_prefix}/share/pixmaps/mini/opencubicplayer_mini.xpm
%{_prefix}/share/pixmaps/opencubicplayer.xpm
%{_prefix}/share/applications/opencubicplayer.desktop
/etc/X11/wmconfig/opencubicplayer
