

%  This example shows how to use Delaunay3D with alpha shapes.

vtk_init;

%  The points to be triangulated are generated randomly in the unit
%  cube located at the origin. The points are then associated with a
%  vtkPolyData.
math = vtkMath();
points = vtkPoints();
for i = 0:25
    points.InsertPoint(i, math.Random(0, 1), math.Random(0, 1),math.Random(0, 1));
end

profile = vtkPolyData();
profile.SetPoints(points);

%  Delaunay3D is used to triangulate the points. The Tolerance is the
%  distance that nearly coincident points are merged
%  together. (Delaunay does better if points are well spaced.) The
%  alpha value is the radius of circumcircles, circumspheres. Any mesh
%  entity whose circumcircle is smaller than this value is output.
delny = vtkDelaunay3D();
delny.SetInput(profile);
delny.SetTolerance(0.01);
delny.SetAlpha(0.2);
delny.BoundingTriangulationOff();

%  Shrink the result to help see it better.
shrink = vtkShrinkFilter();
shrink.SetInput(delny.GetOutput());
shrink.SetShrinkFactor(0.9);

map = vtkDataSetMapper();
map.SetInput(shrink.GetOutput());

triangulation = vtkActor();
triangulation.SetMapper(map);
triangulation.GetProperty().SetColor(1, 0, 0);

%  Create graphics stuff
ren = vtkRenderer();
renWin = vtkRenderWindow();
renWin.AddRenderer(ren);
iren = vtkRenderWindowInteractor();
iren.SetRenderWindow(renWin);

%  Add the actors to the renderer, set the background and size
ren.AddActor(triangulation);
ren.SetBackground(1, 1, 1);
renWin.SetSize(250, 250);
% renWin.Render();

cam1 = ren.GetActiveCamera();
cam1.Zoom(1.5);


% renWin.Render();
vtkInitializeInteractor(iren);
