#ifndef __UNIT__H__
#define __UNIT__H__

// структура, описывающая скорострел
typedef struct
{
  int id;             // идентификатор против кого (в info) скорострел
  int rf;             // игровое значение скорострела
  double chance;      // вычисленный шанс на сл. выстрел
} rapidfire;

// массив структур информации о юнитах
// (читается из конфиг-файла)
// id - в остальных структурах - индекс в этом массиве
typedef struct
{
  char name[64];
  int shield, structure, attack, capacity;
  int metal, crystal, deut;   // стоимость юнита

  struct
  {
    unsigned int ground:1;            // 1 = наземное сооружение
    unsigned int large_chargo:1;      // 1 = большой транспорт
    unsigned int small_chargo:1;      // 1 = малый транспорт
    unsigned int recycler:1;          // 1 = переработчик
  } flags;
  int rapid;
} unit_info;


// структура, описывающая юнит
typedef struct
{
  int id;                       // юнита в таблице units
  int attack, shield, armory;   // параметры юнита
  struct
  {
    int shield, armory;
  } max;
} unit;

// производит симуляцию одного юнита (против одного юнита)
// возвращает истину если можно еще раз атаковать (скорострел)
int attack_unit(const unit * attacker, unit * defender);

// создает юнит скорректированный под параметры игрока
unit create_unit(int id, int gattack, int gshield, int garmory);
#endif
