<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/user.php");
include_once("./functions/utils.php");
include_once("./functions/fileutils.php");
include_once("./functions/cssparser/cssparser.php");

/**
	In this case we do want a default.
*/
function _theme_index()
{
	if(function_exists('theme_index'))
		return theme_index();
	else
	{
		// default - redirect to login page
		// Unsure if this is compatible with all browsers, as the HTTP 302
		// header, may not be added to the reply by all versions of PHP????
		header("Location: login.php");
	}
}

/**
	Do not return anything if not defined.
*/
function _theme_header($title=NULL, $include_menu=TRUE)
{
	if(function_exists('theme_header'))
	{
	    header("Cache-control: no-store");
		header("Pragma: no-store");
		header("Expires: 0");
		
		return theme_header($title, $include_menu!==FALSE && $include_menu!=='N'?TRUE:FALSE);
	}
	else
		return NULL;
}

/**
	Do not return anything if not defined.
*/
function _theme_menu()
{
	if(function_exists('theme_menu'))
		return theme_menu();
	else
		return NULL;
}

/**
	Do not return anything if not defined.
*/
function _theme_refresh_menu()
{
	if(function_exists('theme_refresh_menu'))
		return theme_refresh_menu();
	else
		return NULL;
}

/**
	Do not return anything if not defined.
*/
function _theme_footer()
{
	if(function_exists('theme_footer'))
		return theme_footer();
	else
		return NULL;
}

/**
	Do not return anything if not defined.
*/
function _theme_error($error)
{
	if(function_exists('theme_error'))
		return theme_error($error);
	else
		return $error;
}

/**
	@param $src		The image.ext without any path information.

	Checks for $src in the following directories:
		theme/$_OPENDB_THEME/images/$_OPENDB_LANGUAGE/
		theme/$_OPENDB_THEME/images/
		theme/$_OPENDB_THEME/

		theme/$_OPENDB_DEFAULT_THEME/images/$_OPENDB_LANGUAGE/
		theme/$_OPENDB_DEFAULT_THEME/images/
		theme/$_OPENDB_DEFAULT_THEME/

		images/$_OPENDB_LANGUAGE/
		images/

	Otherwise return FALSE indicating image was not found.
*/
function _theme_image_src($src)
{
	global $_OPENDB_THEME;
	// This theme should be used to search for images, before the theme/default/ directory.
	global $_OPENDB_DEFAULT_THEME;
	global $_OPENDB_LANGUAGE;

	if(strlen($src)>0)
	{
		// Allow a theme to point at a specific theme image, perhaps in another theme location.
		if(function_exists('theme_image_src'))
		{
			$theme_image_src = theme_image_src($src);
			if(strlen($theme_image_src)>0 && file_exists($theme_image_src))
				return $theme_image_src;
		}
		
		if(starts_with($src, 'theme/') || starts_with($src, 'images/') && file_exists($src)) // in case we have already expanded with _theme_image_src previously.
			return $src;
		else if(isset($_OPENDB_THEME) && isset($_OPENDB_LANGUAGE) && file_exists("./theme/$_OPENDB_THEME/images/$_OPENDB_LANGUAGE/$src"))
			return "theme/$_OPENDB_THEME/images/$_OPENDB_LANGUAGE/$src";
		else if(isset($_OPENDB_THEME) && file_exists("./theme/$_OPENDB_THEME/images/$src"))
			return "theme/$_OPENDB_THEME/images/$src";
		else if(isset($_OPENDB_THEME) && file_exists("./theme/$_OPENDB_THEME/$src"))
			return "theme/$_OPENDB_THEME/$src";
		else if(isset($_OPENDB_DEFAULT_THEME)&& isset($_OPENDB_LANGUAGE) && file_exists("theme/$_OPENDB_DEFAULT_THEME/images/$_OPENDB_LANGUAGE/$src"))
			return "theme/$_OPENDB_DEFAULT_THEME/images/$_OPENDB_LANGUAGE/$src";
		else if(isset($_OPENDB_DEFAULT_THEME) && file_exists("theme/$_OPENDB_DEFAULT_THEME/images/$src"))
			return "theme/$_OPENDB_DEFAULT_THEME/images/$src";
		else if(isset($_OPENDB_DEFAULT_THEME) && file_exists("theme/$_OPENDB_DEFAULT_THEME/$src"))
			return "theme/$_OPENDB_DEFAULT_THEME/$src";
		else if(isset($_OPENDB_LANGUAGE) && file_exists("./theme/default/images/$_OPENDB_LANGUAGE/$src"))
			return "theme/default/images/$_OPENDB_LANGUAGE/$src";
		else if(file_exists("./theme/default/images/$src"))
			return "theme/default/images/$src";
		else if(file_exists("./theme/default/$src"))
			return "theme/default/$src";
		else if(isset($_OPENDB_LANGUAGE) && file_exists("./images/$_OPENDB_LANGUAGE/$src"))
			return "images/$_OPENDB_LANGUAGE/$src";
		else if(file_exists("./images/$src"))
			return "images/$src";
	}

	//else
	return FALSE; // no image found.
}

/**
	Will format a complete image url.

	@param $src		The image.ext without any path information.
	@param $alt		The text to provide if the image is not found, or
					The browser does not support images.
	@param $title	The tooltip to include in the image.
	@param $align	The align="???" valign="???" value.
	@param $type	Specifies the origin of the image.  Current types being
					used are:
						s_item_type - for 's_item_type' table images.
						borrowed_item - Borrow system status images.
						action - Item operation (input,borrow actions)
								
	@param $class	The CSS class of the image.	
	@param $width	The width of the image.
	@param $height	The height of the image.

	These are the steps it uses to work out which image to display:
	1)  Checks if 'theme_image' function is defined.  This function
		should return a fully formed <img src="" ...> or a textual 
		equivalent.

		If the theme specific 'theme_image' returns FALSE, this indicates
		that the local function is not taking responsibility for displaying
		the image in this case.  We should continue as though the theme
		specific 'theme_image' function did not exist.
			
	2)	Checks for $src in the following directories:
			theme/$_OPENDB_THEME/images/$_OPENDB_LANGUAGE/
			theme/$_OPENDB_THEME/images/
			theme/$_OPENDB_THEME/
			images/$_OPENDB_LANGUAGE/
			images/

	3)	If $alt is not null, the $alt text will be returned instead 
		of <img ...> tag.  This is even if the $alt=="" (empty string),
		which is new in 0.51-dev6

	4)	Otherwise return the $src, without extension, in initcap format.
*/
function _theme_image($src, $alt=NULL, $title=NULL, $align=NULL, $type=NULL, $class=NULL, $width=NULL, $height=NULL)
{
	if(function_exists('theme_image') && ($value = theme_image($src, $alt, $title, $align, $type, $class, $width, $height))!==FALSE)
		return $value;
	else if ( ($src = _theme_image_src($src)) !== FALSE)
	{
		return "<img src=\"$src\""
			.(strlen($alt)>0?" alt=\"$alt\"":"")
			.(strlen($title)>0?" title=\"$title\"":"")
			.(strlen($class)>0?" class=\"$class\"":"")
			.(strlen($align)>0?" align=\"$align\" valign=\"$align\"":"")
			.(strlen($width)>0?" width=\"$width\"":"")
			.(strlen($height)>0?" height=\"$height\"":"")
			." border=\"0\">";
	}
	else if($type == "action") // Special type, that if not handled, will be handled back at caller instead!
		return FALSE;
	else if($alt!==NULL)
		return $alt;
	else  
	{
		// Get the $src without extension and initcap the result for return.
		// There is not much else we can do in this case, as the $title is not
		// designed to be used in place of the image - it is a tooltip!
		$index = strrpos($src, ".");
		if($index !== FALSE)
			$src = substr($src,0,$index);
		return ucfirst($src);
	}	
}

/**
	Return an array of the following format.

	array(
		image-size =>'image size',
		font-size=>'font size',
		text-color=>'hex color',
		caption-color=>'hex color',
		light-color=>'hex color',
		dark-color=>'hex color',
		light-border-color=>'hex color',
		dark_border-color=>'hex color',
		background-color=>'hex color',
		transparent=>[TRUE|FALSE]);

	See docs/misc/chart.colors.txt for more information
*/

// The defaults as originally hard coded in chart.php
$_default_graph_config = 
		array(
			'image-size'=>'175',
			'font-size'=>'2',
			'text-color'=>'000000',
			'caption-color'=>'004000',
			'light-color'=>'D0DCE0',
			'dark-color'=>'BEC8D6',
			'light-border-color'=>'8E9DE0',
			'dark_border-color'=>'6D78AB',
			'background-color'=>'FFFFFF',
			'transparent'=>FALSE);

function _theme_graph_config()
{
	global $_default_graph_config;
	global $_OPENDB_THEME;

	// Merge the new array into the default, in case any items have not been specified in the custom theme_graph_config!
	if(function_exists('theme_graph_config') && is_not_empty_array($cfgArray = theme_graph_config()))
	{
		// convert old format array to new before merge
		$graph_config['image-size'] = ifempty(ifempty($cfgArray['imgsize'], $cfgArray['image-size']), $_default_graph_config['image-size']);
		$graph_config['font-size'] = ifempty(ifempty($cfgArray['fontsize'], $cfgArray['font-size']), $_default_graph_config['font-size']);
		$graph_config['text-color'] = ifempty(ifempty($cfgArray['text'], $cfgArray['text-color']), $_default_graph_config['text-color']);
		$graph_config['caption-color'] = ifempty(ifempty($cfgArray['captions'], $cfgArray['caption-color']), $_default_graph_config['caption-color']);
		$graph_config['light-color'] = ifempty(ifempty($cfgArray['lt_color'], $cfgArray['light-color']), $_default_graph_config['light-color']);
		$graph_config['dark-color'] = ifempty(ifempty($cfgArray['dk_color'], $cfgArray['dark-color']), $_default_graph_config['dark-color']);
		$graph_config['light-border-color'] = ifempty(ifempty($cfgArray['lt_border'], $cfgArray['light-border-color']), $_default_graph_config['light-border-color']);
		$graph_config['dark-border-color'] = ifempty(ifempty($cfgArray['dk_border'], $cfgArray['dark-border-color']), $_default_graph_config['dark-border-color']);
		$graph_config['background-color'] = ifempty(ifempty($cfgArray['bgcolor'], $cfgArray['background-color']), $_default_graph_config['background-color']);
		$graph_config['transparent'] = ifempty(ifempty($cfgArray['transparent'], $cfgArray['transparent']), $_default_graph_config['transparent']);
		
		return $graph_config;
	}
	else if(file_exists("./theme/$_OPENDB_THEME/style.css") && strlen(($contents = read_file_contents("./theme/$_OPENDB_THEME/style.css", $error)))>0)
	{
		$cssParser =& new cssparser(FALSE);
		$cssParser->ParseStr($contents);
				
		$graph_config['image-size'] = ifempty($cssParser->get('.OpendbStatsGraphs', 'image-size'), $_default_graph_config['image-size']);
		$graph_config['font-size'] = ifempty($cssParser->get('.OpendbStatsGraphs', 'font-size'), $_default_graph_config['font-size']);
		$graph_config['text-color'] = ifempty(str_replace('#', '', ifempty($cssParser->get('.OpendbStatsGraphs','text-color'), $cssParser->get('BODY', 'color'))), $_default_graph_config['text-color']);
		$graph_config['caption-color'] = ifempty(str_replace('#', '', ifempty($cssParser->get('.OpendbStatsGraphs','caption-color'), $cssParser->get('BODY', 'color'))), $_default_graph_config['caption-color']);
		$graph_config['light-color'] = ifempty(str_replace('#', '', ifempty($cssParser->get('.OpendbStatsGraphs','light-color'), $cssParser->get('.top', 'background-color'))), $_default_graph_config['light-color']);
		$graph_config['dark-color'] = ifempty(str_replace('#', '', ifempty($cssParser->get('.OpendbStatsGraphs','dark-color'), $cssParser->get('.top2', 'background-color'))), $_default_graph_config['dark-color']);
		$graph_config['light-border-color'] = ifempty(str_replace('#', '', ifempty($cssParser->get('.OpendbStatsGraphs','light-border-color'), $cssParser->get('.top2', 'background-color'))), $_default_graph_config['light-border-color']);
		$graph_config['dark-border-color'] = ifempty(str_replace('#', '', ifempty($cssParser->get('.OpendbStatsGraphs','dark-border-color'), $cssParser->get('BODY', 'color'))), $_default_graph_config['dark-border-color']);
		$graph_config['background-color'] = ifempty(str_replace('#', '', ifempty($cssParser->get('.OpendbStatsGraphs','background-color'), $cssParser->get('BODY', 'background-color'))), $_default_graph_config['background-color']);
		
		// we need to convert it to a true boolean, as that is what is expected in the code.
		$transparentVal = ifempty($cssParser->get('.OpendbStatsGraphs', 'transparent'), $_default_graph_config['transparent']);
		if(strcasecmp($transparentVal,'true')===0)
			$graph_config['transparent'] = TRUE;
		else
			$graph_config['transparent'] = FALSE;
				
		unset($cssParser);
				
		return $graph_config;
	}
	else
	{	
		// else
		return $_default_graph_config;
	}
}

/**
* Simple overlayed image configuration function
*/
function theme_image_config()
{
	global $_OPENDB_THEME;

	// Merge the new array into the default, in case any items have not been specified in the custom theme_graph_config!
	if(file_exists("./theme/$_OPENDB_THEME/style.css") && strlen(($contents = read_file_contents("./theme/$_OPENDB_THEME/style.css", $error)))>0)
	{
		$cssParser =& new cssparser(FALSE);
		$cssParser->ParseStr($contents);
				
		$config['text-color'] = str_replace('#', '', $cssParser->get('BODY', 'color'));
		$config['background-color'] = str_replace('#', '', $cssParser->get('BODY', 'background-color'));
		
		unset($cssParser);
				
		return $config;
	}
	else
	{	
		// else
		$config['text-color'] = $_default_graph_config['text-color'];
		$config['background-color'] = $_default_graph_config['background-color'];
	}
}

/**
	All we need to do is check if there is a matching theme/$theme/index.php
	script.
*/
function is_legal_theme($theme)
{
	if(file_exists("./theme/$theme/index.php"))
		return true;
	else
		return false;
}

/**
	All we need to do is check if there is a matching theme/$theme/index.php
	script.
	
	The 'printable' theme is a restricted theme!
*/
function is_legal_user_theme($theme)
{
	if($theme !== "printable" && strlen($theme)<=20 && file_exists("./theme/$theme/index.php"))
		return true;
	else
		return false;
}

/**
	Generate a list of user themes.
*/
function get_user_theme_r()
{
	$handle=opendir('./theme');
	while ($file = readdir($handle))
    {
		if(!ereg("^[.]",$file) && is_dir("./theme/$file"))
		{
			if(is_legal_user_theme($file))
			{
				$themes[] = $file;
			}
		}
	}
	closedir($handle);
    
    if(is_array($themes) && count($themes)>0)
		return $themes;
	else // empty array as last resort.
		return array();
}

/**
* 
*/
function get_help_href_link($mask=NULL)
{
	global $_OPENDB_PAGE_HELP_ID;
	global $LANG_VARS;
	global $CONFIG_VARS;
	
	if(strlen($_OPENDB_PAGE_HELP_ID)>0)
	{
		$hreflink = "<a href=\"javascript:popup('".urlencode("help.php?page=".$_OPENDB_PAGE_HELP_ID)."','800','600');\">".replace_lang_var('site', $CONFIG_VARS['site.title'], $LANG_VARS['site_help'])."</a>";
		if($mask!=NULL)
			return str_replace("%hreflink%", $hreflink,	$mask);
		else
			return $hreflink;
	}
}
?>
