#
# plugin.sql site plugin definition
#

#
# Cleanup
#
DELETE FROM s_site_plugin WHERE site_type = 'freedb';
DELETE FROM s_site_plugin_conf WHERE site_type = 'freedb';
DELETE FROM s_site_plugin_input_field WHERE site_type = 'freedb';
DELETE FROM s_site_plugin_link WHERE site_type = 'freedb';
DELETE FROM s_site_plugin_s_attribute_type_map WHERE site_type = 'freedb';
DELETE FROM s_site_plugin_s_attribute_type_lookup_map WHERE site_type = 'freedb';

INSERT INTO s_site_plugin (site_type, classname, order_no, title, image, description, external_url, items_per_page, more_info_url)
VALUES('freedb', 'freedb', 3, 'freedb2.org', 'freedb.gif', 'A free approach to cddbp.', 'http://www.freedb2.org', 50, 'http://www.freedb2.org/freedb/{cddbgenre}/{freedb_id}');

#
# Input Fields
#	
INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('freedb', 'title', 1, '', '<i>Artist / Title</i> Search', 'text', '', '{ifdef(artist, \'{artist} / \')}{title}');

INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('freedb', 'freedb_id', 2, '', 'Freedb ID', 'hidden', '', '{freedb_id}');

INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('freedb', 'cddbgenre', 3, '', 'CDDB Genre', 'hidden', '', '{cddbgenre}');

#
# Links
#
INSERT INTO s_site_plugin_link(site_type, s_item_type_group, s_item_type, order_no, description, url, title_url)
VALUES('freedb', '*', '*', 1, 'More Info', 'http://www.freedb2.org/freedb/{cddbgenre}/{freedb_id}', '');

#
# site variable to s_attribute_type mapping
#
INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('freedb', 'title', '*', '*', 'ALT_TITLE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('freedb', 'title', '*', '*', 'S_TITLE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('freedb', 'run_time', '*', '*', 'CDTIME');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('freedb', 'tracks', '*', '*', 'CDTRACK');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('freedb', 'genre', '*', '*', 'MUSICGENRE');

####################################################################################################
# Item Type / Attribute Type relationships
####################################################################################################

INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'FREEDB_ID', 'Freedb ID', 'Disc ID', 'hidden', 'hidden', NULL, 'freedb');
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'CDDBGENRE', 'CDDB Genre', 'Genre', 'hidden', 'hidden', NULL, 'freedb');

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'FREEDB_ID', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDDBGENRE', '0', NULL, NULL);
