<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
	
	Plugin created by Laurent Chauvin <lchauvin@yahoo.com>
	Converted to 0.81 format by Jason Pell <jasonpell@users.sourceforge.net>
	
	//
	// Search for 'Hitchcock' to return a list of various titles.
	// Search for 'Folie des grandeurs' to get an exact title match.
	// Search for 'anticonstitutionnellement' to trigger a search error.
	//
	
	-- CHANGLOG --
		
	Version		Comments
	-------		--------
	0.81		Initial 0.81 compliant release.
*/
include_once("./functions/SitePlugin.class.inc");

// Used parse_amazonfr_data to convert any html entities that cannot
// be displayed in a textarea.
$html_entity_lookup_table = array('8211'=>'-');

function strip_text($text)
{
	global $html_entity_lookup_table;
	
	$text = unhtmlentities(strip_tags($text));
	$text = strtr($text, chr(160), ' ');
	$text = convert_html_numeric_codes($text,$html_entity_lookup_table);
	
	// Replace any tabs or newlines with spaces.
	$text = trim(ereg_replace("[\r\n\t]+"," ", $text));
	
	return $text;
}

class amazonfr extends SitePlugin
{
	var $_pageBuffer;
	
	function amazonfr($site_type)
	{
		parent::SitePlugin($site_type);
	}
	
	function queryListing($page_no, $items_per_page, $offset, $s_item_type, $search_vars_r)
	{
		if(strlen($search_vars_r['amazfrasin'])>0)
		{
			$this->addListingRow(NULL, NULL, NULL, array('amazfrasin'=>$search_vars_r['amazfrasin']));
			return TRUE;
		}
		else
		{
			// Get the mapped AMAZON index type
			$index_type = ifempty($this->getConfigValue('item_type_to_index_map', $s_item_type), strtolower($s_item_type));
			
			$queryUrl = 'http://www.amazon.fr/exec/obidos/external-search?index='.$index_type.'&keyword='.rawurlencode($search_vars_r['title']).'&sz='.$items_per_page.'&pg='.$page_no;
			$this->_pageBuffer = $this->fetchURI($queryUrl);
		}
		
		if(strlen($this->_pageBuffer)>0)
		{
			$amazfrasin = FALSE;
			
			// check for an exact match, but not if this is second page of listings or more
			if(!$this->isPreviousPage())
			{
				if (preg_match("/ASIN&nbsp;:(.+?)$/ms", $read, $regs))
				{
					$amazfrasin = trim($regs[1]);
				}
				else if (preg_match("/ASIN: <font>(\w{10})<\/font>/", $this->_pageBuffer, $regs))
				{
					$amazfrasin = trim($regs[1]);
				}
				else if (preg_match("/ASIN: (\w{10})/", strip_tags($this->_pageBuffer), $regs))
				{
					$amazfrasin = trim($regs[1]);
				}
				else if (preg_match ("/ISBN: ([^;]+);/", strip_tags($this->_pageBuffer), $regs)) // for books, ASIN is the same as ISBN
				{
					$amazfrasin = trim ($regs[1]);
				} 
			}
			
			// exact match
			if($amazfrasin!==FALSE)
			{
				// single record returned
				$this->addListingRow(NULL, NULL, NULL, array('amazfrasin'=>$amazfrasin));
				
				return TRUE;
			}
			else
			{
				if(preg_match("/([0-9]+) r&eacute;sultats au total pour/i", $this->_pageBuffer, $regs))
				{
					// store total count here.
					$this->setTotalCount($regs[1]);
					
					$start_of_block = strpos($this->_pageBuffer, "sultats au total pour", $start_of_block);
					if($start_of_block!==FALSE)
					{
						$parseblock = substr($this->_pageBuffer, $start_of_block);
						if(preg_match_all(":<a href=/exec/obidos/ASIN/([^/]+)/[^>]+><b>([^<]*)</b></a>$:m", $parseblock, $matches))
						{
							for ($i = 0; $i < count($matches[1]); $i++)
							{
								$thumbimg = NULL;
								
								if(preg_match("!<img src=\"(http://.*".$matches[1][$i].".*jpg\")[^<]*>!U", $parseblock, $regs))
									$thumbimg = $regs[1];
								
								// get rid of new lines.
								$title = preg_replace("/[ \t\r\n]+/", " ", $matches[2][$i]);
								
								$this->addListingRow($title, $thumbimg, NULL, array('amazfrasin'=>$matches[1][$i]));
							}
							
							return TRUE;
						}
					}
				}
			}
			
			//default
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
	
	/**
	* 
	*/
	function queryItem($search_attributes_r, $s_item_type)
	{
		$this->_pageBuffer = $this->fetchURI('http://www.amazon.fr/exec/obidos/ASIN/'.$search_attributes_r['amazfrasin']);
		
		// no sense going any further here.
		if(strlen($this->_pageBuffer)==0)
			return FALSE;
		
		//<title>
//Amazon.fr&nbsp;:&#160; Rambo III : DVD </title>

		if(preg_match("/<title>.*Amazon\.fr[^:]*:(.*)<\/title>/ms", $this->_pageBuffer, $regs))
		{
			// If extra year appended, remove it and just get the title.
			if(preg_match("/(.*)\[[0-9]+\]:(.*)$/m", trim($regs[1]), $regs2))
				$title = $regs2[1];
			else if(preg_match("/(.*)\([0-9]+\)$/m", trim($regs[1]), $regs2))
				$title = $regs2[1];
			else
				$title = $regs[1];
			
			$indexOf = laststrpos($title, ":");
			if($indexOf!==FALSE)
			{
				if( preg_match("/[A-Z]+$/", trim(substr($title, $indexOf+1)) ))
				{
					$title = substr($title, 0, $indexOf);
				}
			}
			
			$title = str_replace("&#160;", "", $title);
			
			$this->addItemAttribute('title', convert_html_numeric_codes(strip_tags(trim(str_replace("\"", "", $title)))));
		}
		
		// Image src extraction block
		//http://images-eu.amazon.com/images/P/B000050YLW.02._PE68_SCMZZZZZZZ_.jpg
		if (preg_match_all("!\"(http://images-eu.amazon.com/[^\"]+".$search_attributes_r['amazukasin']."[^\"]+)\"!", $this->_pageBuffer, $regs))
		{
			$imageurl = NULL;
			$timageurl = NULL;
			
			// try for a big image first, otherwise get the smaller one.			
			for($i = 0; $i < count($regs[1]); $i++)
			{
				if(strpos($regs[1][$i], "LZZZZZZ") !== FALSE)
				{
					$imageurl = $regs[1][$i];
					break;
				}
				
				if(strpos($regs[1][$i], "ZZZZZZZ") !== FALSE)
				{
					$timageurl = $regs[1][$i];
				}
			}
			
			if($imageurl == NULL && timageurl != NULL)
				$imageurl = $timageurl;
						
			// If still null!
			if($imageurl == NULL)
			{
				// If first image has 'THUM' in it, we have matched a thumbnail,
				// get the next one instead.
				// 'Breath Fire III' (GAME) is such a case.
				if(count($regs[1])>1 && strpos($regs[1][0],"THUM")!==FALSE)
					$imageurl = $regs[1][1];
				else
					$imageurl = $regs[1][0];
			}
			
			if(strlen($imageurl))
			{
				$this->addItemAttribute('imageurl', $imageurl);
			}
		}
		
		if (preg_match("/<span class=listprice>\\\$([^<]*)<\/span>/i", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('listprice', $regs[1]);
		}
		else if (preg_match("/<font [^>]*>[\n\r]&nbsp;EUR ([^<]+)<\/font>/im", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('listprice', preg_replace('/,/', '.', trim($regs[1])));
		}
		
		//<br> Studio : Lucas Film<BR>
		if (preg_match("/<br>[\s]*Studio[\s]*:[\s]*([^<]+)<br>/i", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('studio', $regs[1]);
		}
	
		// Director extraction block
		if (preg_match("/alisateur.*<a.*>(.*?)<\/a>/", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('director', $regs[1]);
		}
	
		// Actor extraction block
		if (preg_match("/Avec[^:]*:(.*?)<br>/", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('actors', str_replace("&nbsp;", " ", trim(strip_tags($regs[1]))));
		}
	
		// Region extraction block
		if (preg_match("/Zone ([0-6])/", $this->_pageBuffer, $regs))
			$this->addItemAttribute('dvd_region', $regs[1]);
		else
			$this->addItemAttribute('dvd_region', '2'); //otherwise assume region 2
	
		// Duration extraction block - Exists for VHS format.
		//Dur&eacute;e&nbsp;: 120 minutes
		if (preg_match("/Dur&eacute;e&nbsp;: ([0-6]+) minutes/", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('run_time', $regs[1]);
		}
		
		// Video format block (PAL,NTSC,SECAM)
		if(preg_match("/Format([^<]+)</", $this->_pageBuffer, $regs))
		{
			$format = strtoupper(trim($regs[1]));
			if(strpos($format, "SECAM")!==FALSE)
				$this->addItemAttribute('vid_format', 'SECAM');
			else if(strpos($format, "NTSC")!==FALSE)
				$this->addItemAttribute('vid_format', 'NTSC');
			else //if(strpos($format, "PAL")!==FALSE) -- default
				$this->addItemAttribute('vid_format', 'PAL');
		}
	
		// Edition details block - 'dvd_extras' attribute
		if (preg_match("/<b>D&eacute;tails de l&#39;&eacute;dition&nbsp;:<\/b><br>(.+?)&#149;&nbsp;ASIN&nbsp;:/si", $this->_pageBuffer, $regs))
		{
			if(preg_match_all("/&#[0-9]+;(.*?)<br>/is", $regs[1], $matches))
			{
				$dvd_extras = "";
				
				while(list(,$item) = @each($matches[1]))
				{
					$item = convert_html_numeric_codes(strip_tags($item),$html_entity_lookup_table);
					$item = strtr($item, array_flip(get_html_translation_table(HTML_ENTITIES, ENT_QUOTES)));
					// We may have a hard space here, so get rid of it.
					$item = trim(strtr($item, chr(160), ' '));
					
					// Don't include the format or region (zone)
					if(strlen($item)>0 && 
							strpos($item, "Zone")===FALSE && 
							strpos($item, "Format")===FALSE && 
							strpos($item, "Secam")===FALSE && 
							strpos($item, "Origine")===FALSE &&
							strpos($item, "Dure")===FALSE)
					{
						if(preg_match("/Titre Original :([^$]+)$/mi", $item, $regs))
						{
							$this->addItemAttribute('alt_title', unhtmlentities(strip_tags($regs[1])));
						}
						else if(preg_match("/Le film \(([^\)]+)\)/i", $item, $regs)) //(2h10)
						{
							if(preg_match("/([0-9]+)h([0-9]*)/", $regs[1], $regs2))
							{
								$this->addItemAttribute('run_time', ($regs2[1]*60) + (is_numeric($regs2[2])?$regs2[2]:0));
							}
						}
						else
							$dvd_extras .= $item."\n";
					}
				}
				
				if(strlen($dvd_extras)>0)
				{
					$this->addItemAttribute('dvd_extras', $dvd_extras);
				}
			}
		}
	
		// Plot(s) search -  Currently broken
		/*if(preg_match_all(":<p><b>[^<]*</b><br>(.*)(?=<p):Us", $this->_pageBuffer, $regs))
		{
			while (list(,$plot) = @each($regs[1]))
			{
				$plot = convert_html_numeric_codes(strip_tags($plot),$html_entity_lookup_table);
				$plot = strtr($plot, array_flip(get_html_translation_table(HTML_ENTITIES, ENT_QUOTES)));
				// We may have a hard space here, so get rid of it.
				$plot = trim(strtr($plot, chr(160), ' '));
	
				// Replace any tabs or newlines with spaces.
				$this->addItemAttribute('blurb', ereg_replace("[\r\n\t]+"," ", $plot));
			}
		}*/
		
		// Get the first review only!
		if( ($revidx = strpos($this->_pageBuffer, "<a name=\"amzn-reviews\">"))!==FALSE)
		{
			if(preg_match("/<span class=\"serif\">([^$]+)<\/span>$/Umi", substr($this->_pageBuffer,$revidx), $regs))
			{
				if(preg_match("/([^$]+)<i>--([^$]+)<\/i>$/Umi", trim($regs[1]), $regs2))
				{
					$plot = strip_text($regs2[1]);
					$author = strip_text($regs2[2]);
					if(strlen($author)>0)
						$plot .= "\n-- $author";
				}
				else
				{
					$plot = strip_text($regs2[1]);
				}
				
				$this->addItemAttribute('blurb', $plot);
			}
		}
		
		// If possible, fetch additional (technical) info from the site
		if (preg_match(":<a href=(.*)>Tous les d.*tails techniques:U", $this->_pageBuffer, $regs))
		{
			$detailPage =  $this->fetchURI("http://www.amazon.fr" . $regs[1]);
	
			// Fetch the information if page not empty
			if(strlen($detailPage)>0)
			{
				// Ratio
				if (preg_match("/image([^<]*)<br>/Ui", $detailPage, $regs))
				{
					if(preg_match_all("/([0-9]{1}\.[0-9]+):1/", $regs[1], $matches))
					{
						$this->addItemAttribute('ratio', $matches[1]);
					}
				}
	
				// Spoken languages
				if (preg_match(":Langues et formats sonores([^<]*)<br>:Ui", $detailPage, $regs))
				{
					if (strpos($regs[1], "Anglais (Dolby Digital 5.1)") !== FALSE)
						$this->addItemAttribute('audio_lang', 'ENGLISH_5.1');
					else if (strpos($regs[1], "Anglais") !== FALSE)
						$this->addItemAttribute('audio_lang', 'ENGLISH');
	
					if (strpos($regs[1], "Franais") !== FALSE)
						$this->addItemAttribute('audio_lang', 'FRENCH');
					if (strpos($regs[1], "Allemand") !== FALSE)
						$this->addItemAttribute('audio_lang', 'GERMAN');
					if (strpos($regs[1], "Espagnol") !== FALSE)
						$this->addItemAttribute('audio_lang', 'SPANISH');
					if (strpos($regs[1], "Italien") !== FALSE)
						$this->addItemAttribute('audio_lang', 'ITALIAN');
				}
	
				// Subtitles
				if (preg_match(":Sous-titres([^<]*)<br>:Ui", $detailPage, $regs))
				{
					if (strpos($regs[1], "Anglais") !== FALSE)
						$this->addItemAttribute('subtitles', 'ENGLISH');
					if (strpos($regs[1], "Franais") !== FALSE)
						$this->addItemAttribute('subtitles', 'FRENCH');
					if (strpos($regs[1], "Allemand") !== FALSE)
						$this->addItemAttribute('subtitles', 'GERMAN');
					if (strpos($regs[1], "Espagnol") !== FALSE)
						$this->addItemAttribute('subtitles', 'SPANISH');
					if (strpos($regs[1], "Italien") !== FALSE)
						$this->addItemAttribute('subtitles', 'ITALIAN');
				}
			}
		}
	
		// Certification extraction block
		// Doesn't exist for french movies...
		$this->addItemAttribute('age_rating', 'NR');
	
		// year extraction block
		// Not available from Amazonfr
	
		//echo("<pre>");
		//print_r($this->getItemData());
		//echo("</pre>");
	
		return TRUE;
	}
}
?>