<?php
/* 	
	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/**
*/
function theme_index()
{
	// default - redirect to login page!
	header("Location: login.php");	
}

/**
	Assumes that if $uid is set, session is valid!
*/
function theme_header($title, $include_menu)
{
	global $CONFIG_VARS;
	global $LANG_VARS;
	global $_OPENDB_THEME;
	
	echo("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">".
		"\n<html>".
		"\n<head>".
		"\n	<title>".$CONFIG_VARS['site.title']." ".$CONFIG_VARS['site.version'].(!empty($title)?" - $title":"")."</title>".
		"\n	<link rel=\"stylesheet\" type=\"text/css\" href=\"theme/$_OPENDB_THEME/style.css\">".
		// This works on Mozilla, but not on IE!
		"<link rel=\"icon\" href=\"images/icon.gif\" type=\"image/gif\" />".
		"\n</head>".
		"\n<body>".
		"<table height=100% width=100% cellpadding=5 border=0>".
		"<tr>");
	
	if($include_menu)
		theme_menu();
		
	echo("<td valign=top>".
		"\n<div align=\"right\">".
		"\n<h1>".$CONFIG_VARS['site.title']." ".$CONFIG_VARS['site.version']."</h1>".
		get_help_href_link("[%hreflink%]").
		"\n</div>");
}

/**
	You can put something else in the footer if you want!!!
*/
function theme_footer()
{
	echo "</td></tr></table>".
		"\n</body>".
		"\n</html>";
}

/**
	If $uid set, we assume that session is valid!
*/
function theme_menu()
{
	include_once("./functions/user.php");

	global $CONFIG_VARS;
	global $CONFIG_VARS;
	global $LANG_VARS;
	global $_OPENDB_THEME;
	global $HTTP_SESSION_VARS;
	
	echo("<td nowrap valign=top width=200 class=\"menubar\">".
		"\n<div class=\"fineprint\">".
		"\n<img src=\"images/icon.gif\" alt=\"".$CONFIG_VARS['site.title']."\" align=bottom border=0>".
		"\n<i>".$CONFIG_VARS['site.title']." ".$CONFIG_VARS['site.version']."</i>".
		"\n</div>".
		"\n<br>");
	
	if(!is_site_public_access_enabled() && !empty($HTTP_SESSION_VARS['user_id']))
	{
	 	echo("\n".replace_lang_var("user_id", $HTTP_SESSION_VARS['user_id'], $LANG_VARS['uid_is_logged_in']).
			"<br>");
	}
	
	echo("\n<div class=\"menutext\"><br>");
	$menu_options = get_menu_options($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']);
	if(is_array($menu_options['normal']))
	{
		echo get_table_menu_options($menu_options['normal'], 1, "<b>%option%</b>", array('cellpadding'=>0,'cellspacing'=>0));
	}

	if(is_array($menu_options['admin']))
	{
		echo("\n<br><hr>".
			"\n".$LANG_VARS['admin'].":<br><br>".
			get_table_menu_options($menu_options['admin'], 1, NULL, array('cellpadding'=>1,'cellspacing'=>0)).
			"\n<br>".
			"\n<p><div class=\"fineprint\"><i>".replace_lang_var("host", $CONFIG_VARS['db_server.dbname']."@".$CONFIG_VARS['db_server.host'], $LANG_VARS['connected_to'])."</i></div></p>");
	}
	echo("\n</div>");
	echo("\n</td>");
}

/**
	Displays an error page.
*/
function theme_error($error)
{
	echo("\n<div CLASS=\"error\">$error</div>");
}
?>
